/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.uimacpp;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_component.AnalysisComponent_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.impl.AnalysisEngineImplBase;
import org.apache.uima.analysis_engine.metadata.SofaMapping;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.ComponentInfo;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.impl.CASMgrSerializer;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.uimacpp.InternalTafException;
import org.apache.uima.uimacpp.UimacppEngine;
import org.apache.uima.uimacpp.UimacppException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.xml.sax.SAXException;

public class UimacppAnalysisComponent
extends AnalysisComponent_ImplBase {
    private UimacppEngine engine;
    private AnalysisEngineImplBase ae;
    private ResourceCreationSpecifier resourceDescription;
    private Logger log;
    private boolean tsReinit;
    private UimaContext uimaContext;
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private static final Class<UimacppAnalysisComponent> CLASS_NAME = UimacppAnalysisComponent.class;
    private static final int TAF_LOGLEVEL_OFF = 0;
    private static final int TAF_LOGLEVEL_MESSAGE = 1;
    private static final int TAF_LOGLEVEL_WARNING = 2;
    private static final int TAF_LOGLEVEL_ERROR = 3;

    public UimacppAnalysisComponent(ResourceCreationSpecifier aeDescription, AnalysisEngineImplBase ae) {
        this.ae = ae;
        this.resourceDescription = (ResourceCreationSpecifier)aeDescription.clone();
        ((ProcessingResourceMetaData)this.resourceDescription.getMetaData()).setFsIndexCollection(null);
        this.tsReinit = true;
    }

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        try {
            this.uimaContext = context;
            if (this.resourceDescription instanceof AnalysisEngineDescription && !((AnalysisEngineDescription)this.resourceDescription).isPrimitive()) {
                ComponentInfo compInfo = ((UimaContextAdmin)context).getComponentInfo();
                SofaMapping[] aggSofaMapping = ((AnalysisEngineDescription)this.resourceDescription).getSofaMappings();
                if (aggSofaMapping != null && aggSofaMapping.length > 0) {
                    for (int i = 0; i < aggSofaMapping.length; ++i) {
                        String string = compInfo.mapToSofaID(aggSofaMapping[i].getAggregateSofaName());
                        aggSofaMapping[i].setAggregateSofaName(string);
                    }
                }
            }
            this.log = context.getLogger();
            AnalysisEngineDescription aed = (AnalysisEngineDescription)this.resourceDescription;
            ConfigurationParameterSettings parmSettings = aed.getAnalysisEngineMetaData().getConfigurationParameterSettings();
            Map<String, NameValuePair[]> groups = parmSettings.getSettingsForGroups();
            for (Map.Entry<String, NameValuePair[]> group : groups.entrySet()) {
                for (NameValuePair nvp : group.getValue()) {
                    Object v = context.getConfigParameterValue(group.getKey(), nvp.getName());
                    if (null == v) continue;
                    parmSettings.setParameterValue(group.getKey(), nvp.getName(), v);
                }
            }
            for (NameValuePair nvp : parmSettings.getParameterSettings()) {
                Object v = context.getConfigParameterValue(nvp.getName());
                if (null == v) continue;
                parmSettings.setParameterValue(nvp.getName(), v);
            }
            if (this.engine == null) {
                UimacppEngine.configureResourceManager(System.getProperty("java.io.tmpdir"), this.ae.getResourceManager().getDataPath());
                StringWriter stringWriter = new StringWriter();
                this.resourceDescription.toXML(stringWriter);
                stringWriter.close();
                this.engine = UimacppEngine.createJTafTAE(stringWriter.getBuffer().toString());
            }
        }
        catch (UimacppException e) {
            this.logJTafException(e);
            throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{this.resourceDescription.getMetaData().getName(), this.resourceDescription.getSourceUrlString()}, e);
        }
        catch (SAXException e) {
            throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{this.resourceDescription.getMetaData().getName(), this.resourceDescription.getSourceUrlString()}, e);
        }
        catch (IOException e) {
            throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{this.resourceDescription.getMetaData().getName(), this.resourceDescription.getSourceUrlString()}, e);
        }
    }

    public void typeSystemInit(TypeSystem ts) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        this.tsReinit = true;
    }

    @Override
    public void reconfigure() {
        this.destroy();
        this.engine = null;
        ConfigurationParameterSettings settings = this.ae.getUimaContextAdmin().getConfigurationManager().getCurrentConfigParameterSettings(this.ae.getUimaContextAdmin().getQualifiedContextName());
        this.resourceDescription.getMetaData().setConfigurationParameterSettings(settings);
    }

    public void process(CAS cas, ResultSpecification aResultSpec) throws AnnotatorProcessException {
        try {
            if (this.engine == null) {
                UimacppEngine.configureResourceManager(System.getProperty("java.io.tmpdir"), this.ae.getResourceManager().getDataPath());
                StringWriter strWriter = new StringWriter();
                this.resourceDescription.toXML(strWriter);
                strWriter.close();
                this.engine = UimacppEngine.createJTafTAE(strWriter.getBuffer().toString());
                this.tsReinit = true;
            }
            if (this.tsReinit) {
                this.tsReinit = false;
                CASMgrSerializer serializer = Serialization.serializeCASMgr((CASMgr)((Object)cas));
                this.engine.typeSystemInit(serializer);
            }
            this.engine.process(aResultSpec, cas, false);
        }
        catch (UimacppException e) {
            this.logJTafException(e);
            throw new AnnotatorProcessException(e);
        }
        catch (SAXException e) {
            throw new AnnotatorProcessException(e);
        }
        catch (IOException e) {
            throw new AnnotatorProcessException(e);
        }
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        try {
            this.process(aCAS, null);
        }
        catch (AnnotatorProcessException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Override
    public void process(AbstractCas aCAS) throws AnalysisEngineProcessException {
        this.process((CAS)aCAS);
    }

    @Override
    public boolean hasNext() throws AnalysisEngineProcessException {
        try {
            if (this.engine != null) {
                return this.engine.hasNext();
            }
        }
        catch (UimacppException e) {
            this.logJTafException(e);
            throw new UIMARuntimeException(e);
        }
        return false;
    }

    @Override
    public AbstractCas next() throws AnalysisEngineProcessException {
        try {
            if (this.engine != null) {
                CAS cas = this.getEmptyCAS();
                this.engine.next(cas);
                return cas;
            }
        }
        catch (UimacppException e) {
            this.logJTafException(e);
            throw new UIMARuntimeException(e);
        }
        return null;
    }

    public Class<CAS> getRequiredCasInterface() {
        return CAS.class;
    }

    @Override
    public int getCasInstancesRequired() {
        return 1;
    }

    @Override
    public void batchProcessComplete() throws AnalysisEngineProcessException {
        try {
            if (this.engine != null) {
                this.engine.batchProcessComplete();
            }
        }
        catch (UimacppException e) {
            this.logJTafException(e);
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        try {
            if (this.engine != null) {
                this.engine.collectionProcessComplete();
            }
        }
        catch (UimacppException e) {
            this.logJTafException(e);
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    public void destroy() {
        try {
            if (this.engine != null) {
                this.engine.destroy();
                this.engine = null;
            }
        }
        catch (UimacppException e) {
            this.logJTafException(e);
            throw new UIMARuntimeException(e);
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public static int getLoggingLevel() {
        Logger uimacppLogger = UIMAFramework.getLogger(UimacppAnalysisComponent.class);
        if (uimacppLogger.isLoggable(Level.FINEST) || uimacppLogger.isLoggable(Level.FINER) || uimacppLogger.isLoggable(Level.FINE) || uimacppLogger.isLoggable(Level.CONFIG) || uimacppLogger.isLoggable(Level.INFO)) {
            return 1;
        }
        if (uimacppLogger.isLoggable(Level.WARNING)) {
            return 2;
        }
        if (uimacppLogger.isLoggable(Level.SEVERE)) {
            return 3;
        }
        return 0;
    }

    public static void log(int msglevel, String sourceClass, String sourceMethod, String message) {
        Logger uimacppLogger = UIMAFramework.getLogger(UimacppAnalysisComponent.class);
        Level level = Level.INFO;
        if (msglevel == 1) {
            level = Level.INFO;
        } else if (msglevel == 2) {
            level = Level.WARNING;
        } else if (msglevel == 3) {
            level = Level.SEVERE;
        }
        if (sourceMethod.length() > 0) {
            uimacppLogger.log(level, sourceClass + "::" + sourceMethod + ": " + message);
        } else {
            uimacppLogger.log(level, sourceClass + ": " + message);
        }
    }

    private void logJTafException(UimacppException e) {
        if (e.getEmbeddedException() instanceof InternalTafException) {
            InternalTafException tafExc = (InternalTafException)e.getEmbeddedException();
            long errorCode = tafExc.getTafErrorCode();
            String errorName = "";
            try {
                errorName = UimacppEngine.getErrorMessage(errorCode);
            }
            catch (UimacppException jtafexc) {
                this.log.logrb(Level.SEVERE, CLASS_NAME.getName(), "logJTafException", LOG_RESOURCE_BUNDLE, "UIMA_error_while_getting_name__SEVERE", jtafexc.getMessage());
                errorName = "";
            }
            this.log.logrb(Level.SEVERE, CLASS_NAME.getName(), "logJTafException", LOG_RESOURCE_BUNDLE, "UIMA_taf_internal_exception__SEVERE", new Object[]{errorCode, errorName});
        }
        Exception et = e.getEmbeddedException();
        this.log.log(Level.SEVERE, et.getMessage(), et);
    }

    protected CAS getEmptyCAS() {
        return this.uimaContext.getEmptyCas(CAS.class);
    }
}

