/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.impl.BuiltinTypeKinds;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.FsGenerator3;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.WeakIdentityMap;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public abstract class FSClassRegistry {
    private static final MethodHandles.Lookup defaultLookup = MethodHandles.lookup();
    private static final MethodType findConstructorJCasCoverType = MethodType.methodType(Void.TYPE, TypeImpl.class, CASImpl.class);
    private static final MethodType callsiteFsGenerator = MethodType.methodType(FsGenerator3.class);
    private static final MethodType fsGeneratorType = MethodType.methodType(TOP.class, TypeImpl.class, CASImpl.class);
    private static final JCasClassInfo[] jcasClassesInfoForBuiltins;
    private static final List<MethodHandle> methodHandlesForInt;
    private static final WeakIdentityMap<ClassLoader, Map<String, JCasClassInfo>> cl_to_type2JCas;
    private static ThreadLocal<List<ErrorReport>> errorSet;

    private static void loadBuiltins(TypeImpl ti, ClassLoader cl, Map<String, JCasClassInfo> type2jcci, ArrayList<MutableCallSite> callSites_toSync) {
        String typeName = ti.getName();
        if (BuiltinTypeKinds.creatableBuiltinJCas.contains(typeName) || typeName.equals("uima.cas.Sofa")) {
            JCasClassInfo jcci = FSClassRegistry.getOrCreateJCasClassInfo(ti, cl, type2jcci, defaultLookup);
            assert (jcci != null);
            FSClassRegistry.updateOrValidateAllCallSitesForJCasClass(jcci.jcasClass, ti, callSites_toSync);
            FSClassRegistry.jcasClassesInfoForBuiltins[ti.getCode()] = jcci;
        }
        for (TypeImpl subType : ti.getDirectSubtypes()) {
            FSClassRegistry.loadBuiltins(subType, cl, type2jcci, callSites_toSync);
        }
    }

    private static synchronized void loadJCasForTSandClassLoader(TypeSystemImpl ts, boolean isDoUserJCasLoading, ClassLoader cl, Map<String, JCasClassInfo> type2jcci) {
        for (int typecode = 1; typecode < jcasClassesInfoForBuiltins.length; ++typecode) {
            JCasClassInfo jcci = jcasClassesInfoForBuiltins[typecode];
            if (jcci == null) continue;
            Class<? extends TOP> jcasClass = jcci.jcasClass;
            type2jcci.putIfAbsent(jcasClass.getCanonicalName(), jcci);
            FSClassRegistry.setTypeFromJCasIDforBuiltIns(jcci, ts, typecode);
        }
        if (isDoUserJCasLoading) {
            MethodHandles.Lookup lookup = FSClassRegistry.getLookup(cl);
            ArrayList<MutableCallSite> callSites_toSync = new ArrayList<MutableCallSite>();
            FSClassRegistry.maybeLoadJCasAndSubtypes(ts, ts.topType, type2jcci.get(TOP.class.getCanonicalName()), cl, type2jcci, callSites_toSync, lookup);
            MutableCallSite[] sync = callSites_toSync.toArray(new MutableCallSite[callSites_toSync.size()]);
            MutableCallSite.syncAll(sync);
            FSClassRegistry.checkConformance(ts, ts.topType, type2jcci);
        }
        FSClassRegistry.reportErrors();
    }

    private static void setTypeFromJCasIDforBuiltIns(JCasClassInfo jcci, TypeSystemImpl tsi, int typeCode) {
        int v = jcci.jcasType;
        if (v >= 0) {
            tsi.setJCasRegisteredType(v, tsi.getTypeForCode(typeCode));
        }
    }

    private static void maybeLoadJCasAndSubtypes(TypeSystemImpl tsi, TypeImpl ti, JCasClassInfo copyDownDefault_jcasClassInfo, ClassLoader cl, Map<String, JCasClassInfo> type2jcci, ArrayList<MutableCallSite> callSites_toSync, MethodHandles.Lookup lookup) {
        JCasClassInfo jcci_or_copyDown;
        JCasClassInfo jcci = FSClassRegistry.getOrCreateJCasClassInfo(ti, cl, type2jcci, lookup);
        if (null != jcci && tsi.isCommitted()) {
            FSClassRegistry.updateOrValidateAllCallSitesForJCasClass(jcci.jcasClass, ti, callSites_toSync);
        }
        JCasClassInfo jCasClassInfo = jcci_or_copyDown = jcci == null ? copyDownDefault_jcasClassInfo : jcci;
        if (!ti.isPrimitive()) {
            ti.setJavaClass(jcci_or_copyDown.jcasClass);
        }
        for (TypeImpl subtype : ti.getDirectSubtypes()) {
            FSClassRegistry.maybeLoadJCasAndSubtypes(tsi, subtype, jcci_or_copyDown, cl, type2jcci, callSites_toSync, lookup);
        }
    }

    public static JCasClassInfo getOrCreateJCasClassInfo(TypeImpl ti, ClassLoader cl, Map<String, JCasClassInfo> type2jcci, MethodHandles.Lookup lookup) {
        JCasClassInfo jcci = type2jcci.get(ti.getJCasClassName());
        if (jcci == null) {
            jcci = FSClassRegistry.maybeCreateJCasClassInfo(ti, cl, type2jcci, lookup);
        }
        if (jcci != null && jcci.jcasType >= 0) {
            ti.getTypeSystem().setJCasRegisteredType(jcci.jcasType, ti);
        }
        return jcci;
    }

    static JCasClassInfo maybeCreateJCasClassInfo(TypeImpl ti, ClassLoader cl, Map<String, JCasClassInfo> type2jcci, MethodHandles.Lookup lookup) {
        JCasClassInfo jcci = FSClassRegistry.createJCasClassInfo(ti, cl, lookup);
        if (null != jcci) {
            type2jcci.put(ti.getJCasClassName(), jcci);
        }
        return jcci;
    }

    public static JCasClassInfo createJCasClassInfo(TypeImpl ti, ClassLoader cl, MethodHandles.Lookup lookup) {
        Class<? extends TOP> clazz = FSClassRegistry.maybeLoadJCas(ti, cl);
        if (null == clazz || !TOP.class.isAssignableFrom(clazz)) {
            return null;
        }
        int jcasType = -1;
        if (!Modifier.isAbstract(clazz.getModifiers()) && (jcasType = Misc.getStaticIntFieldNoInherit(clazz, "typeIndexID")) == -1) {
            FSClassRegistry.add2errors(errorSet, new CASRuntimeException("JCAS_MISSING_TYPEINDEX", clazz.getName()), false);
            return null;
        }
        return FSClassRegistry.createJCasClassInfo(clazz, ti, jcasType, lookup);
    }

    private static boolean compare_C_T(Class<?> clazz, TypeImpl ti) {
        return ti.getJCasClassName().equals(clazz.getName());
    }

    private static void validateSuperClass(JCasClassInfo jcci, TypeImpl ti) {
        TypeImpl superType;
        Class<? extends TOP> superClass = jcci.jcasClass.getSuperclass();
        if (FSClassRegistry.compare_C_T(superClass, superType = ti.getSuperType())) {
            return;
        }
        for (TypeImpl st : ti.getAllSuperTypes()) {
            if (!FSClassRegistry.compare_C_T(superClass, st)) continue;
            return;
        }
        for (Class<? extends TOP> sc = superClass.getSuperclass(); sc != Object.class && sc != FeatureStructureImplC.class; sc = sc.getSuperclass()) {
            if (!FSClassRegistry.compare_C_T(sc, superType)) continue;
            return;
        }
        throw new CASRuntimeException("JCAS_MISMATCH_SUPERTYPE", jcci.jcasClass.getName(), FSClassRegistry.getAllSuperclassNames(jcci.jcasClass), ti.getName(), FSClassRegistry.getAllSuperTypeNames(ti));
    }

    private static String getAllSuperclassNames(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        for (Class<?> sc = clazz.getSuperclass(); sc != null && sc != FeatureStructureImplC.class; sc = sc.getSuperclass()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(sc.getName());
        }
        return sb.toString();
    }

    private static String getAllSuperTypeNames(TypeImpl ti) {
        StringBuilder sb = new StringBuilder();
        TypeImpl st = ti.getSuperType();
        while (st.getCode() != 1) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(st.getName());
            st = st.getSuperType();
        }
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append("uima.cas.TOP");
        return sb.toString();
    }

    private static Class<? extends TOP> maybeLoadJCas(TypeImpl ti, ClassLoader cl) {
        Class<?> clazz = null;
        String className = ti.getJCasClassName();
        try {
            clazz = Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException e) {
            return clazz;
        }
        catch (ExceptionInInitializerError e) {
            throw new RuntimeException("Exception while loading " + className, e);
        }
        return clazz;
    }

    static synchronized MethodHandle getConstantIntMethodHandle(int i) {
        MethodHandle mh = Misc.getWithExpand(methodHandlesForInt, i);
        if (mh == null) {
            mh = MethodHandles.constant(Integer.TYPE, i);
            methodHandlesForInt.set(i, mh);
        }
        return mh;
    }

    private static FsGenerator3 createGenerator(Class<?> jcasClass, MethodHandles.Lookup lookup) {
        try {
            MethodHandle mh = lookup.findConstructor(jcasClass, findConstructorJCasCoverType);
            MethodType mtThisGenerator = MethodType.methodType(jcasClass, TypeImpl.class, CASImpl.class);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "createFS", callsiteFsGenerator, fsGeneratorType, mh, mtThisGenerator);
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            if (e instanceof NoSuchMethodException) {
                String classname = jcasClass.getName();
                FSClassRegistry.add2errors(errorSet, new CASRuntimeException(e, "JCAS_CAS_NOT_V3", new Object[]{classname, jcasClass.getClassLoader().getResource(classname.replace('.', '/') + ".class").toString()}));
                return null;
            }
            throw new UIMARuntimeException(e, "INTERNAL_ERROR", new Object[0]);
        }
    }

    private static JCasClassInfo createJCasClassInfo(Class<? extends TOP> jcasClass, TypeImpl ti, int jcasType, MethodHandles.Lookup lookup) {
        boolean noGenerator = ti.getCode() == 33 || Modifier.isAbstract(jcasClass.getModifiers()) || ti.isArray();
        FsGenerator3 generator = noGenerator ? null : FSClassRegistry.createGenerator(jcasClass, lookup);
        JCasClassInfo jcasClassInfo = new JCasClassInfo(jcasClass, generator, jcasType);
        return jcasClassInfo;
    }

    private static JCasClassFeatureInfo[] getJCasClassFeatureInfo(Class<?> jcasClass) {
        ArrayList<JCasClassFeatureInfo> features = new ArrayList<JCasClassFeatureInfo>();
        try {
            for (Field f : jcasClass.getDeclaredFields()) {
                Method m;
                String fname = f.getName();
                if (fname.length() <= 5 || !fname.startsWith("_FC_")) continue;
                String featName = fname.substring(4);
                String getterName = "get" + Character.toUpperCase(featName.charAt(0)) + featName.substring(1);
                try {
                    m = jcasClass.getDeclaredMethod(getterName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    Logger logger = UIMAFramework.getLogger(FSClassRegistry.class);
                    logger.warn(() -> logger.rb_ue("JCAS_MISSING_GETTER", jcasClass.getName(), featName));
                    continue;
                }
                String rangeClassName = m.getReturnType().getName();
                String uimaRangeName = Misc.javaClassName2UimaTypeName(rangeClassName);
                features.add(new JCasClassFeatureInfo(featName, uimaRangeName));
            }
            JCasClassFeatureInfo[] r = new JCasClassFeatureInfo[features.size()];
            return features.toArray(r);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static void checkConformance(ClassLoader cl, TypeSystemImpl ts) {
        Map<String, JCasClassInfo> type2jcci = FSClassRegistry.get_className_to_jcci(cl, false);
        FSClassRegistry.checkConformance(ts, ts.topType, type2jcci);
    }

    private static void checkConformance(TypeSystemImpl ts, TypeImpl ti, Map<String, JCasClassInfo> type2jcci) {
        if (ti.isPrimitive()) {
            return;
        }
        JCasClassInfo jcci = type2jcci.get(ti.getJCasClassName());
        if (null != jcci && !ti.isBuiltIn) {
            FSClassRegistry.checkConformance(jcci.jcasClass, ts, ti, type2jcci);
        }
        for (TypeImpl subtype : ti.getDirectSubtypes()) {
            FSClassRegistry.checkConformance(ts, subtype, type2jcci);
        }
    }

    private static void checkConformance(Class<?> clazz, TypeSystemImpl tsi, TypeImpl ti, Map<String, JCasClassInfo> type2jcci) {
        FSClassRegistry.validateSuperClass(type2jcci.get(ti.getJCasClassName()), ti);
        for (Method method : clazz.getDeclaredMethods()) {
            String mname = method.getName();
            if (mname.length() <= 3 || !mname.startsWith("get")) continue;
            String suffix = mname.length() == 4 ? "" : mname.substring(4);
            String fname = Character.toLowerCase(mname.charAt(3)) + suffix;
            FeatureImpl fi = ti.getFeatureByBaseName(fname);
            if (fi == null && (fi = ti.getFeatureByBaseName(fname = mname.charAt(3) + suffix)) == null) continue;
            Parameter[] p = method.getParameters();
            TypeImpl range = fi.getRangeImpl();
            if (p.length > 1 || p.length == 1 && (!range.isArray() || p[0].getType() != Integer.TYPE)) continue;
            Class<?> returnClass = method.getReturnType();
            Class<?> rangeClass = range.getJavaClass();
            if (range.isArray() && p.length == 1 && p[0].getType() == Integer.TYPE) {
                rangeClass = range.getComponentType().getJavaClass();
            }
            if (rangeClass.isAssignableFrom(returnClass) || rangeClass.getName().equals("org.apache.uima.jcas.cas.Sofa") && returnClass.getName().equals("org.apache.uima.cas.SofaFS")) continue;
            FSClassRegistry.add2errors(errorSet, new CASRuntimeException("JCAS_TYPE_RANGE_MISMATCH", ti.getName(), fi.getShortName(), rangeClass, returnClass), false);
        }
        try {
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                String fname = ((Field)accessibleObject).getName();
                if (fname.length() <= 5 || !fname.startsWith("_FC_")) continue;
                String featName = fname.substring(4);
                FeatureImpl fi = ti.getFeatureByBaseName(featName);
                if (fi == null) {
                    FSClassRegistry.add2errors(errorSet, new CASRuntimeException("JCAS_FIELD_MISSING_IN_TYPE_SYSTEM", clazz.getName(), featName), false);
                    continue;
                }
                Field mhf = clazz.getDeclaredField("_FH_" + featName);
                mhf.setAccessible(true);
                MethodHandle mh = (MethodHandle)mhf.get(null);
                int staticOffsetInClass = mh.invokeExact();
                if (fi.getAdjustedOffset() == staticOffsetInClass) continue;
                FSClassRegistry.add2errors(errorSet, new CASRuntimeException("JCAS_FIELD_ADJ_OFFSET_CHANGED", clazz.getName(), fi.getName(), staticOffsetInClass, fi.getAdjustedOffset()), staticOffsetInClass != -1);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static void add2errors(ThreadLocal<List<ErrorReport>> errors, Exception e) {
        FSClassRegistry.add2errors(errors, e, true);
    }

    private static void add2errors(ThreadLocal<List<ErrorReport>> errors, Exception e, boolean doThrow) {
        List<ErrorReport> es = errors.get();
        if (es == null) {
            es = new ArrayList<ErrorReport>();
            errors.set(es);
        }
        es.add(new ErrorReport(e, doThrow));
    }

    private static void reportErrors() {
        boolean throwWhenDone = false;
        List<ErrorReport> es = errorSet.get();
        if (es != null) {
            StringBuilder msg = new StringBuilder(100);
            for (ErrorReport f : es) {
                msg.append(f.e.getMessage());
                throwWhenDone = throwWhenDone || f.doThrow;
                msg.append('\n');
            }
            errorSet.set(null);
            if (throwWhenDone) {
                throw new CASRuntimeException("JCAS_INIT_ERROR", "\n" + msg);
            }
            Logger logger = UIMAFramework.getLogger();
            if (null == logger) {
                throw new CASRuntimeException("JCAS_INIT_ERROR", "\n" + msg);
            }
            logger.log(Level.WARNING, msg.toString());
        }
    }

    static FsGenerator3[] getGeneratorsForClassLoader(ClassLoader cl, boolean isPear, TypeSystemImpl tsi) {
        Map<String, JCasClassInfo> type2jcci = FSClassRegistry.get_className_to_jcci(cl, isPear);
        FSClassRegistry.loadJCasForTSandClassLoader(tsi, true, cl, type2jcci);
        FsGenerator3[] r = new FsGenerator3[tsi.getTypeArraySize()];
        FSClassRegistry.getGeneratorsForTypeAndSubtypes(tsi.topType, type2jcci, isPear, cl, r, tsi);
        return r;
    }

    private static void getGeneratorsForTypeAndSubtypes(TypeImpl ti, Map<String, JCasClassInfo> t2jcci, boolean isPear, ClassLoader cl, FsGenerator3[] r, TypeSystemImpl tsi) {
        TypeImpl jti = ti;
        JCasClassInfo jcci = t2jcci.get(jti.getJCasClassName());
        while (jcci == null) {
            jti = jti.getSuperType();
            jcci = t2jcci.get(jti.getJCasClassName());
        }
        if (!isPear || jcci.isPearOverride(tsi)) {
            r[ti.getCode()] = jcci.generator;
        }
        for (TypeImpl subtype : ti.getDirectSubtypes()) {
            FSClassRegistry.getGeneratorsForTypeAndSubtypes(subtype, t2jcci, isPear, cl, r, tsi);
        }
    }

    private static boolean isAllNull(FsGenerator3[] r) {
        for (FsGenerator3 v : r) {
            if (v == null) continue;
            return false;
        }
        return true;
    }

    private static void updateOrValidateAllCallSitesForJCasClass(Class<? extends TOP> clazz, TypeImpl type, ArrayList<MutableCallSite> callSites_toSync) {
        try {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                String featureName;
                int index;
                String fieldName = field.getName();
                if (!fieldName.startsWith("_FC_") || (index = TypeSystemImpl.getAdjustedFeatureOffset(type, featureName = fieldName.substring("_FC_".length()))) == -1) continue;
                field.setAccessible(true);
                MutableCallSite c = (MutableCallSite)field.get(null);
                if (c == null) continue;
                int prev = c.getTarget().invokeExact();
                if (prev == -1) {
                    MethodHandle mh_constant = FSClassRegistry.getConstantIntMethodHandle(index);
                    c.setTarget(mh_constant);
                    callSites_toSync.add(c);
                    continue;
                }
                if (prev == index) continue;
                FSClassRegistry.checkConformance(clazz.getClassLoader(), type.getTypeSystem());
                FSClassRegistry.reportErrors();
                throw new UIMA_IllegalStateException("JCAS_INCOMPATIBLE_TYPE_SYSTEMS", new Object[]{type.getName(), featureName});
            }
        }
        catch (Throwable e) {
            Misc.internalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, JCasClassInfo> get_className_to_jcci(ClassLoader cl, boolean is_pear) {
        WeakIdentityMap<ClassLoader, Map<String, JCasClassInfo>> weakIdentityMap = cl_to_type2JCas;
        synchronized (weakIdentityMap) {
            Map<String, JCasClassInfo> cl_to_jcci = cl_to_type2JCas.get(cl);
            if (cl_to_jcci == null) {
                cl_to_jcci = new HashMap<String, JCasClassInfo>();
                cl_to_type2JCas.put(cl, cl_to_jcci);
            }
            return cl_to_jcci;
        }
    }

    static MethodHandles.Lookup getLookup(ClassLoader cl) {
        MethodHandles.Lookup lookup = null;
        try {
            Class<?> clazz = Class.forName("org.apache.uima.cas.impl.MethodHandlesLookup", true, cl);
            Method m = clazz.getMethod("getMethodHandlesLookup", new Class[0]);
            lookup = (MethodHandles.Lookup)m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UIMARuntimeException((Throwable)e, "INTERNAL_ERROR", new Object[0]);
        }
        return lookup;
    }

    static {
        methodHandlesForInt = new ArrayList<MethodHandle>();
        cl_to_type2JCas = WeakIdentityMap.newHashMap();
        errorSet = new ThreadLocal();
        TypeSystemImpl tsi = TypeSystemImpl.staticTsi;
        jcasClassesInfoForBuiltins = new JCasClassInfo[tsi.getTypeArraySize()];
        ArrayList<MutableCallSite> callSites_toSync = new ArrayList<MutableCallSite>();
        ClassLoader cl = tsi.getClass().getClassLoader();
        FSClassRegistry.loadBuiltins(tsi.topType, cl, FSClassRegistry.get_className_to_jcci(cl, false), callSites_toSync);
        MutableCallSite[] sync = callSites_toSync.toArray(new MutableCallSite[callSites_toSync.size()]);
        MutableCallSite.syncAll(sync);
        FSClassRegistry.reportErrors();
    }

    static class JCasClassFeatureInfo {
        final String shortName;
        final String uimaRangeName;

        JCasClassFeatureInfo(String shortName, String uimaRangeName) {
            this.shortName = shortName;
            this.uimaRangeName = uimaRangeName;
        }

        public String toString() {
            return String.format("JCasClassFeatureInfo feature: %s, range: %s", this.shortName == null ? "<null>" : this.shortName, this.uimaRangeName == null ? "<null>" : this.uimaRangeName);
        }
    }

    public static class JCasClassInfo {
        final FsGenerator3 generator;
        final Class<? extends TOP> jcasClass;
        final int jcasType;
        final JCasClassFeatureInfo[] features;

        JCasClassInfo(Class<? extends TOP> jcasClass, FsGenerator3 generator, int jcasType) {
            this.generator = generator;
            this.jcasClass = jcasClass;
            this.jcasType = jcasType;
            this.features = FSClassRegistry.getJCasClassFeatureInfo(jcasClass);
        }

        boolean isCopydown(TypeImpl ti) {
            return this.isCopydown(ti.getJCasClassName());
        }

        boolean isCopydown(String jcasClassName) {
            return !this.jcasClass.getCanonicalName().equals(jcasClassName);
        }

        boolean isPearOverride(TypeSystemImpl tsi) {
            JCasClassInfo baseJcci = tsi.getJcci(this.jcasClass.getName());
            return baseJcci == null || !this.jcasClass.getClassLoader().equals(baseJcci.jcasClass.getClassLoader());
        }

        TypeImpl getUimaType(TypeSystemImpl tsi) {
            return tsi.getType(Misc.javaClassName2UimaTypeName(this.jcasClass.getName()));
        }
    }

    private static class ErrorReport {
        final Exception e;
        final boolean doThrow;

        ErrorReport(Exception e, boolean doThrow) {
            this.e = e;
            this.doThrow = doThrow;
        }
    }
}

