/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/
package org.apache.uima.ducc.ps.service.transport;

import java.util.concurrent.atomic.AtomicLong;

import org.apache.uima.ducc.ps.service.metrics.IWindowStats;

public class TransportStats implements IWindowStats{

	private AtomicLong errorCount = new AtomicLong();
	private AtomicLong successCount = new AtomicLong();
	private AtomicLong errorCountSinceLastSuccess = new AtomicLong();
	
	

	public synchronized void incrementErrorCount() {
		errorCount.incrementAndGet();
		errorCountSinceLastSuccess.incrementAndGet();
	}
	public synchronized void incrementSuccessCount() {
		successCount.incrementAndGet();
		// reset
		errorCountSinceLastSuccess.set(0);
	}
	
	@Override
	public long getErrorCount() {
		return errorCount.get();
	}

	@Override
	public long getSuccessCount() {
		return successCount.get();
	}

	@Override
	public long getErrorCountSinceLastSuccess() {
		return errorCountSinceLastSuccess.get();
	}

}
