/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public abstract class Value
implements Serializable,
SequenceIterable,
ValueRepresentation,
Comparable {
    private static double[] powers = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8};
    private static Pattern doublePattern = Pattern.compile("^[0-9.eE+-]+$");
    public static final int INDETERMINATE_ORDERING = Integer.MIN_VALUE;
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    public static Value asValue(ValueRepresentation valueRepresentation) {
        if (valueRepresentation instanceof Value) {
            return (Value)valueRepresentation;
        }
        if (valueRepresentation == null) {
            return EmptySequence.getInstance();
        }
        return new SingletonNode((NodeInfo)valueRepresentation);
    }

    public static Item asItem(ValueRepresentation valueRepresentation) throws XPathException {
        if (valueRepresentation instanceof Item) {
            return (Item)valueRepresentation;
        }
        return ((Value)valueRepresentation).asItem();
    }

    public Item asItem() throws XPathException {
        SequenceIterator sequenceIterator = this.iterate();
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        if (sequenceIterator.next() != null) {
            throw new DynamicError("Attempting to access a sequence as a singleton item");
        }
        return item;
    }

    public static Value fromItem(Item item) {
        if (item == null) {
            return EmptySequence.getInstance();
        }
        if (item instanceof AtomicValue) {
            return (AtomicValue)item;
        }
        return new SingletonNode((NodeInfo)item);
    }

    public static SequenceIterator asIterator(ValueRepresentation valueRepresentation) throws XPathException {
        if (valueRepresentation instanceof Value) {
            return ((Value)valueRepresentation).iterate();
        }
        if (valueRepresentation == null) {
            return EmptyIterator.getInstance();
        }
        return SingletonIterator.makeIterator((NodeInfo)valueRepresentation);
    }

    public static double stringToNumber(CharSequence charSequence) throws NumberFormatException {
        String string;
        int n = charSequence.length();
        if (n < 9) {
            int n2;
            boolean bl = false;
            long l = 0L;
            int n3 = -1;
            int n4 = -1;
            boolean bl2 = false;
            block5: for (n2 = 0; n2 < charSequence.length(); ++n2) {
                char c = charSequence.charAt(n2);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (n4 == -1) continue block5;
                        bl2 = true;
                        continue block5;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (bl2) {
                            throw new NumberFormatException("Numeric value contains embedded whitespace");
                        }
                        n4 = n2;
                        l = l * 10L + (long)(c - 48);
                        continue block5;
                    }
                    case '.': {
                        if (bl2) {
                            throw new NumberFormatException("Numeric value contains embedded whitespace");
                        }
                        if (n3 != -1) {
                            throw new NumberFormatException("Only one decimal point allowed");
                        }
                        n3 = n2;
                        continue block5;
                    }
                    default: {
                        bl = true;
                        break block5;
                    }
                }
            }
            if (!bl) {
                if (n4 == -1) {
                    throw new NumberFormatException("No digits found");
                }
                if (n3 == -1 || n3 > n4) {
                    return l;
                }
                n2 = n4 - n3;
                return (double)l / powers[n2];
            }
        }
        if ("INF".equals(string = ((Object)Whitespace.trimWhitespace(charSequence)).toString())) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-INF".equals(string)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(string)) {
            return Double.NaN;
        }
        if (!doublePattern.matcher(string).matches()) {
            throw new NumberFormatException("Invalid characters in float/double value");
        }
        return Double.parseDouble(string);
    }

    public static SequenceIterator getIterator(ValueRepresentation valueRepresentation) throws XPathException {
        if (valueRepresentation instanceof Value) {
            return ((Value)valueRepresentation).iterate();
        }
        if (valueRepresentation instanceof NodeInfo) {
            return SingletonIterator.makeIterator((NodeInfo)valueRepresentation);
        }
        if (valueRepresentation == null) {
            throw new AssertionError((Object)"Value of variable is undefined (null)");
        }
        throw new AssertionError((Object)("Unknown value representation " + valueRepresentation.getClass()));
    }

    public abstract SequenceIterator iterate() throws XPathException;

    public final SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return this.iterate();
    }

    public CharSequence getStringValueCS() throws XPathException {
        return this.getStringValue();
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        try {
            return this.getStringValueCS();
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException("Failed to get canonical lexical representation: " + xPathException.getMessage());
        }
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return AnyItemType.getInstance();
    }

    public int getCardinality() {
        try {
            SequenceIterator sequenceIterator = this.iterate();
            Item item = sequenceIterator.next();
            if (item == null) {
                return 8192;
            }
            if (sequenceIterator.next() != null) {
                return 49152;
            }
            return 16384;
        }
        catch (XPathException xPathException) {
            return 57344;
        }
    }

    public abstract boolean isMultiValued();

    public Item itemAt(int n) throws XPathException {
        Item item;
        if (n < 0) {
            return null;
        }
        int n2 = 0;
        SequenceIterator sequenceIterator = this.iterate();
        do {
            if ((item = sequenceIterator.next()) != null) continue;
            return null;
        } while (n2++ != n);
        return item;
    }

    public int getLength() throws XPathException {
        return Aggregate.count(this.iterate());
    }

    public void process(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.iterate();
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        while ((item = sequenceIterator.next()) != null) {
            sequenceReceiver.append(item, 0, 2);
        }
    }

    public String getStringValue() throws XPathException {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(1024);
        SequenceIterator sequenceIterator = this.iterate();
        Item item = sequenceIterator.next();
        if (item != null) {
            while (true) {
                fastStringBuffer.append(item.getStringValueCS());
                item = sequenceIterator.next();
                if (item == null) break;
                fastStringBuffer.append(' ');
            }
        }
        return fastStringBuffer.toString();
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    public Comparable getSchemaComparable() {
        return this;
    }

    public boolean equals(Object object) {
        try {
            if (object instanceof Value) {
                Item item;
                Item item2;
                SequenceIterator sequenceIterator = this.iterate();
                SequenceIterator sequenceIterator2 = ((Value)object).iterate();
                do {
                    item2 = sequenceIterator.next();
                    item = sequenceIterator2.next();
                    if (item2 == null && item == null) {
                        return true;
                    }
                    if (item2 == null || item == null) {
                        return false;
                    }
                    if (!(item2 instanceof NodeInfo) && !(item instanceof NodeInfo)) continue;
                    return false;
                } while (((AtomicValue)item2).getSchemaComparable().equals(((AtomicValue)item).getSchemaComparable()));
                return false;
            }
            return false;
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            int n = 107189858;
            SequenceIterator sequenceIterator = this.iterate();
            while (true) {
                Item item;
                if ((item = sequenceIterator.next()) == null) {
                    return n;
                }
                n ^= item.hashCode();
            }
        }
        catch (XPathException xPathException) {
            return 0;
        }
    }

    public int compareTo(Object object) {
        return Integer.MIN_VALUE;
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
    }

    public Value reduce() throws XPathException {
        return this;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        Object object;
        Object object2;
        Class<?> clazz2;
        if (clazz == Object.class) {
            ArrayList arrayList = new ArrayList(20);
            return this.convertToJavaList(arrayList, xPathContext);
        }
        if (clazz.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (clazz.isAssignableFrom(SequenceIterator.class)) {
            return this.iterate();
        }
        if (!(!(this instanceof ObjectValue) && this instanceof AtomicValue || this instanceof EmptySequence)) {
            clazz2 = xPathContext.getConfiguration().getExternalObjectModels();
            for (int i = 0; i < clazz2.size(); ++i) {
                object2 = (ExternalObjectModel)clazz2.get(i);
                object = object2.convertXPathValueToObject(this, clazz, xPathContext);
                if (object == null) continue;
                return object;
            }
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (clazz.isAssignableFrom(ArrayList.class)) {
                clazz2 = new ArrayList(100);
            } else {
                try {
                    clazz2 = (Collection)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    object2 = new DynamicError("Cannot instantiate collection class " + clazz);
                    ((DynamicError)object2).setXPathContext(xPathContext);
                    throw object2;
                }
                catch (IllegalAccessException illegalAccessException) {
                    object2 = new DynamicError("Cannot access collection class " + clazz);
                    ((DynamicError)object2).setXPathContext(xPathContext);
                    throw object2;
                }
            }
            return this.convertToJavaList((Collection)((Object)clazz2), xPathContext);
        }
        if (clazz.isArray()) {
            int n;
            clazz2 = clazz.getComponentType();
            if (clazz2.isAssignableFrom(Item.class) || clazz2.isAssignableFrom(NodeInfo.class) || clazz2.isAssignableFrom(DocumentInfo.class)) {
                Value value = this;
                if (value instanceof Closure) {
                    value = Value.asValue(SequenceExtent.makeSequenceExtent(value.iterate()));
                }
                int n2 = value.getLength();
                object = Array.newInstance(clazz2, n2);
                SequenceIterator sequenceIterator = value.iterate();
                for (int i = 0; i < n2; ++i) {
                    Item item = sequenceIterator.next();
                    try {
                        Array.set(object, i, item);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        DynamicError dynamicError = new DynamicError("Item " + i + " in supplied sequence cannot be converted " + "to the component type of the Java array (" + clazz2 + ')', illegalArgumentException);
                        dynamicError.setErrorCode("SXJE0023");
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                }
                return object;
            }
            SequenceIterator sequenceIterator = Atomizer.getAtomizingIterator(this.iterate());
            if ((sequenceIterator.getProperties() & 2) == 0) {
                object = new SequenceExtent(sequenceIterator);
                n = ((SequenceExtent)object).getLength();
                sequenceIterator = ((SequenceExtent)object).iterate();
            } else {
                n = ((LastPositionFinder)sequenceIterator).getLastPosition();
            }
            object = Array.newInstance(clazz2, n);
            for (int i = 0; i < n; ++i) {
                Object object3;
                try {
                    AtomicValue atomicValue = (AtomicValue)sequenceIterator.next();
                    object3 = atomicValue.convertToJava(clazz2, xPathContext);
                    Array.set(object, i, object3);
                    continue;
                }
                catch (XPathException xPathException) {
                    object3 = new DynamicError("Cannot convert item in atomized sequence to the component type of the Java array", xPathException);
                    ((XPathException)object3).setErrorCode("SXJE0023");
                    ((DynamicError)object3).setXPathContext(xPathContext);
                    throw object3;
                }
            }
            return object;
        }
        if (clazz.isAssignableFrom(Item.class) || clazz.isAssignableFrom(NodeInfo.class) || clazz.isAssignableFrom(DocumentInfo.class)) {
            clazz2 = this.iterate();
            Object object4 = null;
            while ((object2 = clazz2.next()) != null) {
                if (object4 != null) {
                    object = new DynamicError("Sequence contains more than one value; Java method expects only one", "SXJE0022");
                    ((DynamicError)object).setXPathContext(xPathContext);
                    throw object;
                }
                object4 = object2;
            }
            if (object4 == null) {
                return null;
            }
            if (clazz.isAssignableFrom(object4.getClass())) {
                return object4;
            }
            object2 = object4;
            while (object2 instanceof VirtualNode) {
                object = ((VirtualNode)object2).getUnderlyingNode();
                if (clazz.isAssignableFrom(object.getClass())) {
                    return object;
                }
                object2 = object;
            }
            throw new DynamicError("Cannot convert supplied XPath value to the required type for the extension function", "SXJE0021");
        }
        if (!(this instanceof AtomicValue)) {
            clazz2 = Atomizer.getAtomizingIterator(this.iterate());
            Object object5 = null;
            while ((object2 = clazz2.next()) != null) {
                if (object5 != null) {
                    object = new DynamicError("Sequence contains more than one value; Java method expects only one", "SXJE0022");
                    ((DynamicError)object).setXPathContext(xPathContext);
                    throw object;
                }
                object5 = object2;
            }
            if (object5 == null) {
                return null;
            }
            if (clazz.isAssignableFrom(object5.getClass())) {
                return object5;
            }
            return ((AtomicValue)object5).convertToJava(clazz, xPathContext);
        }
        throw new DynamicError("Cannot convert supplied XPath value to the required type for the extension function", "SXJE0021");
    }

    private Collection convertToJavaList(Collection collection, XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.iterate();
        Item item;
        while ((item = sequenceIterator.next()) != null) {
            if (item instanceof AtomicValue) {
                collection.add(((AtomicValue)item).convertToJava(class$java$lang$Object == null ? Value.class$("java.lang.Object") : class$java$lang$Object, xPathContext));
                continue;
            }
            if (item instanceof VirtualNode) {
                collection.add(((VirtualNode)item).getUnderlyingNode());
                continue;
            }
            collection.add(item);
        }
        return collection;
    }

    public static Value convertJavaObjectToXPath(Object object, SequenceType sequenceType, XPathContext xPathContext) throws XPathException {
        Configuration configuration = xPathContext.getConfiguration();
        ItemType itemType = sequenceType.getPrimaryType();
        if (object == null) {
            return EmptySequence.getInstance();
        }
        List list = configuration.getExternalObjectModels();
        for (int i = 0; i < list.size(); ++i) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)list.get(i);
            Value value = externalObjectModel.convertObjectToXPathValue(object, configuration);
            if (value == null || TypeChecker.testConformance(value, sequenceType, xPathContext) != null) continue;
            return value;
        }
        if (itemType instanceof ExternalObjectType) {
            Class clazz = ((ExternalObjectType)itemType).getJavaClass();
            if (clazz.isAssignableFrom(object.getClass())) {
                return new ObjectValue(object, (ExternalObjectType)itemType);
            }
            throw new DynamicError("Supplied parameter value is not of class " + clazz.getName());
        }
        Value value = Value.convertToBestFit(object, configuration);
        return value;
    }

    private static Value convertToBestFit(Object object, Configuration configuration) throws XPathException {
        if (object instanceof String) {
            return StringValue.makeStringValue((String)object);
        }
        if (object instanceof Character) {
            return new StringValue(object.toString());
        }
        if (object instanceof Boolean) {
            return BooleanValue.get((Boolean)object);
        }
        if (object instanceof Double) {
            return new DoubleValue((Double)object);
        }
        if (object instanceof Float) {
            return new FloatValue(((Float)object).floatValue());
        }
        if (object instanceof Short) {
            return new Int64Value(((Short)object).shortValue(), BuiltInAtomicType.SHORT, false);
        }
        if (object instanceof Integer) {
            return new Int64Value(((Integer)object).intValue(), BuiltInAtomicType.INT, false);
        }
        if (object instanceof Long) {
            return new Int64Value((Long)object, BuiltInAtomicType.LONG, false);
        }
        if (object instanceof Byte) {
            return new Int64Value(((Byte)object).byteValue(), BuiltInAtomicType.BYTE, false);
        }
        if (object instanceof BigInteger) {
            return BigIntegerValue.makeIntegerValue((BigInteger)object);
        }
        if (object instanceof BigDecimal) {
            return new DecimalValue((BigDecimal)object);
        }
        if (object.getClass().getName().equals("javax.xml.namespace.QName")) {
            return Value.makeQNameValue(object, configuration);
        }
        if (object instanceof URI) {
            return new AnyURIValue(object.toString());
        }
        if (object instanceof URL) {
            return new AnyURIValue(object.toString());
        }
        if (object instanceof Date) {
            return DateTimeValue.fromJavaDate((Date)object);
        }
        if (object instanceof Closure) {
            return Value.asValue(SequenceExtent.makeSequenceExtent(((Closure)object).iterate()));
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof NodeInfo) {
            if (((NodeInfo)object).getConfiguration() != configuration) {
                throw new DynamicError("Externally-supplied NodeInfo belongs to wrong Configuration", "SXXP0004");
            }
            return new SingletonNode((NodeInfo)object);
        }
        if (object instanceof SequenceIterator) {
            return Closure.makeIteratorClosure((SequenceIterator)object);
        }
        if (object instanceof List) {
            Item[] itemArray = new Item[((List)object).size()];
            int n = 0;
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof NodeInfo) {
                    if (((NodeInfo)e).getConfiguration() != configuration) {
                        throw new DynamicError("Externally-supplied NodeInfo belongs to wrong Configuration", "SXXP0004");
                    }
                    itemArray[n++] = (NodeInfo)e;
                    continue;
                }
                Value value = Value.convertToBestFit(e, configuration);
                if (value == null) continue;
                if (value instanceof Item) {
                    itemArray[n++] = (Item)((Object)value);
                    continue;
                }
                if (value instanceof EmptySequence) continue;
                if (value instanceof SingletonNode) {
                    NodeInfo nodeInfo = ((SingletonNode)value).getNode();
                    if (nodeInfo == null) continue;
                    itemArray[n++] = nodeInfo;
                    continue;
                }
                throw new DynamicError("Returned List contains an object that cannot be converted to an Item (" + e.getClass() + ')', "SXJE0051");
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Item[] itemArray = new Item[objectArray.length];
            int n = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                Value value;
                Object object2 = objectArray[i];
                if (object2 instanceof NodeInfo) {
                    if (((NodeInfo)object2).getConfiguration() != configuration) {
                        throw new DynamicError("Externally-supplied NodeInfo belongs to wrong Configuration", "SXXP0004");
                    }
                    itemArray[n++] = (NodeInfo)object2;
                    continue;
                }
                if (object2 == null || (value = Value.convertToBestFit(object2, configuration)) == null) continue;
                if (value instanceof Item) {
                    itemArray[n++] = (Item)((Object)value);
                    continue;
                }
                throw new DynamicError("Returned array contains an object that cannot be converted to an Item (" + object2.getClass() + ')', "SXJE0051");
            }
            return new SequenceExtent(itemArray, 0, n);
        }
        if (object instanceof long[]) {
            Item[] itemArray = new Item[((long[])object).length];
            for (int i = 0; i < itemArray.length; ++i) {
                itemArray[i] = Int64Value.makeIntegerValue(((long[])object)[i]);
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof int[]) {
            Item[] itemArray = new Item[((int[])object).length];
            for (int i = 0; i < itemArray.length; ++i) {
                itemArray[i] = Int64Value.makeIntegerValue(((int[])object)[i]);
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof short[]) {
            Item[] itemArray = new Item[((short[])object).length];
            for (int i = 0; i < itemArray.length; ++i) {
                itemArray[i] = Int64Value.makeIntegerValue(((short[])object)[i]);
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof byte[]) {
            Item[] itemArray = new Item[((byte[])object).length];
            for (int i = 0; i < itemArray.length; ++i) {
                itemArray[i] = Int64Value.makeIntegerValue(0xFF & ((byte[])object)[i]);
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof char[]) {
            return StringValue.makeStringValue(new String((char[])object));
        }
        if (object instanceof boolean[]) {
            Item[] itemArray = new Item[((boolean[])object).length];
            for (int i = 0; i < itemArray.length; ++i) {
                itemArray[i] = BooleanValue.get(((boolean[])object)[i]);
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof double[]) {
            Item[] itemArray = new Item[((double[])object).length];
            for (int i = 0; i < itemArray.length; ++i) {
                itemArray[i] = new DoubleValue(((double[])object)[i]);
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof float[]) {
            Item[] itemArray = new Item[((float[])object).length];
            for (int i = 0; i < itemArray.length; ++i) {
                itemArray[i] = new FloatValue(((float[])object)[i]);
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof Source && configuration != null) {
            if (object instanceof DOMSource) {
                NodeInfo nodeInfo = Controller.unravel((Source)object, configuration);
                if (nodeInfo.getConfiguration() != configuration) {
                    throw new DynamicError("Externally-supplied DOM Node belongs to wrong Configuration", "SXXP0004");
                }
                return new SingletonNode(nodeInfo);
            }
            try {
                TinyBuilder tinyBuilder = new TinyBuilder();
                PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
                tinyBuilder.setPipelineConfiguration(pipelineConfiguration);
                new Sender(pipelineConfiguration).send((Source)object, tinyBuilder);
                if (object instanceof AugmentedSource && ((AugmentedSource)object).isPleaseCloseAfterUse()) {
                    ((AugmentedSource)object).close();
                }
                return new SingletonNode(tinyBuilder.getCurrentRoot());
            }
            catch (XPathException xPathException) {
                throw new DynamicError(xPathException);
            }
        }
        ExternalObjectModel externalObjectModel = configuration.findExternalObjectModel(object);
        if (externalObjectModel != null) {
            DocumentInfo documentInfo = externalObjectModel.wrapDocument(object, "", configuration);
            NodeInfo nodeInfo = externalObjectModel.wrapNode(documentInfo, object);
            return Value.asValue(nodeInfo);
        }
        return new ObjectValue(object);
    }

    public static QNameValue makeQNameValue(Object object, Configuration configuration) {
        try {
            Class clazz = configuration.getClass("javax.xml.namespace.QName", false, null);
            Class[] classArray = EMPTY_CLASS_ARRAY;
            Method method = clazz.getMethod("getPrefix", classArray);
            Method method2 = clazz.getMethod("getLocalPart", classArray);
            Method method3 = clazz.getMethod("getNamespaceURI", classArray);
            String string = (String)method.invoke(object, (Object[])classArray);
            String string2 = (String)method2.invoke(object, (Object[])classArray);
            String string3 = (String)method3.invoke(object, (Object[])classArray);
            return new QNameValue(string, string3, string2, BuiltInAtomicType.QNAME, configuration.getNameChecker());
        }
        catch (XPathException xPathException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    public String toString() {
        try {
            return this.getStringValue();
        }
        catch (XPathException xPathException) {
            return super.toString();
        }
    }

    public static Object convert(Item item) throws XPathException {
        if (item instanceof NodeInfo) {
            Object object = item;
            while (object instanceof VirtualNode) {
                object = ((VirtualNode)object).getUnderlyingNode();
            }
            return object;
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).getObject();
        }
        AtomicValue atomicValue = (AtomicValue)item;
        switch (atomicValue.getItemType(null).getPrimitiveType()) {
            case 513: 
            case 518: 
            case 529: 
            case 631: {
                return atomicValue.getStringValue();
            }
            case 514: {
                return ((BooleanValue)atomicValue).getBooleanValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 515: {
                return ((DecimalValue)atomicValue).getDecimalValue();
            }
            case 532: {
                return new Long(((NumericValue)atomicValue).longValue());
            }
            case 517: {
                return new Double(((DoubleValue)atomicValue).getDoubleValue());
            }
            case 516: {
                return new Float(((FloatValue)atomicValue).getFloatValue());
            }
            case 519: {
                return ((DateTimeValue)atomicValue).getCalendar().getTime();
            }
            case 521: {
                return ((DateValue)atomicValue).getCalendar().getTime();
            }
            case 520: {
                return atomicValue.getStringValue();
            }
            case 528: {
                return ((Base64BinaryValue)atomicValue).getBinaryValue();
            }
            case 527: {
                return ((HexBinaryValue)atomicValue).getBinaryValue();
            }
        }
        return item;
    }
}

