/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class UserFunctionCall
extends FunctionCall
implements InstructionInfoProvider {
    private SequenceType staticType;
    private UserFunction function;
    private boolean tailCall = false;
    private boolean confirmed = false;
    private int[] argumentEvaluationModes = null;

    public void setStaticType(SequenceType sequenceType) {
        this.staticType = sequenceType;
    }

    public void setFunction(UserFunction userFunction, StaticContext staticContext) throws XPathException {
        this.function = userFunction;
        this.confirmed = true;
    }

    public void checkFunctionCall(UserFunction userFunction, StaticContext staticContext) throws XPathException {
        int n = userFunction.getNumberOfArguments();
        for (int i = 0; i < n; ++i) {
            RoleLocator roleLocator = new RoleLocator(0, new Integer(userFunction.getFunctionNameCode()), i, staticContext.getNamePool());
            roleLocator.setSourceLocator(this);
            this.argument[i] = TypeChecker.staticTypeCheck(this.argument[i], userFunction.getArgumentType(i), false, roleLocator, staticContext);
        }
    }

    public UserFunction getFunction() {
        return this.function;
    }

    public void setConfirmed(boolean bl) {
        this.confirmed = bl;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public boolean isTailCall() {
        return this.tailCall;
    }

    public boolean isRecursiveTailCall() {
        if (this.tailCall) {
            Expression expression = this;
            while (true) {
                Container container;
                if ((container = expression.getParentExpression()) instanceof UserFunction) {
                    return container == this.function;
                }
                if (!(container instanceof Expression)) break;
                expression = (Expression)container;
            }
            return false;
        }
        return false;
    }

    public Expression[] getArguments() {
        return this.argument;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
    }

    public int[] getArgumentEvaluationModes() {
        return this.argumentEvaluationModes;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.staticType == null) {
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public int getIntrinsicDependencies() {
        return 256;
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            return 57344;
        }
        return this.staticType.getCardinality();
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        for (int i = 0; i < this.argument.length; ++i) {
            this.argument[i] = this.argument[i].simplify(staticContext);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.typeCheck(staticContext, itemType);
        if (this.function != null) {
            if (expression == this) {
                this.computeArgumentEvaluationModes();
            }
            if (this.staticType == SequenceType.ANY_SEQUENCE) {
                this.staticType = this.function.getResultType(staticContext.getConfiguration().getTypeHierarchy());
            }
        }
        return expression;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.optimize(optimizer, staticContext, itemType);
        if (expression == this && this.function != null) {
            this.computeArgumentEvaluationModes();
        }
        return expression;
    }

    public void computeArgumentEvaluationModes() {
        this.argumentEvaluationModes = new int[this.argument.length];
        for (int i = 0; i < this.argument.length; ++i) {
            int n = this.function.getParameterDefinitions()[i].getReferenceCount();
            this.argumentEvaluationModes[i] = n == 0 ? 5 : (this.function.getParameterDefinitions()[i].isIndexedVariable() ? 12 : ((this.argument[i].getDependencies() & 0x100) != 0 ? ExpressionTool.eagerEvaluationMode(this.argument[i]) : ExpressionTool.lazyEvaluationMode(this.argument[i])));
        }
    }

    public int markTailFunctionCalls(int n, int n2) {
        this.tailCall = true;
        return (n & 0xFFFFF) == (this.getFunctionNameCode() & 0xFFFFF) && n2 == this.getNumberOfArguments() ? 2 : 1;
    }

    public int getImplementationMethod() {
        if (Cardinality.allowsMany(this.getCardinality())) {
            return 6;
        }
        return 1;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = this.callFunction(xPathContext);
        if (valueRepresentation instanceof Item) {
            return (Item)valueRepresentation;
        }
        return Value.getIterator(valueRepresentation).next();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = this.callFunction(xPathContext);
        return Value.getIterator(valueRepresentation);
    }

    private ValueRepresentation callFunction(XPathContext xPathContext) throws XPathException {
        ValueRepresentation[] valueRepresentationArray = this.evaluateArguments(xPathContext);
        if (this.tailCall) {
            ((XPathContextMajor)xPathContext).requestTailCall(this.function, valueRepresentationArray);
            return EmptySequence.getInstance();
        }
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this);
        try {
            return this.function.call(valueRepresentationArray, xPathContextMajor);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new DynamicError("Too many nested function calls. May be due to infinite recursion.", this);
        }
        catch (NullPointerException nullPointerException) {
            if (this.function == null) {
                throw new NullPointerException("Unbound function call " + xPathContextMajor.getConfiguration().getNamePool().getDisplayName(this.getFunctionNameCode()));
            }
            throw nullPointerException;
        }
    }

    public void process(XPathContext xPathContext) throws XPathException {
        ValueRepresentation[] valueRepresentationArray = this.evaluateArguments(xPathContext);
        if (this.tailCall) {
            ((XPathContextMajor)xPathContext).requestTailCall(this.function, valueRepresentationArray);
        } else {
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
            xPathContextMajor.setReceiver(sequenceReceiver);
            xPathContextMajor.setOrigin(this);
            this.function.process(valueRepresentationArray, xPathContextMajor);
        }
    }

    private ValueRepresentation[] evaluateArguments(XPathContext xPathContext) throws XPathException {
        int n = this.argument.length;
        ValueRepresentation[] valueRepresentationArray = new ValueRepresentation[n];
        if (this.argumentEvaluationModes == null) {
            this.computeArgumentEvaluationModes();
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.function.getParameterDefinitions()[i].getReferenceCount();
            valueRepresentationArray[i] = ExpressionTool.evaluate(this.argument[i], this.argumentEvaluationModes[i], xPathContext, n2);
            if (valueRepresentationArray[i] == null) {
                valueRepresentationArray[i] = EmptySequence.getInstance();
            }
            if (n2 <= 1 || !(valueRepresentationArray[i] instanceof Closure) || valueRepresentationArray[i] instanceof MemoClosure) continue;
            valueRepresentationArray[i] = ((Closure)valueRepresentationArray[i]).reduce();
        }
        return valueRepresentationArray;
    }

    public ValueRepresentation dynamicCall(ValueRepresentation[] valueRepresentationArray, XPathContext xPathContext) throws XPathException {
        ValueRepresentation[] valueRepresentationArray2 = new ValueRepresentation[valueRepresentationArray.length];
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCaller(xPathContext);
        xPathContextMajor.openStackFrame(valueRepresentationArray.length);
        for (int i = 0; i < valueRepresentationArray.length; ++i) {
            xPathContextMajor.setLocalVariable(i, valueRepresentationArray[i]);
            valueRepresentationArray2[i] = ExpressionTool.lazyEvaluate(this.argument[i], xPathContextMajor, 10);
        }
        XPathContextMajor xPathContextMajor2 = xPathContextMajor.newCleanContext();
        xPathContextMajor2.setOrigin(this);
        return this.function.call(valueRepresentationArray2, xPathContextMajor2);
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "call " + this.getDisplayName(configuration.getNamePool()) + (this.tailCall ? " (:tail call:)" : ""));
        for (int i = 0; i < this.argument.length; ++i) {
            this.argument[i].display(n + 1, printStream, configuration);
        }
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(2009);
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setObjectNameCode(this.getFunctionNameCode());
        instructionDetails.setProperty("expression", this);
        instructionDetails.setProperty("target", this.function);
        return instructionDetails;
    }
}

