/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.jmx;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.jmx.JmxManagement;
import org.apache.uima.internal.util.JmxMBeanAgent;
import org.apache.uima.util.Level;

public class JmxManager
implements JmxManagement {
    private String jmxDomain = "";
    private List<ObjectName> mbeanList = new ArrayList<ObjectName>();
    private static Class mbeanServerClass;
    private static Class objectNameClass;
    private static Constructor objectNameConstructor;
    private static Method isRegistered;
    private static Method registerMBean;
    private static Method unregisterMBean;
    private static boolean jmxAvailable;
    private static Object platformMBeanServer;
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";

    public JmxManager(String aDomain) {
        this.jmxDomain = aDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDomainObjects(String aDomain) {
        Class<JmxManager> clazz = JmxManager.class;
        synchronized (JmxManager.class) {
            if (!this.isInitialized()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            try {
                Set set = this.getMBeansInDomain(aDomain);
                for (ObjectName on : set) {
                    try {
                        this.unregisterMBean(on);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                UIMAFramework.getLogger().logrb(Level.WARNING, JmxMBeanAgent.class.getName(), "unregisterDomainObjects", LOG_RESOURCE_BUNDLE, "UIMA_JMX_failed_to_register_mbean__WARNING", (Throwable)e);
            }
            return;
        }
    }

    private Set getMBeansInDomain(String aDomain) throws Exception {
        ObjectName objName = new ObjectName(aDomain);
        return ((MBeanServer)platformMBeanServer).queryNames(objName, null);
    }

    @Override
    public String getJmxDomain() {
        return this.jmxDomain;
    }

    @Override
    public void setJmxDomain(String aJmxDomain) {
        this.jmxDomain = aJmxDomain;
    }

    @Override
    public MBeanServer getMBeanServer() {
        if (!this.isInitialized()) {
            return null;
        }
        return (MBeanServer)platformMBeanServer;
    }

    @Override
    public void addObject(String objectName) throws Exception {
        ObjectName objName = new ObjectName(objectName);
        this.mbeanList.add(objName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMBean(Object anMBeanToRegister, ObjectName aName) throws Exception {
        if (!this.isInitialized()) {
            return;
        }
        try {
            Class<JmxManager> clazz = JmxManager.class;
            synchronized (JmxManager.class) {
                if (((MBeanServer)platformMBeanServer).isRegistered(aName)) {
                    ((MBeanServer)platformMBeanServer).unregisterMBean(aName);
                }
                ObjectInstance oi = ((MBeanServer)platformMBeanServer).registerMBean(anMBeanToRegister, aName);
                this.mbeanList.add(oi.getObjectName());
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger().logrb(Level.WARNING, JmxMBeanAgent.class.getName(), "registerMBean", LOG_RESOURCE_BUNDLE, "UIMA_JMX_failed_to_register_mbean__WARNING", (Throwable)e);
        }
        {
            return;
        }
    }

    private boolean isInitialized() {
        if (!jmxAvailable || platformMBeanServer == null) {
            UIMAFramework.getLogger().logrb(Level.CONFIG, JmxManager.class.getName(), "isInitialized", LOG_RESOURCE_BUNDLE, "UIMA_JMX_platform_mbean_server_not_available__CONFIG");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMBean(ObjectName anMBeanToUnregister) {
        Class<JmxManager> clazz = JmxManager.class;
        synchronized (JmxManager.class) {
            if (!this.isInitialized()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            try {
                if (((MBeanServer)platformMBeanServer).isRegistered(anMBeanToUnregister)) {
                    ((MBeanServer)platformMBeanServer).unregisterMBean(anMBeanToUnregister);
                }
            }
            catch (Exception e) {
                UIMAFramework.getLogger().logrb(Level.WARNING, JmxMBeanAgent.class.getName(), "registerMBean", LOG_RESOURCE_BUNDLE, "UIMA_JMX_failed_to_register_mbean__WARNING", (Throwable)e);
            }
            return;
        }
    }

    @Override
    public void destroy() throws Exception {
        for (ObjectName oi : this.mbeanList) {
            try {
                this.unregisterMBean(oi);
            }
            catch (Exception exception) {}
        }
        this.mbeanList.clear();
    }

    @Override
    public void initialize(Map anInitMap) throws Exception {
    }

    static {
        try {
            mbeanServerClass = Class.forName("javax.management.MBeanServer");
            objectNameClass = Class.forName("javax.management.ObjectName");
            objectNameConstructor = objectNameClass.getConstructor(String.class);
            isRegistered = mbeanServerClass.getMethod("isRegistered", objectNameClass);
            registerMBean = mbeanServerClass.getMethod("registerMBean", Object.class, objectNameClass);
            unregisterMBean = mbeanServerClass.getMethod("unregisterMBean", objectNameClass);
            jmxAvailable = true;
        }
        catch (ClassNotFoundException e) {
            jmxAvailable = false;
        }
        catch (NoSuchMethodException e) {
            jmxAvailable = false;
        }
        try {
            Class<?> managementFactory = Class.forName("java.lang.management.ManagementFactory");
            Method getPlatformMBeanServer = managementFactory.getMethod("getPlatformMBeanServer", new Class[0]);
            platformMBeanServer = getPlatformMBeanServer.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            platformMBeanServer = null;
        }
    }
}

