/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.text.NumberFormat;
import java.util.Locale;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ParseCondition
extends AbstractRutaCondition {
    private IStringExpression stringExpression;
    private final String var;
    private IStringExpression localeExpr;

    public ParseCondition(String var) {
        this(null, var, null);
    }

    public ParseCondition(String var, IStringExpression localeExpr) {
        this(null, var, localeExpr);
    }

    public ParseCondition(IStringExpression stringExpression, String var, IStringExpression localeExpr) {
        this.stringExpression = stringExpression;
        this.var = var;
        this.localeExpr = localeExpr;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        if (this.stringExpression == null && annotation == null) {
            return new EvaluatedCondition(this, false);
        }
        RuleElement element = context.getElement();
        String text = "";
        text = this.stringExpression != null ? this.stringExpression.getStringValue(context, stream) : annotation.getCoveredText();
        RutaEnvironment env = element.getParent().getEnvironment();
        Class<?> type = env.getVariableType(this.var);
        NumberFormat nf = null;
        String locale = annotation.getCAS().getDocumentLanguage();
        if (this.localeExpr != null) {
            locale = this.localeExpr.getStringValue(context, stream);
        }
        if (locale == null) {
            locale = "x-unspecified";
        }
        nf = NumberFormat.getInstance(Locale.forLanguageTag(locale));
        try {
            if (Integer.class.equals(type)) {
                Number parse = nf.parse(text);
                env.setVariableValue(this.var, parse.intValue());
                return new EvaluatedCondition(this, true);
            }
            if (Double.class.equals(type)) {
                Number parse = nf.parse(text);
                env.setVariableValue(this.var, parse.doubleValue());
                return new EvaluatedCondition(this, true);
            }
            if (Float.class.equals(type)) {
                Number parse = nf.parse(text);
                env.setVariableValue(this.var, Float.valueOf(parse.floatValue()));
                return new EvaluatedCondition(this, true);
            }
            if (String.class.equals(type)) {
                env.setVariableValue(this.var, text);
                return new EvaluatedCondition(this, true);
            }
            if (Boolean.class.equals(type)) {
                env.setVariableValue(this.var, Boolean.valueOf(text));
                return new EvaluatedCondition(this, true);
            }
            if (Type.class.equals(type)) {
                Type value = stream.getCas().getTypeSystem().getType(text);
                env.setVariableValue(this.var, value);
                return new EvaluatedCondition(this, true);
            }
            return new EvaluatedCondition(this, false);
        }
        catch (Exception e) {
            return new EvaluatedCondition(this, false);
        }
    }

    public String getVar() {
        return this.var;
    }

    public IStringExpression getLocaleExpr() {
        return this.localeExpr;
    }

    public void setLocaleExpr(IStringExpression localeExpr) {
        this.localeExpr = localeExpr;
    }
}

