/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.string;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.LazyFeature;
import org.apache.uima.ruta.expression.string.AbstractStringListExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class StringListFeatureExpression
extends AbstractStringListExpression {
    private FeatureExpression fe;

    public StringListFeatureExpression(FeatureExpression fe) {
        this.fe = fe;
    }

    @Override
    public List<String> getList(MatchContext context, RutaStream stream) {
        AnnotationFS annotation = context.getAnnotation();
        Feature feature = this.fe.getFeature(context, stream);
        if (feature == null || !feature.getRange().isArray() || !StringUtils.equals((CharSequence)feature.getRange().getName(), (CharSequence)"uima.cas.StringArray")) {
            return Collections.emptyList();
        }
        List<AnnotationFS> list = this.getTargetAnnotation(annotation, this.fe, context, stream);
        Collection<? extends FeatureStructure> featureStructures = this.fe.getFeatureStructures(list, false, context, stream);
        ArrayList<String> result = new ArrayList<String>();
        for (FeatureStructure featureStructure : featureStructures) {
            FeatureStructure featureValue;
            if (feature instanceof LazyFeature) {
                LazyFeature lazyFeature = (LazyFeature)feature;
                feature = lazyFeature.initialize(featureStructure);
            }
            if (!((featureValue = featureStructure.getFeatureValue(feature)) instanceof StringArrayFS)) continue;
            StringArrayFS array = (StringArrayFS)featureValue;
            for (int i = 0; i < array.size(); ++i) {
                String b = array.get(i);
                result.add(b);
            }
        }
        return result;
    }

    public FeatureExpression getFeatureExpression() {
        return this.fe;
    }

    public void setFeatureExpression(FeatureExpression fe) {
        this.fe = fe;
    }
}

