/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.tools;

import java.io.File;
import java.io.IOException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.tools.F1Scorer;
import org.apache.uima.util.FileUtils;

public class BatchRuleScorer {
    private static String engineFile;
    private static String foldRootDirectory;
    private static int foldCount;
    private static AnalysisEngine ae;

    public static void main(String[] args) {
        engineFile = "/Users/tobi/Documents/UniLaptop/Diplomarbeit/TestDataSets/withPosTags/Subset100/10fold/desc/lp2ergebnisrandomgiantEngine.xml";
        foldRootDirectory = "/Users/tobi/Documents/UniLaptop/Diplomarbeit/TestDataSets/withPosTags/9010_middle/";
        foldCount = 1;
        String[] slotNames = new String[]{"org.apache.uima.ml.types.etime", "org.apache.uima.ml.types.stime", "org.apache.uima.ml.types.location", "org.apache.uima.ml.types.speaker"};
        String[] algIDs = new String[]{"optimizedLP2"};
        ae = TextRulerToolkit.loadAnalysisEngine(engineFile);
        for (int foldNumber = 0; foldNumber < foldCount; ++foldNumber) {
            for (String slotName : slotNames) {
                for (String algID : algIDs) {
                    BatchRuleScorer.scoreRules(foldNumber, slotName, algID);
                }
            }
        }
    }

    public static void scoreRules(int foldNumber, String slotName, String algorithmID) {
        TextRulerToolkit.log("Scoring Fold Number " + foldNumber + "\t  Slot: " + slotName + "\t  Algorithm: " + algorithmID);
        String fromRulesFolder = foldRootDirectory + foldNumber + "/testing/markedFromRules/" + slotName + "/" + algorithmID + "/";
        String originalsFolder = foldRootDirectory + foldNumber + "/testing/withtags/";
        String resultsFile = foldRootDirectory + foldNumber + "/testing/score_" + foldNumber + "_" + algorithmID + "." + slotName + ".txt";
        if (!new File(fromRulesFolder).exists()) {
            TextRulerToolkit.log("\tSKIPPED, fromRulesFolder not found!");
            return;
        }
        F1Scorer scorer = new F1Scorer(ae, originalsFolder, fromRulesFolder);
        F1Scorer.Score slotScore = scorer.scoreSlot(slotName);
        String str = "Score Results for Fold " + foldNumber + "\t  Slot: " + slotName + "\t  Algorithm: " + algorithmID + "\n\n";
        str = str + slotScore.toString();
        try {
            FileUtils.saveString2File((String)str, (File)new File(resultsFile));
        }
        catch (IOException e) {
            TextRulerPlugin.error(e);
        }
    }

    static {
        foldCount = 0;
        ae = null;
    }
}

