/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.localization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringTokenizer;

public class LocaleTokenizer
implements Iterator<Object> {
    private static final String LOCALE_SEPARATOR = ",";
    private static final char QUALITY_SEPARATOR = ';';
    protected static final Float DEFAULT_QUALITY = Float.valueOf(1.0f);
    private ArrayList<AcceptLanguage> locales = new ArrayList(3);

    public LocaleTokenizer(String header) {
        StringTokenizer tok = new StringTokenizer(header, LOCALE_SEPARATOR);
        while (tok.hasMoreTokens()) {
            AcceptLanguage acceptLang = new AcceptLanguage();
            String element = tok.nextToken().trim();
            int index = element.indexOf(59);
            if (index != -1) {
                String q = element.substring(index);
                element = element.substring(0, index);
                index = q.indexOf(61);
                if (index != -1) {
                    try {
                        acceptLang.quality = Float.valueOf(q.substring(index + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            acceptLang.locale = (index = (element = element.trim()).indexOf(45)) == -1 ? new Locale(element, "") : new Locale(element.substring(0, index), element.substring(index + 1));
            this.locales.add(acceptLang);
        }
        this.locales.sort(Collections.reverseOrder());
    }

    @Override
    public boolean hasNext() {
        return !this.locales.isEmpty();
    }

    @Override
    public Object next() {
        if (this.locales.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.locales.remove((int)0).locale;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support remove()");
    }

    protected static class AcceptLanguage
    implements Comparable<Object> {
        Locale locale;
        Float quality = DEFAULT_QUALITY;

        protected AcceptLanguage() {
        }

        @Override
        public int compareTo(Object acceptLang) {
            if (acceptLang == null) {
                throw new NullPointerException("AcceptLanguage not found");
            }
            if (acceptLang instanceof AcceptLanguage) {
                Float q2 = ((AcceptLanguage)acceptLang).quality;
                return this.quality.compareTo(q2);
            }
            throw new NullPointerException("The object to compare is not the correct type");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AcceptLanguage)) {
                return false;
            }
            AcceptLanguage that = (AcceptLanguage)o;
            return this.quality.equals(that.quality);
        }

        public int hashCode() {
            return Objects.hash(this.locale, this.quality);
        }
    }
}

