/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.services.schedule.ScheduleService;
import org.apache.turbine.util.TurbineException;

public class SchedulerTool
implements ApplicationTool {
    private static final Logger log = LogManager.getLogger((String)"scheduler");
    @TurbineService
    private ScheduleService schedulerService;

    @Override
    public void init(Object data) {
        if (this.schedulerService == null) {
            log.error("You can not use the SchedulerTool unless you enable the Scheduler Service!!!!");
        }
    }

    @Override
    public void refresh() {
    }

    public List<? extends JobEntry> getScheduledJobs() {
        return this.schedulerService.listJobs();
    }

    public boolean isEnabled() {
        return this.schedulerService.isEnabled();
    }

    public JobEntry getJob(String jobId) {
        JobEntry je = null;
        try {
            je = this.schedulerService.getJob(Integer.parseInt(jobId));
        }
        catch (TurbineException e) {
            log.error("Could not retreive job id #{}", (Object)jobId, (Object)e);
        }
        return je;
    }
}

