/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSession;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.session.SessionService;

public class TurbineSessionService
extends TurbineBaseService
implements SessionService {
    private ConcurrentMap<String, HttpSession> activeSessions;

    @Override
    public Collection<HttpSession> getActiveSessions() {
        return new ArrayList<HttpSession>(this.activeSessions.values());
    }

    @Override
    public void addSession(HttpSession session) {
        this.activeSessions.put(session.getId(), session);
    }

    @Override
    public void removeSession(HttpSession session) {
        this.activeSessions.remove(session.getId());
    }

    @Override
    public boolean isUserLoggedIn(User user) {
        return this.getActiveUsers().contains(user);
    }

    @Override
    public Collection<User> getActiveUsers() {
        ArrayList<User> users = new ArrayList<User>((int)((double)this.activeSessions.size() * 0.7));
        for (HttpSession session : this.activeSessions.values()) {
            User u = this.getUserFromSession(session);
            if (u == null || !u.hasLoggedIn()) continue;
            users.add(u);
        }
        return users;
    }

    @Override
    public User getUserFromSession(HttpSession session) {
        try {
            return (User)session.getAttribute("turbine.user");
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public HttpSession getSession(String sessionId) {
        return (HttpSession)this.activeSessions.get(sessionId);
    }

    @Override
    public Collection<HttpSession> getSessionsForUser(User user) {
        ArrayList<HttpSession> sessions = new ArrayList<HttpSession>();
        for (HttpSession session : this.activeSessions.values()) {
            User u = this.getUserFromSession(session);
            if (!user.equals(u)) continue;
            sessions.add(session);
        }
        return sessions;
    }

    @Override
    public void init() {
        this.activeSessions = new ConcurrentHashMap<String, HttpSession>();
        this.setInit(true);
    }

    @Override
    public void shutdown() {
        this.activeSessions = null;
        this.setInit(false);
    }
}

