/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.shaded.org.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import nl.basjes.shaded.org.springframework.core.io.Resource;
import nl.basjes.shaded.org.springframework.core.io.UrlResource;
import nl.basjes.shaded.org.springframework.core.io.WritableResource;
import nl.basjes.shaded.org.springframework.lang.Nullable;
import nl.basjes.shaded.org.springframework.util.ResourceUtils;

public class FileUrlResource
extends UrlResource
implements WritableResource {
    @Nullable
    private volatile File file;

    public FileUrlResource(URL url) {
        super(url);
    }

    public FileUrlResource(String location) throws MalformedURLException {
        super("file", location);
    }

    @Override
    public File getFile() throws IOException {
        File file = this.file;
        if (file != null) {
            return file;
        }
        this.file = file = super.getFile();
        return file;
    }

    @Override
    public boolean isWritable() {
        try {
            URL url = this.getURL();
            if (ResourceUtils.isFileURL(url)) {
                File file = this.getFile();
                return file.canWrite() && !file.isDirectory();
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.getFile().toPath(), new OpenOption[0]);
    }

    @Override
    public WritableByteChannel writableChannel() throws IOException {
        return FileChannel.open(this.getFile().toPath(), StandardOpenOption.WRITE);
    }

    @Override
    public Resource createRelative(String relativePath) throws MalformedURLException {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return new FileUrlResource(new URL(this.getURL(), relativePath));
    }
}

