/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.turbine;

import java.util.Set;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.ModelManager;
import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.ACLFactory;
import org.apache.fulcrum.security.model.turbine.TurbineAccessControlList;
import org.apache.fulcrum.security.model.turbine.TurbineAccessControlListImpl;
import org.apache.fulcrum.security.model.turbine.TurbineModelManager;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUser;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.FulcrumSecurityException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class TurbineACLFactory
extends AbstractManager
implements ACLFactory {
    private TurbineModelManager modelManager;

    protected TurbineModelManager getTurbineModelManager() throws DataBackendException {
        if (this.modelManager == null) {
            try {
                this.modelManager = (TurbineModelManager)this.manager.lookup(ModelManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new DataBackendException(ce.getMessage(), ce);
            }
        }
        return this.modelManager;
    }

    @Override
    public <T extends AccessControlList> T getAccessControlList(User user) {
        try {
            TurbineUser tu = (TurbineUser)user;
            Set tugr = tu.getUserGroupRoleSet();
            TurbineAccessControlList aclInstance = this.getAclInstance(tugr);
            return (T)aclInstance;
        }
        catch (UnknownEntityException uue) {
            throw new RuntimeException(uue.getMessage(), uue);
        }
        catch (DataBackendException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private TurbineAccessControlList getAclInstance(Set<? extends TurbineUserGroupRole> turbineUserGroupRoleSet) throws UnknownEntityException {
        TurbineAccessControlListImpl accessControlList;
        TurbineModelManager modelManager;
        RoleManager roleManager;
        GroupManager groupManager;
        block8: {
            groupManager = null;
            roleManager = null;
            modelManager = null;
            try {
                roleManager = this.getRoleManager();
                groupManager = this.getGroupManager();
                modelManager = this.getTurbineModelManager();
                if (groupManager == null) break block8;
                Group g = null;
                try {
                    g = groupManager.getGroupByName(modelManager.getGlobalGroupName());
                }
                catch (UnknownEntityException uee) {
                    g = groupManager.getGroupInstance(modelManager.getGlobalGroupName());
                    try {
                        groupManager.addGroup(g);
                    }
                    catch (EntityExistsException eee) {
                        throw new DataBackendException(eee.getMessage(), eee);
                    }
                }
            }
            catch (DataBackendException g) {
                // empty catch block
            }
        }
        try {
            accessControlList = new TurbineAccessControlListImpl(turbineUserGroupRoleSet, groupManager, roleManager, modelManager);
        }
        catch (FulcrumSecurityException e) {
            throw new UnknownEntityException("Failed to instantiate an ACL implementation object", e);
        }
        return accessControlList;
    }
}

