/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import junit.framework.TestCase;
import org.python.core.PyFloat;

public class PyFloatTest
extends TestCase {
    private static final double nan = Double.NaN;
    private static final double inf = Double.POSITIVE_INFINITY;
    private static final double ninf = Double.NEGATIVE_INFINITY;

    public void test_Double_InfinityAndNaN() {
        PyFloatTest.assertTrue((boolean)true);
        PyFloatTest.assertTrue((boolean)Double.isNaN(Double.NaN));
        PyFloatTest.assertFalse((boolean)Double.isInfinite(Double.NaN));
        PyFloatTest.assertTrue((boolean)true);
        PyFloatTest.assertFalse((boolean)Double.isNaN(Double.POSITIVE_INFINITY));
        PyFloatTest.assertTrue((boolean)Double.isInfinite(Double.POSITIVE_INFINITY));
        PyFloatTest.assertTrue((boolean)true);
        PyFloatTest.assertFalse((boolean)Double.isNaN(Double.NEGATIVE_INFINITY));
        PyFloatTest.assertTrue((boolean)Double.isInfinite(Double.NEGATIVE_INFINITY));
        PyFloatTest.assertTrue((boolean)true);
        PyFloatTest.assertTrue((boolean)true);
        PyFloatTest.assertTrue((boolean)true);
    }

    public void testInfinityAndNaN() {
        PyFloat fNan = new PyFloat(Double.NaN);
        PyFloat fInf = new PyFloat(Double.POSITIVE_INFINITY);
        PyFloat fNinf = new PyFloat(Double.NEGATIVE_INFINITY);
        PyFloatTest.assertTrue((Double.NaN != fNan.getValue() ? 1 : 0) != 0);
        PyFloatTest.assertTrue((boolean)Double.isNaN(fNan.getValue()));
        PyFloatTest.assertFalse((boolean)Double.isInfinite(fNan.getValue()));
        PyFloatTest.assertTrue((Double.POSITIVE_INFINITY == fInf.getValue() ? 1 : 0) != 0);
        PyFloatTest.assertFalse((boolean)Double.isNaN(fInf.getValue()));
        PyFloatTest.assertTrue((boolean)Double.isInfinite(fInf.getValue()));
        PyFloatTest.assertTrue((Double.NEGATIVE_INFINITY == fNinf.getValue() ? 1 : 0) != 0);
        PyFloatTest.assertFalse((boolean)Double.isNaN(fNinf.getValue()));
        PyFloatTest.assertTrue((boolean)Double.isInfinite(fNinf.getValue()));
        PyFloatTest.assertTrue((fNan.getValue() != fInf.getValue() ? 1 : 0) != 0);
        PyFloatTest.assertTrue((fNan.getValue() != fNinf.getValue() ? 1 : 0) != 0);
        PyFloatTest.assertTrue((fInf.getValue() != fNinf.getValue() ? 1 : 0) != 0);
    }

    public void testInfinityAndNaN_repr() {
        PyFloat fNan = new PyFloat(Double.NaN);
        PyFloat fInf = new PyFloat(Double.POSITIVE_INFINITY);
        PyFloat fNinf = new PyFloat(Double.NEGATIVE_INFINITY);
        PyFloatTest.assertEquals((String)"nan", (String)String.valueOf(fNan.__repr__()));
        PyFloatTest.assertEquals((String)"inf", (String)String.valueOf(fInf.__repr__()));
        PyFloatTest.assertEquals((String)"-inf", (String)String.valueOf(fNinf.__repr__()));
    }
}

