/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jdbc;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheManager;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.jcs.auxiliary.disk.jdbc.ShrinkerThread;
import org.apache.jcs.auxiliary.disk.jdbc.TableState;

public abstract class JDBCDiskCacheManagerAbstractTemplate
implements AuxiliaryCacheManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCacheManagerAbstractTemplate == null ? (class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCacheManagerAbstractTemplate = JDBCDiskCacheManagerAbstractTemplate.class$("org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheManagerAbstractTemplate")) : class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCacheManagerAbstractTemplate));
    protected static int clients;
    protected static Hashtable caches;
    protected static Hashtable tableStates;
    private ClockDaemon shrinkerDaemon;
    private Map shrinkerThreadMap = new Hashtable();
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCacheManagerAbstractTemplate;

    protected abstract AuxiliaryCache createJDBCDiskCache(JDBCDiskCacheAttributes var1, TableState var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuxiliaryCache getCache(JDBCDiskCacheAttributes cattr) {
        AuxiliaryCache diskCache = null;
        log.debug((Object)("cacheName = " + cattr.getCacheName()));
        Hashtable hashtable = caches;
        synchronized (hashtable) {
            diskCache = (AuxiliaryCache)caches.get(cattr.getCacheName());
            if (diskCache == null) {
                TableState tableState = (TableState)tableStates.get(cattr.getTableName());
                if (tableState == null) {
                    tableState = new TableState(cattr.getTableName());
                }
                diskCache = this.createJDBCDiskCache(cattr, tableState);
                caches.put(cattr.getCacheName(), diskCache);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JDBC cache = " + diskCache));
        }
        this.createShrinkerWhenNeeded(cattr, diskCache);
        return diskCache;
    }

    protected void createShrinkerWhenNeeded(JDBCDiskCacheAttributes cattr, AuxiliaryCache raf) {
        if (cattr.isUseDiskShrinker()) {
            ShrinkerThread shrinkerThread;
            if (this.shrinkerDaemon == null) {
                this.shrinkerDaemon = new ClockDaemon();
                this.shrinkerDaemon.setThreadFactory((ThreadFactory)new MyThreadFactory());
            }
            if ((shrinkerThread = (ShrinkerThread)this.shrinkerThreadMap.get(cattr.getTableName())) == null) {
                shrinkerThread = new ShrinkerThread();
                this.shrinkerThreadMap.put(cattr.getTableName(), shrinkerThread);
                long intervalMillis = Math.max(999, cattr.getShrinkerIntervalSeconds() * 1000);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Setting the shrinker to run every [" + intervalMillis + "] ms. for table [" + cattr.getTableName() + "]"));
                }
                this.shrinkerDaemon.executePeriodically(intervalMillis, (Runnable)shrinkerThread, false);
            }
            shrinkerThread.addDiskCacheToShrinkList((JDBCDiskCache)raf);
        }
    }

    public void freeCache(String name) {
        JDBCDiskCache raf = (JDBCDiskCache)caches.get(name);
        if (raf != null) {
            raf.dispose();
        }
    }

    public int getCacheType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (--clients != 0) {
            return;
        }
        Hashtable hashtable = caches;
        synchronized (hashtable) {
            Enumeration allCaches = caches.elements();
            while (allCaches.hasMoreElements()) {
                JDBCDiskCache raf = (JDBCDiskCache)allCaches.nextElement();
                if (raf == null) continue;
                raf.dispose();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        caches = new Hashtable();
        tableStates = new Hashtable();
    }

    class MyThreadFactory
    implements ThreadFactory {
        MyThreadFactory() {
        }

        public Thread newThread(Runnable runner) {
            Thread t = new Thread(runner);
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        }
    }
}

