/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.template;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.factory.FactoryException;
import org.apache.fulcrum.factory.FactoryService;
import org.apache.fulcrum.parser.ParameterParser;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.Layout;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.modules.Navigation;
import org.apache.turbine.modules.Page;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.servlet.ServletService;
import org.apache.turbine.services.template.TemplateEngineService;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.services.template.mapper.BaseTemplateMapper;
import org.apache.turbine.services.template.mapper.ClassMapper;
import org.apache.turbine.services.template.mapper.DirectMapper;
import org.apache.turbine.services.template.mapper.DirectTemplateMapper;
import org.apache.turbine.services.template.mapper.LayoutTemplateMapper;
import org.apache.turbine.services.template.mapper.Mapper;
import org.apache.turbine.services.template.mapper.ScreenTemplateMapper;

public class TurbineTemplateService
extends TurbineBaseService
implements TemplateService {
    private static Log log = LogFactory.getLog(TurbineTemplateService.class);
    public static final int PAGE_KEY = 0;
    public static final int SCREEN_KEY = 1;
    public static final int LAYOUT_KEY = 2;
    public static final int NAVIGATION_KEY = 3;
    public static final int LAYOUT_TEMPLATE_KEY = 4;
    public static final String LAYOUT_TEMPLATE_NAME = "layout.template";
    public static final int SCREEN_TEMPLATE_KEY = 5;
    public static final String SCREEN_TEMPLATE_NAME = "screen.template";
    public static final int NAVIGATION_TEMPLATE_KEY = 6;
    public static final String NAVIGATION_TEMPLATE_NAME = "navigation.template";
    public static final int TEMPLATE_TYPES = 7;
    private Mapper[] mapperRegistry = null;
    @Deprecated
    protected static final String NO_FILE_EXT = "";
    private boolean useCache = false;
    private String defaultExtension;
    private String defaultTemplate;
    private ServletService servletService;
    private ConcurrentMap<String, TemplateEngineService> templateEngineRegistry = null;

    @Override
    public void init() throws InitializationException {
        Configuration config = this.getConfiguration();
        this.servletService = (ServletService)TurbineServices.getInstance().getService("ServletService");
        this.defaultExtension = config.getString("default.extension", NO_FILE_EXT);
        this.defaultTemplate = config.getString("default.template", "Default");
        this.useCache = Turbine.getConfiguration().getBoolean("module.cache", true);
        log.debug((Object)("Default Extension: " + this.defaultExtension));
        log.debug((Object)("Default Template:  " + this.defaultTemplate));
        log.debug((Object)("Use Caching:       " + this.useCache));
        this.templateEngineRegistry = new ConcurrentHashMap<String, TemplateEngineService>();
        this.initMapper(config);
        this.setInit(true);
    }

    @Override
    public boolean isCaching() {
        return this.useCache;
    }

    @Override
    public String getDefaultExtension() {
        return StringUtils.isNotEmpty((String)this.defaultExtension) ? this.defaultExtension : NO_FILE_EXT;
    }

    @Override
    public String getExtension(String template) {
        if (StringUtils.isEmpty((String)template)) {
            return this.getDefaultExtension();
        }
        int dotIndex = template.lastIndexOf(46);
        return dotIndex < 0 ? this.getDefaultExtension() : template.substring(dotIndex + 1);
    }

    @Override
    public String getDefaultTemplate() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.defaultTemplate);
        if (StringUtils.isNotEmpty((String)this.defaultExtension)) {
            sb.append('.');
            sb.append(this.getDefaultExtension());
        }
        return sb.toString();
    }

    @Override
    public String getDefaultPage() {
        return this.getDefaultPageName(this.getDefaultTemplate());
    }

    @Override
    public String getDefaultScreen() {
        return this.getDefaultScreenName(this.getDefaultTemplate());
    }

    @Override
    public String getDefaultLayout() {
        return this.getDefaultLayoutName(this.getDefaultTemplate());
    }

    @Override
    public String getDefaultNavigation() {
        return this.getDefaultNavigationName(this.getDefaultTemplate());
    }

    @Override
    public String getDefaultLayoutTemplate() {
        return this.getDefaultLayoutTemplateName(this.getDefaultTemplate());
    }

    @Override
    public String getDefaultPageName(String template) {
        return this.mapperRegistry[0].getDefaultName(template);
    }

    @Override
    public String getDefaultScreenName(String template) {
        return this.mapperRegistry[1].getDefaultName(template);
    }

    @Override
    public String getDefaultLayoutName(String template) {
        return this.mapperRegistry[2].getDefaultName(template);
    }

    @Override
    public String getDefaultNavigationName(String template) {
        return this.mapperRegistry[3].getDefaultName(template);
    }

    @Override
    public String getDefaultLayoutTemplateName(String template) {
        return this.mapperRegistry[4].getDefaultName(template);
    }

    @Override
    public String getDefaultPageName(PipelineData pipelineData) {
        ParameterParser pp = pipelineData.get(Turbine.class, ParameterParser.class);
        String template = pp.get("template");
        return template != null ? this.getDefaultPageName(template) : this.getDefaultPage();
    }

    @Override
    public String getDefaultLayoutName(PipelineData pipelineData) {
        ParameterParser pp = pipelineData.get(Turbine.class, ParameterParser.class);
        String template = pp.get("template");
        return template != null ? this.getDefaultLayoutName(template) : this.getDefaultLayout();
    }

    @Override
    public String getScreenName(String template) throws Exception {
        return this.mapperRegistry[1].getMappedName(template);
    }

    @Override
    public String getLayoutName(String template) throws Exception {
        return this.mapperRegistry[2].getMappedName(template);
    }

    @Override
    public String getNavigationName(String template) throws Exception {
        return this.mapperRegistry[3].getMappedName(template);
    }

    @Override
    public String getScreenTemplateName(String template) throws Exception {
        return this.mapperRegistry[5].getMappedName(template);
    }

    @Override
    public String getLayoutTemplateName(String template) throws Exception {
        return this.mapperRegistry[4].getMappedName(template);
    }

    @Override
    public String getNavigationTemplateName(String template) throws Exception {
        return this.mapperRegistry[6].getMappedName(template);
    }

    @Override
    @Deprecated
    public String[] translateTemplatePaths(String[] templatePaths) {
        for (int i = 0; i < templatePaths.length; ++i) {
            templatePaths[i] = this.servletService.getRealPath(templatePaths[i]);
        }
        return templatePaths;
    }

    @Override
    @Deprecated
    public boolean templateExists(String template, String[] templatePaths) {
        for (String templatePath : templatePaths) {
            if (!new File(templatePath, template).exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerTemplateEngineService(TemplateEngineService service) {
        String[] exts;
        for (String ext : exts = service.getAssociatedFileExtensions()) {
            this.templateEngineRegistry.put(ext, service);
        }
    }

    @Override
    public TemplateEngineService getTemplateEngineService(String template) {
        return (TemplateEngineService)this.templateEngineRegistry.get(this.getExtension(template));
    }

    private void registerMapper(int templateKey, Mapper mapper) {
        mapper.init();
        this.mapperRegistry[templateKey] = mapper;
    }

    private void initMapper(Configuration conf) throws InitializationException {
        this.mapperRegistry = new Mapper[7];
        String[] mapperNames = new String[]{"page", "screen", "layout", "navigation", LAYOUT_TEMPLATE_NAME, SCREEN_TEMPLATE_NAME, NAVIGATION_TEMPLATE_NAME};
        Class[] mapperKeys = new Class[]{Page.class, Screen.class, Layout.class, Navigation.class, Layout.class, Screen.class, Navigation.class};
        String[] mapperClasses = new String[]{DirectMapper.class.getName(), ClassMapper.class.getName(), ClassMapper.class.getName(), ClassMapper.class.getName(), LayoutTemplateMapper.class.getName(), ScreenTemplateMapper.class.getName(), DirectTemplateMapper.class.getName()};
        AssemblerBrokerService ab = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
        int[] mapperCacheSize = new int[mapperKeys.length];
        Loader[] mapperLoader = new Loader[mapperKeys.length];
        for (int i = 0; i < mapperKeys.length; ++i) {
            mapperLoader[i] = ab.getLoader(mapperKeys[i]);
            mapperCacheSize[i] = mapperLoader[i] != null ? mapperLoader[i].getCacheSize() : 0;
        }
        mapperLoader[4] = null;
        mapperLoader[5] = null;
        mapperLoader[6] = null;
        String[] mapperDefaultProperty = new String[]{"default.page", "default.screen", "default.layout", "default.navigation", "default.layout.template", "default.screen.template", "default.navigation.template"};
        char[] mapperSeparator = new char[]{'.', '.', '.', '.', '/', '/', '/'};
        String[] mapperPrefix = new String[]{null, null, null, null, "layouts", "screens", "navigations"};
        for (int i = 0; i < 7; ++i) {
            StringBuilder mapperProperty = new StringBuilder();
            mapperProperty.append("mapper.");
            mapperProperty.append(mapperNames[i]);
            mapperProperty.append(".class");
            String mapperClass = conf.getString(mapperProperty.toString(), mapperClasses[i]);
            log.info((Object)("Using " + mapperClass + " to map " + mapperNames[i] + " elements"));
            Mapper tm = null;
            try {
                FactoryService factory = (FactoryService)TurbineServices.getInstance().getService(FactoryService.ROLE);
                tm = (Mapper)factory.getInstance(mapperClass);
            }
            catch (FactoryException e) {
                throw new InitializationException(NO_FILE_EXT, e);
            }
            tm.setUseCache(this.useCache);
            tm.setCacheSize(mapperCacheSize[i]);
            tm.setDefaultProperty(mapperDefaultProperty[i]);
            tm.setSeparator(mapperSeparator[i]);
            if (mapperLoader[i] != null && tm instanceof ClassMapper) {
                ((ClassMapper)tm).setLoader(mapperLoader[i]);
            }
            if (mapperPrefix[i] != null && tm instanceof BaseTemplateMapper) {
                ((BaseTemplateMapper)((Object)tm)).setPrefix(mapperPrefix[i]);
            }
            this.registerMapper(i, tm);
        }
    }
}

