/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions;

import org.apache.commons.configuration.Configuration;
import org.apache.fulcrum.security.util.FulcrumSecurityException;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.Action;
import org.apache.turbine.om.security.User;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.security.SecurityService;
import org.apache.turbine.util.RunData;

public class LogoutUser
extends Action {
    @TurbineService
    private SecurityService security;
    @TurbineConfiguration
    private Configuration conf;

    @Override
    public void doPerform(PipelineData pipelineData) throws FulcrumSecurityException {
        RunData data = this.getRunData(pipelineData);
        Object user = data.getUser();
        if (!this.security.isAnonymousUser((User)user)) {
            if (!user.hasLoggedIn()) {
                return;
            }
            user.setHasLoggedIn(Boolean.FALSE);
            this.security.saveUser((User)user);
        }
        data.setMessage(this.conf.getString("logout.message"));
        data.setACL(null);
        Object anonymousUser = this.security.getAnonymousUser();
        data.setUser(anonymousUser);
        data.save();
        data.getSession().removeAttribute("turbine.AccessControlList");
        if (!this.conf.getString("action.logout", "LogoutUser").equals("LogoutUser")) {
            data.setScreen(this.conf.getString("screen.homepage"));
        }
    }
}

