/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.EmailUtils;
import org.apache.commons.mail.MultiPartEmail;

public class HtmlEmail
extends MultiPartEmail {
    public static final int CID_LENGTH = 10;
    protected String text;
    protected String html;
    protected List inlineImages = new ArrayList();

    public HtmlEmail setTextMsg(String aText) throws EmailException {
        if (EmailUtils.isEmpty(aText)) {
            throw new EmailException("Invalid message supplied");
        }
        this.text = aText;
        return this;
    }

    public HtmlEmail setHtmlMsg(String aHtml) throws EmailException {
        if (EmailUtils.isEmpty(aHtml)) {
            throw new EmailException("Invalid message supplied");
        }
        this.html = aHtml;
        return this;
    }

    public Email setMsg(String msg) throws EmailException {
        if (EmailUtils.isEmpty(msg)) {
            throw new EmailException("Invalid message supplied");
        }
        this.setTextMsg(msg);
        this.setHtmlMsg("<html><body><pre>" + msg + "</pre></body></html>");
        return this;
    }

    public String embed(URL url, String name) throws EmailException {
        try {
            InputStream is = url.openStream();
            is.close();
        }
        catch (IOException e) {
            throw new EmailException("Invalid URL");
        }
        MimeBodyPart mbp = new MimeBodyPart();
        try {
            mbp.setDataHandler(new DataHandler((DataSource)new URLDataSource(url)));
            mbp.setFileName(name);
            mbp.setDisposition("inline");
            String cid = EmailUtils.randomAlphabetic(10).toLowerCase();
            mbp.addHeader("Content-ID", "<" + cid + ">");
            this.inlineImages.add(mbp);
            return cid;
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
    }

    public void buildMimeMessage() throws EmailException {
        try {
            if (this.isBoolHasAttachments()) {
                this.buildAttachments();
            } else {
                this.buildNoAttachments();
            }
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        super.buildMimeMessage();
    }

    private void buildAttachments() throws MessagingException, EmailException {
        MimeMultipart container = this.getContainer();
        MimeMultipart subContainer = null;
        MimeMultipart subContainerHTML = new MimeMultipart("related");
        MimeBodyPart msgHtml = null;
        MimeBodyPart msgText = null;
        container.setSubType("mixed");
        subContainer = new MimeMultipart("alternative");
        if (EmailUtils.isNotEmpty(this.text)) {
            msgText = new MimeBodyPart();
            subContainer.addBodyPart((BodyPart)msgText);
            if (EmailUtils.isNotEmpty(this.charset)) {
                msgText.setContent((Object)this.text, "text/plain; charset=" + this.charset);
            } else {
                msgText.setContent((Object)this.text, "text/plain");
            }
        }
        if (EmailUtils.isNotEmpty(this.html)) {
            if (this.inlineImages.size() > 0) {
                msgHtml = new MimeBodyPart();
                subContainerHTML.addBodyPart((BodyPart)msgHtml);
            } else {
                msgHtml = new MimeBodyPart();
                subContainer.addBodyPart((BodyPart)msgHtml);
            }
            if (EmailUtils.isNotEmpty(this.charset)) {
                msgHtml.setContent((Object)this.html, "text/html; charset=" + this.charset);
            } else {
                msgHtml.setContent((Object)this.html, "text/html");
            }
            Iterator iter = this.inlineImages.iterator();
            while (iter.hasNext()) {
                subContainerHTML.addBodyPart((BodyPart)iter.next());
            }
        }
        this.addPart(subContainer, 0);
        if (this.inlineImages.size() > 0) {
            this.addPart(subContainerHTML, 1);
        }
    }

    private void buildNoAttachments() throws MessagingException, EmailException {
        MimeMultipart container = this.getContainer();
        MimeMultipart subContainerHTML = new MimeMultipart("related");
        container.setSubType("alternative");
        BodyPart msgText = null;
        BodyPart msgHtml = null;
        if (EmailUtils.isNotEmpty(this.text)) {
            msgText = this.getPrimaryBodyPart();
            if (EmailUtils.isNotEmpty(this.charset)) {
                msgText.setContent((Object)this.text, "text/plain; charset=" + this.charset);
            } else {
                msgText.setContent((Object)this.text, "text/plain");
            }
        }
        if (EmailUtils.isNotEmpty(this.html)) {
            if (msgText == null) {
                msgHtml = this.getPrimaryBodyPart();
            } else if (this.inlineImages.size() > 0) {
                msgHtml = new MimeBodyPart();
                subContainerHTML.addBodyPart(msgHtml);
            } else {
                msgHtml = new MimeBodyPart();
                container.addBodyPart(msgHtml, 1);
            }
            if (EmailUtils.isNotEmpty(this.charset)) {
                msgHtml.setContent((Object)this.html, "text/html; charset=" + this.charset);
            } else {
                msgHtml.setContent((Object)this.html, "text/html");
            }
            Iterator iter = this.inlineImages.iterator();
            while (iter.hasNext()) {
                subContainerHTML.addBodyPart((BodyPart)iter.next());
            }
            if (this.inlineImages.size() > 0) {
                this.addPart(subContainerHTML);
            }
        }
    }
}

