/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.fulcrum.jce.crypto.CryptoParameters;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactory;
import org.apache.fulcrum.jce.crypto.PasswordFactory;
import org.apache.fulcrum.jce.crypto.SmartDecryptingInputStream;

public final class CryptoStreamFactoryImpl
implements CryptoStreamFactory {
    private byte[] salt;
    private int count;
    private String providerName;
    private String algorithm;
    private static CryptoStreamFactory instance;
    static /* synthetic */ Class class$org$apache$fulcrum$jce$crypto$CryptoStreamFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoStreamFactory getInstance() {
        if (instance == null) {
            Class clazz = class$org$apache$fulcrum$jce$crypto$CryptoStreamFactory == null ? (class$org$apache$fulcrum$jce$crypto$CryptoStreamFactory = CryptoStreamFactoryImpl.class$("org.apache.fulcrum.jce.crypto.CryptoStreamFactory")) : class$org$apache$fulcrum$jce$crypto$CryptoStreamFactory;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new CryptoStreamFactoryImpl();
                }
            }
        }
        return instance;
    }

    public static void setInstance(CryptoStreamFactory instance) {
        CryptoStreamFactoryImpl.instance = instance;
    }

    public CryptoStreamFactoryImpl() {
        this.salt = CryptoParameters.SALT;
        this.count = 20;
        this.providerName = CryptoParameters.PROVIDERNAME;
        this.algorithm = "PBEWithMD5AndDES";
    }

    public CryptoStreamFactoryImpl(byte[] salt, int count, String algorithm, String providerName) {
        this.salt = salt;
        this.count = count;
        this.algorithm = algorithm;
        this.providerName = providerName;
    }

    public InputStream getInputStream(InputStream is) throws GeneralSecurityException, IOException {
        Cipher cipher = this.createCipher(2, PasswordFactory.create());
        CipherInputStream cis = new CipherInputStream(is, cipher);
        return cis;
    }

    public InputStream getInputStream(InputStream is, char[] password) throws GeneralSecurityException, IOException {
        Cipher cipher = this.createCipher(2, password);
        CipherInputStream cis = new CipherInputStream(is, cipher);
        return cis;
    }

    public InputStream getSmartInputStream(InputStream is) throws GeneralSecurityException, IOException {
        return this.getSmartInputStream(is, PasswordFactory.create());
    }

    public InputStream getSmartInputStream(InputStream is, char[] password) throws GeneralSecurityException, IOException {
        SmartDecryptingInputStream result = null;
        result = new SmartDecryptingInputStream(CryptoStreamFactoryImpl.getInstance(), is, password);
        return result;
    }

    public OutputStream getOutputStream(OutputStream os, char[] password) throws GeneralSecurityException, IOException {
        Cipher cipher = this.createCipher(1, password);
        CipherOutputStream cos = new CipherOutputStream(os, cipher);
        return cos;
    }

    private final String getAlgorithm() {
        return this.algorithm;
    }

    private final int getCount() {
        return this.count;
    }

    private final String getProviderName() {
        return this.providerName;
    }

    private final byte[] getSalt() {
        return this.salt;
    }

    private final Key createKey(char[] password) throws GeneralSecurityException {
        SecretKeyFactory keyFactory = null;
        String algorithm = this.getAlgorithm();
        PBEKeySpec keySpec = new PBEKeySpec(password);
        keyFactory = this.getProviderName() == null ? SecretKeyFactory.getInstance(algorithm) : SecretKeyFactory.getInstance(algorithm, this.getProviderName());
        SecretKey key = keyFactory.generateSecret(keySpec);
        return key;
    }

    private final Cipher createCipher(int mode, char[] password) throws GeneralSecurityException, IOException {
        Cipher cipher = null;
        PBEParameterSpec paramSpec = new PBEParameterSpec(this.getSalt(), this.getCount());
        Key key = this.createKey(password);
        cipher = this.getProviderName() == null ? Cipher.getInstance(this.getAlgorithm()) : Cipher.getInstance(this.getAlgorithm(), this.getProviderName());
        cipher.init(mode, key, paramSpec);
        return cipher;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

