/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.velocity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.pull.PullService;
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.services.template.BaseTemplateEngineService;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.MethodExceptionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.Log4JLogChute;

public class TurbineVelocityService
extends BaseTemplateEngineService
implements VelocityService,
MethodExceptionEventHandler {
    private static final String RESOURCE_LOADER_PATH = ".resource.loader.path";
    private static final String DEFAULT_CHAR_SET = "ISO-8859-1";
    private static final String JAR_PREFIX = "jar:";
    private static final String ABSOLUTE_PREFIX = "file://";
    private static Log log = LogFactory.getLog((Class)TurbineVelocityService.class);
    private boolean pullModelActive = false;
    private boolean catchErrors = true;
    private String defaultEncoding = "ISO-8859-1";
    private PullService pullService = null;

    public void init() throws InitializationException {
        try {
            this.initVelocity();
            if (TurbinePull.isRegistered()) {
                this.pullModelActive = true;
                this.pullService = TurbinePull.getService();
                log.debug((Object)"Activated Pull Tools");
            }
            this.registerConfiguration("vm");
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("Failed to initialize TurbineVelocityService", e);
        }
    }

    public void init(ServletConfig config) throws InitializationException {
        this.init();
    }

    public Context getContext() {
        Context globalContext = this.pullModelActive ? this.pullService.getGlobalContext() : null;
        VelocityContext ctx = new VelocityContext(globalContext);
        return ctx;
    }

    public Context getNewContext() {
        VelocityContext ctx = new VelocityContext();
        EventCartridge ec = new EventCartridge();
        ec.addEventHandler((EventHandler)this);
        ec.attachToContext((Context)ctx);
        return ctx;
    }

    public Object methodException(Class clazz, String method, Exception e) throws Exception {
        log.error((Object)("Class " + clazz.getName() + "." + method + " threw Exception"), (Throwable)e);
        if (!this.catchErrors) {
            throw e;
        }
        return "[Turbine caught an Error here. Look into the turbine.log for further information]";
    }

    public Context getContext(RunData data) {
        Context context = (Context)data.getTemplateInfo().getTemplateContext("VELOCITY_CONTEXT");
        if (context == null) {
            context = this.getContext();
            context.put("data", (Object)data);
            if (this.pullModelActive) {
                this.pullService.populateContext(context, data);
            }
            data.getTemplateInfo().setTemplateContext("VELOCITY_CONTEXT", context);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String handleRequest(Context context, String filename) throws TurbineException {
        String results;
        block11: {
            results = null;
            ByteArrayOutputStream bytes = null;
            OutputStreamWriter writer = null;
            String charset = this.getCharSet(context);
            bytes = new ByteArrayOutputStream();
            writer = new OutputStreamWriter((OutputStream)bytes, charset);
            this.executeRequest(context, filename, writer);
            writer.flush();
            results = bytes.toString(charset);
            Object var9_7 = null;
            try {
                if (bytes != null) {
                    bytes.close();
                }
                break block11;
            }
            catch (IOException ignored) {}
            break block11;
            {
                catch (Exception e) {
                    TurbineVelocityService.renderingError(filename, e);
                    Object var9_8 = null;
                    try {
                        if (bytes != null) {
                            bytes.close();
                        }
                        break block11;
                    }
                    catch (IOException ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (bytes != null) {
                        bytes.close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handleRequest(Context context, String filename, OutputStream output) throws TurbineException {
        block11: {
            String charset = this.getCharSet(context);
            OutputStreamWriter writer = null;
            writer = new OutputStreamWriter(output, charset);
            this.executeRequest(context, filename, writer);
            Object var8_6 = null;
            try {
                if (writer != null) {
                    writer.flush();
                }
                break block11;
            }
            catch (Exception ignored) {}
            break block11;
            {
                catch (Exception e) {
                    TurbineVelocityService.renderingError(filename, e);
                    Object var8_7 = null;
                    try {
                        if (writer != null) {
                            writer.flush();
                        }
                        break block11;
                    }
                    catch (Exception ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (writer != null) {
                        writer.flush();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handleRequest(Context context, String filename, Writer writer) throws TurbineException {
        block11: {
            this.executeRequest(context, filename, writer);
            Object var6_4 = null;
            try {
                if (writer != null) {
                    writer.flush();
                }
                break block11;
            }
            catch (Exception ignored) {}
            break block11;
            {
                catch (Exception e) {
                    TurbineVelocityService.renderingError(filename, e);
                    Object var6_5 = null;
                    try {
                        if (writer != null) {
                            writer.flush();
                        }
                        break block11;
                    }
                    catch (Exception ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (writer != null) {
                        writer.flush();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void executeRequest(Context context, String filename, Writer writer) throws Exception {
        String encoding = this.getEncoding(context);
        Velocity.mergeTemplate((String)filename, (String)encoding, (Context)context, (Writer)writer);
    }

    private String getCharSet(Context context) {
        String charset = null;
        Object data = context.get("data");
        if (data != null && data instanceof RunData) {
            charset = ((RunData)data).getCharSet();
        }
        return StringUtils.isEmpty(charset) ? DEFAULT_CHAR_SET : charset;
    }

    private String getEncoding(Context context) {
        String encoding = null;
        Object data = context.get("data");
        if (data != null && data instanceof RunData) {
            encoding = ((RunData)data).getTemplateEncoding();
        }
        return StringUtils.isEmpty(encoding) ? this.defaultEncoding : encoding;
    }

    private static void renderingError(String filename, Exception e) throws TurbineException {
        String err = "Error rendering Velocity template: " + filename;
        log.error((Object)err, (Throwable)e);
        throw new TurbineException(err, e);
    }

    private synchronized void initVelocity() throws Exception {
        Configuration conf = this.getConfiguration();
        this.catchErrors = conf.getBoolean("catch.errors", true);
        if (conf.containsKey("input.encoding")) {
            this.defaultEncoding = conf.getString("input.encoding");
        }
        conf.setProperty("runtime.log.logsystem.class", (Object)Log4JLogChute.class.getName());
        conf.setProperty("runtime.log.logsystem.log4j.category", (Object)"velocity");
        Velocity.setExtendedProperties((ExtendedProperties)this.createVelocityProperties(conf));
        Velocity.init();
    }

    public ExtendedProperties createVelocityProperties(Configuration conf) throws Exception {
        ExtendedProperties veloConfig = new ExtendedProperties();
        Iterator i = conf.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.endsWith(RESOURCE_LOADER_PATH)) {
                Object value = conf.getProperty(key);
                if (value instanceof List) {
                    List srcValue = (List)value;
                    Vector targetValue = new Vector(srcValue.size());
                    Iterator it = srcValue.iterator();
                    while (it.hasNext()) {
                        targetValue.add(it.next());
                    }
                    veloConfig.addProperty(key, targetValue);
                    continue;
                }
                veloConfig.addProperty(key, value);
                continue;
            }
            List paths = conf.getList(key, null);
            if (paths == null) continue;
            Velocity.clearProperty((String)key);
            Iterator j = paths.iterator();
            while (j.hasNext()) {
                String path = (String)j.next();
                log.debug((Object)("Translating " + path));
                if (path.startsWith(JAR_PREFIX)) {
                    if (path.substring(4).startsWith(ABSOLUTE_PREFIX)) {
                        int jarSepIndex = path.indexOf("!/");
                        path = jarSepIndex < 0 ? Turbine.getRealPath(path.substring(11)) : Turbine.getRealPath(path.substring(11, jarSepIndex)) + path.substring(jarSepIndex);
                        log.debug((Object)("Result (absolute jar path): " + path));
                    }
                } else if (path.startsWith(ABSOLUTE_PREFIX)) {
                    path = Turbine.getRealPath(path.substring(7));
                    log.debug((Object)("Result (absolute URL Path): " + path));
                } else if (path.indexOf("://") < 0) {
                    path = Turbine.getRealPath(path);
                    log.debug((Object)("Result (normal fs reference): " + path));
                }
                log.debug((Object)("Adding " + key + " -> " + path));
                veloConfig.addProperty(key, (Object)path);
            }
        }
        return veloConfig;
    }

    public boolean templateExists(String template) {
        return Velocity.resourceExists((String)template);
    }

    public void requestFinished(Context context) {
        if (this.pullModelActive) {
            this.pullService.releaseTools(context);
        }
    }
}

