/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.InvalidMaskException;
import org.apache.turbine.services.intake.validator.NumberValidator;
import org.apache.turbine.services.intake.validator.ValidationException;

public class BigDecimalValidator
extends NumberValidator {
    private BigDecimal minValue = null;
    private BigDecimal maxValue = null;

    public BigDecimalValidator(Map paramMap) throws InvalidMaskException {
        this.invalidNumberMessage = "Entry was not a valid BigDecimal";
        this.init(paramMap);
    }

    public BigDecimalValidator() {
    }

    public void init(Map paramMap) throws InvalidMaskException {
        String param;
        super.init(paramMap);
        Constraint constraint = (Constraint)paramMap.get("minValue");
        if (constraint != null) {
            param = constraint.getValue();
            this.minValue = new BigDecimal(param);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxValue")) != null) {
            param = constraint.getValue();
            this.maxValue = new BigDecimal(param);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    public void assertValidity(Field field) throws ValidationException {
        Locale locale = field.getLocale();
        if (field.isMultiValued()) {
            String[] stringValues = (String[])field.getTestValue();
            for (int i = 0; i < stringValues.length; ++i) {
                this.assertValidity(stringValues[i], locale);
            }
        } else {
            this.assertValidity((String)field.getTestValue(), locale);
        }
    }

    public void assertValidity(String testValue, Locale locale) throws ValidationException {
        super.assertValidity(testValue);
        if (this.required || StringUtils.isNotEmpty((String)testValue)) {
            BigDecimal bd = null;
            NumberFormat nf = NumberFormat.getInstance(locale);
            try {
                Number number = nf.parse(testValue);
                bd = new BigDecimal(number.doubleValue());
            }
            catch (ParseException e) {
                this.errorMessage = this.invalidNumberMessage;
                throw new ValidationException(this.invalidNumberMessage);
            }
            if (this.minValue != null && bd.compareTo(this.minValue) < 0) {
                this.errorMessage = this.minValueMessage;
                throw new ValidationException(this.minValueMessage);
            }
            if (this.maxValue != null && bd.compareTo(this.maxValue) > 0) {
                this.errorMessage = this.maxValueMessage;
                throw new ValidationException(this.maxValueMessage);
            }
        }
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }
}

