/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.turbine;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.model.turbine.entity.TurbineGroup;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.torque.om.TorqueTurbineGroup;
import org.apache.fulcrum.security.torque.om.TorqueTurbineGroupPeer;
import org.apache.fulcrum.security.torque.peer.TorqueTurbinePeer;
import org.apache.fulcrum.security.torque.peer.managers.PeerGroupManager;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public class TorqueTurbineGroupManagerImpl
extends PeerGroupManager {
    private static final long serialVersionUID = -5583297428186549693L;

    @Override
    protected <T extends Group> List<T> doSelectAllGroups(Connection con) throws TorqueException {
        Criteria criteria = new Criteria();
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbinePeer peerInstance = (TorqueTurbinePeer)this.getPeerInstance();
                return peerInstance.doSelect(criteria, con);
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        }
        return TorqueTurbineGroupPeer.doSelect(criteria, con);
    }

    @Override
    protected <T extends Group> T doSelectById(Integer id, Connection con) throws NoRowsException, TooManyRowsException, TorqueException {
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbinePeer peerInstance = (TorqueTurbinePeer)this.getPeerInstance();
                return (T)((Group)peerInstance.retrieveByPK(id, con));
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        }
        return (T)TorqueTurbineGroupPeer.retrieveByPK(id, con);
    }

    @Override
    protected <T extends Group> T doSelectByName(String name, Connection con) throws NoRowsException, TooManyRowsException, TorqueException {
        Criteria criteria = new Criteria();
        criteria.setIgnoreCase(true);
        criteria.setSingleRecord(true);
        List<TorqueTurbineGroup> groups = null;
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbinePeer peerInstance = (TorqueTurbinePeer)this.getPeerInstance();
                criteria.where((Object)peerInstance.getTableMap().getColumn(this.getColumnName()), (Object)name);
                groups = peerInstance.doSelect(criteria, con);
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        } else {
            criteria.where((Object)TorqueTurbineGroupPeer.GROUP_NAME, (Object)name);
            groups = TorqueTurbineGroupPeer.doSelect(criteria, con);
        }
        if (groups.isEmpty()) {
            throw new NoRowsException(name);
        }
        return (T)((Group)groups.get(0));
    }

    public Set<TurbineUserGroupRole> getUserGroupRoleSet(Group group) throws DataBackendException {
        TorqueConnection con = null;
        if (this.getLazyLoading().booleanValue()) {
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)group).retrieveAttachedObjects((Connection)con, false);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("Error retrieving group information", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
        }
        return ((TurbineGroup)group).getUserGroupRoleSet();
    }
}

