/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.basic;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.basic.entity.BasicGroup;
import org.apache.fulcrum.security.torque.om.TorqueBasicGroupPeer;
import org.apache.fulcrum.security.torque.om.TorqueBasicUserGroup;
import org.apache.fulcrum.security.torque.om.TorqueBasicUserGroupPeer;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UserSet;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.SimpleKey;

public abstract class TorqueAbstractBasicGroup
extends TorqueAbstractSecurityEntity
implements BasicGroup {
    private static final long serialVersionUID = -3639383219058996135L;
    private Set<User> userSet = null;

    protected List<TorqueBasicUserGroup> getTorqueBasicUserGroupsJoinTorqueBasicUser(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueBasicUserGroupPeer.GROUP_ID, (Object)this.getEntityId());
        return TorqueBasicUserGroupPeer.doSelectJoinTorqueBasicUser(criteria, con);
    }

    public void addUser(User user) {
        this.getUsers().add((SecurityEntity)user);
    }

    public UserSet getUsers() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        } else if (!(this.userSet instanceof UserSet)) {
            this.userSet = new UserSet(this.userSet);
        }
        return (UserSet)this.userSet;
    }

    public <T extends User> Set<T> getUsersAsSet() {
        return this.userSet;
    }

    public void removeUser(User user) {
        this.getUsers().remove((Object)user);
    }

    public void setUsers(UserSet userSet) {
        this.userSet = userSet != null ? userSet : new UserSet();
    }

    public <T extends User> void setUsersAsSet(Set<T> users) {
        this.setUsers(new UserSet(users));
    }

    @Override
    public void retrieveAttachedObjects(Connection con) throws DataBackendException {
        this.retrieveAttachedObjects(con, false);
    }

    @Override
    public void retrieveAttachedObjects(Connection con, Boolean lazy) throws DataBackendException {
        this.userSet = new UserSet();
        try {
            List<TorqueBasicUserGroup> usergroups = this.getTorqueBasicUserGroupsJoinTorqueBasicUser(new Criteria(), con);
            for (TorqueBasicUserGroup tbug : usergroups) {
                this.userSet.add((User)tbug.getTorqueBasicUser());
            }
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(Connection con) throws TorqueException {
        if (this.userSet != null) {
            Criteria criteria = new Criteria();
            criteria.where((Object)TorqueBasicUserGroupPeer.GROUP_ID, (Object)this.getEntityId());
            TorqueBasicUserGroupPeer.doDelete(criteria, con);
            for (User u : this.userSet) {
                TorqueBasicUserGroup ug = new TorqueBasicUserGroup();
                ug.setUserId((Integer)u.getId());
                ug.setGroupId(this.getEntityId());
                ug.save(con);
            }
        }
        try {
            this.save(con);
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public String getDatabaseName() {
        return TorqueBasicGroupPeer.DATABASE_NAME;
    }

    @Override
    public void delete() throws TorqueException {
        TorqueBasicGroupPeer.doDelete(SimpleKey.keyFor((Number)this.getEntityId()));
    }
}

