package org.apache.fulcrum.crypto.provider;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.fulcrum.crypto.CryptoAlgorithm;

/**
 * This is a dummy for "cleartext" encryption. It goes through the notions of
 * the CryptoAlgorithm interface but actually does nothing. It can be used as a
 * replacement for the "encrypt = no" setting in TurbineResources.
 *
 * Can be used as the default crypto algorithm
 *
 * @author <a href="mailto:hps@intermeta.de">Henning P. Schmiedehausen</a>
 * @version $Id: ClearCrypt.java 1852158 2019-01-25 18:19:46Z painter $
 */
public class ClearCrypt implements CryptoAlgorithm {
	
	/**
	 * Constructor
	 */
	public ClearCrypt() 
	{
	}

	/**
	 * This class never uses an algorithm, so this is just a dummy.
	 *
	 * @param cipher Cipher (ignored)
	 */
	public void setCipher(String cipher) 
	{
	}

	/**
	 * This class never uses a seed, so this is just a dummy.
	 *
	 * @param seed Seed (ignored)
	 */
	public void setSeed(String seed) 
	{
	}

	/**
	 * This method performs no encryption and will simply
	 * return the value passed
	 *
	 * @param value The value to be encrypted
	 * @return The original value
	 * @throws Exception An Exception of the underlying implementation.
	 */
	public String encrypt(String value) throws Exception 
	{
		return value;
	}
}
