/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FoliationRepresentation;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.io.InvalidSeekException;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.io.stream.RewindableLineReader;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.util.GeodeticObjectBuilder;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.csv.FeatureIterator;
import org.apache.sis.storage.csv.Foliation;
import org.apache.sis.storage.csv.MovingFeatureBuilder;
import org.apache.sis.storage.csv.MovingFeatureIterator;
import org.apache.sis.storage.csv.StoreProvider;
import org.apache.sis.storage.csv.TimeEncoding;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.internal.StandardDateFormat;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

final class Store
extends URIDataStore
implements FeatureSet {
    private static final char COMMENT = '#';
    static final char METADATA = '@';
    private static final char QUOTE = '\"';
    static final char SEPARATOR = ',';
    static final char ORDINATE_SEPARATOR = ' ';
    private static final String TYPE_PREFIX = "xsd:";
    private static final String XS_PREFIX = "xs:";
    private BufferedReader source;
    private final Charset encoding;
    private transient DefaultMetadata metadata;
    private final ImmutableEnvelope envelope;
    final DefaultFeatureType featureType;
    private boolean hasTrajectories;
    private short spatialDimensionCount;
    final Geometries<?> geometries;
    final Foliation foliation;
    private TimeEncoding timeEncoding;
    private boolean dissociate;
    private transient List<AbstractFeature> movingFeatures;

    public Store(StoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        Reader r = connector.commit(Reader.class, "CSV");
        this.source = r instanceof BufferedReader ? (BufferedReader)r : new LineNumberReader(r);
        this.geometries = Geometries.factory(connector.getOption(OptionKey.GEOMETRY_LIBRARY));
        this.dissociate = FoliationRepresentation.FRAGMENTED.equals((Object)connector.getOption(DataOptionKey.FOLIATION_REPRESENTATION));
        GeneralEnvelope envelope = null;
        DefaultFeatureType featureType = null;
        Foliation foliation = null;
        try {
            String line;
            ArrayList<String> elements = new ArrayList<String>();
            this.source.mark(8192);
            while ((line = this.source.readLine()) != null) {
                char c;
                if ((line = line.trim()).isEmpty() || (c = line.charAt(0)) == '#') continue;
                if (c != '@') break;
                Store.split(line, elements);
                String keyword = (String)elements.get(0);
                switch (keyword.toLowerCase(Locale.US)) {
                    case "@stboundedby": {
                        if (envelope != null) {
                            throw new DataStoreContentException(this.duplicated("@stboundedby"));
                        }
                        if (featureType != null) {
                            throw new DataStoreContentException(Resources.forLocale(this.getLocale()).getString((short)22, "@columns", "@stboundedby"));
                        }
                        envelope = this.parseEnvelope(elements);
                        this.dissociate |= this.timeEncoding == null;
                        break;
                    }
                    case "@columns": {
                        if (featureType != null) {
                            throw new DataStoreContentException(this.duplicated("@columns"));
                        }
                        featureType = this.parseFeatureType(elements);
                        break;
                    }
                    case "@foliation": {
                        if (foliation != null) {
                            throw new DataStoreContentException(this.duplicated("@foliation"));
                        }
                        foliation = this.parseFoliation(elements);
                        break;
                    }
                    default: {
                        LogRecord record = this.errors().getLogRecord(Level.WARNING, (short)147, keyword);
                        record.setSourceClassName(Store.class.getName());
                        record.setSourceMethodName("parseHeader");
                        this.listeners.warning(record);
                        break;
                    }
                }
                elements.clear();
                this.source.mark(8192);
            }
            this.source.reset();
        }
        catch (IOException e) {
            throw new DataStoreException(this.getLocale(), "CSV", super.getDisplayName(), (Object)this.source).initCause(e);
        }
        catch (FactoryException e) {
            throw new DataStoreReferencingException(this.getLocale(), "CSV", super.getDisplayName(), (Object)this.source).initCause(e);
        }
        catch (IllegalArgumentException | DateTimeException e) {
            throw new DataStoreContentException(this.getLocale(), "CSV", super.getDisplayName(), (Object)this.source).initCause(e);
        }
        this.encoding = connector.getOption(OptionKey.ENCODING);
        this.envelope = ImmutableEnvelope.castOrCopy(envelope);
        this.featureType = featureType;
        this.foliation = foliation;
        this.dissociate |= this.timeEncoding == null;
        this.listeners.useReadOnlyEvents();
    }

    private void rewind() throws IOException {
        BufferedReader reader = this.source;
        if (!(reader instanceof RewindableLineReader)) {
            throw new InvalidSeekException(Resources.forLocale(this.getLocale()).getString((short)13, this.getDisplayName()));
        }
        this.source = ((RewindableLineReader)reader).rewind();
        if (this.source != reader) {
            char c;
            String line;
            while ((line = this.source.readLine()) != null && ((line = line.trim()).isEmpty() || (c = line.charAt(0)) == '#' || c == '@')) {
                this.source.mark(8192);
            }
            this.source.reset();
        }
    }

    private GeneralEnvelope parseEnvelope(List<String> elements) throws DataStoreException, FactoryException {
        int dim;
        GeneralEnvelope envelope;
        CoordinateReferenceSystem crs = null;
        int spatialDimensionCount = 2;
        boolean isDimExplicit = false;
        double[] lowerCorner = ArraysExt.EMPTY_DOUBLE;
        double[] upperCorner = ArraysExt.EMPTY_DOUBLE;
        Instant startTime = null;
        Instant endTime = null;
        Unit<Time> timeUnit = Units.SECOND;
        boolean isTimeAbsolute = false;
        int ordinal = -1;
        block25: for (String element : elements) {
            ++ordinal;
            if (element.isEmpty()) continue;
            switch (ordinal) {
                case 0: {
                    continue block25;
                }
                case 1: {
                    crs = CRS.forCode(element);
                    continue block25;
                }
                case 2: {
                    if (element.length() == 2 && Character.toUpperCase(element.charAt(1)) == 'D') {
                        isDimExplicit = true;
                        spatialDimensionCount = element.charAt(0) - 48;
                        if (spatialDimensionCount >= 1 && spatialDimensionCount <= 3) continue block25;
                        throw new DataStoreReferencingException(this.errors().getString((short)51, element));
                    }
                    ++ordinal;
                }
                case 3: {
                    lowerCorner = CharSequences.parseDoubles(element, ' ');
                    continue block25;
                }
                case 4: {
                    upperCorner = CharSequences.parseDoubles(element, ' ');
                    continue block25;
                }
                case 5: {
                    startTime = StandardDateFormat.parseInstantUTC(element);
                    continue block25;
                }
                case 6: {
                    endTime = StandardDateFormat.parseInstantUTC(element);
                    continue block25;
                }
                case 7: {
                    switch (element.toLowerCase(Locale.US)) {
                        case "sec": 
                        case "second": {
                            continue block25;
                        }
                        case "minute": {
                            timeUnit = Units.MINUTE;
                            continue block25;
                        }
                        case "hour": {
                            timeUnit = Units.HOUR;
                            continue block25;
                        }
                        case "day": {
                            timeUnit = Units.DAY;
                            continue block25;
                        }
                        case "absolute": {
                            isTimeAbsolute = true;
                            continue block25;
                        }
                    }
                    throw new DataStoreReferencingException(this.errors().getString((short)150, element));
                }
            }
            break;
        }
        if (crs != null) {
            int count = 0;
            CoordinateReferenceSystem[] components = new CoordinateReferenceSystem[3];
            components[count++] = crs;
            int dimension = crs.getCoordinateSystem().getDimension();
            if (isDimExplicit) {
                if (spatialDimensionCount > dimension) {
                    components[count++] = CommonCRS.Vertical.MEAN_SEA_LEVEL.crs();
                    ++dimension;
                }
                if (dimension != spatialDimensionCount) {
                    throw new DataStoreReferencingException(this.errors().getString((short)81, "@stboundedby(CRS)", spatialDimensionCount, dimension));
                }
            }
            if (dimension >= Short.MAX_VALUE) {
                throw new DataStoreReferencingException(this.errors().getString((short)37, dimension));
            }
            spatialDimensionCount = dimension;
            GeodeticObjectBuilder builder = new GeodeticObjectBuilder();
            Object name = crs.getName().getCode();
            if (startTime != null) {
                TemporalCRS temporal;
                if (isTimeAbsolute) {
                    temporal = TimeEncoding.DEFAULT.crs();
                    this.timeEncoding = TimeEncoding.ABSOLUTE;
                } else {
                    temporal = builder.createTemporalCRS(Date.from(startTime), timeUnit);
                    this.timeEncoding = new TimeEncoding(temporal.getDatum(), timeUnit);
                }
                components[count++] = temporal;
                name = (String)name + " + " + temporal.getName().getCode();
            }
            crs = ((GeodeticObjectBuilder)builder.addName((CharSequence)name)).createCompoundCRS(ArraysExt.resize(components, count));
            envelope = new GeneralEnvelope(crs);
        } else {
            dim = spatialDimensionCount;
            if (startTime != null) {
                ++dim;
            }
            envelope = new GeneralEnvelope(dim);
        }
        dim = lowerCorner.length;
        if (dim != spatialDimensionCount || (dim = upperCorner.length) != spatialDimensionCount) {
            throw new DataStoreReferencingException(this.errors().getString((short)81, "@stboundedby(BBOX)", spatialDimensionCount, dim));
        }
        for (int i = 0; i < spatialDimensionCount; ++i) {
            envelope.setRange(i, lowerCorner[i], upperCorner[i]);
        }
        if (startTime != null) {
            envelope.setRange(spatialDimensionCount, this.timeEncoding.toCRS(startTime.toEpochMilli()), endTime == null ? Double.NaN : this.timeEncoding.toCRS(endTime.toEpochMilli()));
        }
        this.spatialDimensionCount = (short)spatialDimensionCount;
        return envelope;
    }

    private DefaultFeatureType parseFeatureType(List<String> elements) throws DataStoreException {
        DefaultAttributeType[] characteristics = null;
        int size = elements.size();
        ArrayList<AbstractIdentifiedType> properties = new ArrayList<AbstractIdentifiedType>();
        for (int i = 1; i < size; ++i) {
            int maxOccurrence;
            int length;
            String tn;
            String name = elements.get(i);
            Class type = null;
            if (++i < size && ((tn = elements.get(i)).regionMatches(true, 0, TYPE_PREFIX, 0, length = TYPE_PREFIX.length()) || tn.regionMatches(true, 0, XS_PREFIX, 0, length = XS_PREFIX.length()))) {
                String st;
                switch (st = tn.substring(length).toLowerCase(Locale.US)) {
                    case "boolean": {
                        type = Boolean.class;
                        break;
                    }
                    case "decimal": {
                        type = Double.class;
                        break;
                    }
                    case "integer": {
                        type = Integer.class;
                        break;
                    }
                    case "string": {
                        type = String.class;
                        break;
                    }
                    case "datetime": {
                        type = Instant.class;
                        break;
                    }
                    case "anyuri": {
                        type = URI.class;
                        break;
                    }
                    default: {
                        throw new DataStoreContentException(this.errors().getString((short)149, tn));
                    }
                }
            }
            int minOccurrence = 0;
            int n = maxOccurrence = this.dissociate ? 1 : Integer.MAX_VALUE;
            if (type == null) {
                type = String.class;
                switch (--i) {
                    case 0: 
                    case 1: {
                        minOccurrence = 1;
                        maxOccurrence = 1;
                        break;
                    }
                    case 2: {
                        if (!name.equalsIgnoreCase("trajectory")) break;
                        this.hasTrajectories = true;
                        if (this.timeEncoding != null) {
                            properties.add(Store.createProperty("startTime", Instant.class, 1, 1, null));
                            properties.add(Store.createProperty("endTime", Instant.class, 1, 1, null));
                        }
                        if (this.dissociate) {
                            type = double[].class;
                        } else {
                            type = this.geometries.polylineClass;
                            characteristics = new DefaultAttributeType[]{MovingFeatureBuilder.TIME_AS_INSTANTS};
                        }
                        minOccurrence = 1;
                        maxOccurrence = 1;
                    }
                }
            }
            properties.add(Store.createProperty(name, type, minOccurrence, maxOccurrence, characteristics));
        }
        String name = IOUtilities.filenameWithoutExtension(super.getDisplayName());
        return new DefaultFeatureType(Collections.singletonMap("name", name), false, null, (AbstractIdentifiedType[])properties.toArray(AbstractIdentifiedType[]::new));
    }

    private static AbstractIdentifiedType createProperty(String name, Class<?> type, int minOccurrence, int maxOccurrence, DefaultAttributeType<?>[] characteristics) {
        return new DefaultAttributeType<Object>(Collections.singletonMap("name", name), type, minOccurrence, maxOccurrence, null, characteristics);
    }

    private Foliation parseFoliation(List<String> elements) {
        if (elements.size() >= 2) {
            return Foliation.valueOf(elements.get(1).toUpperCase(Locale.US));
        }
        return Foliation.TIME;
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.of(this.featureType.getName());
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            MetadataBuilder builder = new MetadataBuilder();
            String format = this.timeEncoding != null && this.hasTrajectories ? "CSV-MF" : "CSV";
            try {
                builder.setPredefinedFormat(format);
            }
            catch (MetadataStoreException e) {
                builder.addFormatName(format);
                this.listeners.warning(e);
            }
            builder.addLanguage(Locale.ENGLISH, this.encoding, MetadataBuilder.Scope.ALL);
            builder.addResourceScope(ScopeCode.FEATURE, null);
            try {
                builder.addExtent(this.envelope);
            }
            catch (TransformException e) {
                throw new DataStoreReferencingException(this.getLocale(), "CSV", this.getDisplayName(), (Object)this.source).initCause(e);
            }
            builder.addFeatureType(this.featureType, -1L);
            this.addTitleOrIdentifier(builder);
            builder.setISOStandards(false);
            this.metadata = builder.buildAndFreeze();
        }
        return this.metadata;
    }

    @Override
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return Optional.ofNullable(this.envelope);
    }

    @Override
    public DefaultFeatureType getType() {
        return this.featureType;
    }

    @Override
    public final synchronized Stream<AbstractFeature> features(boolean parallel) throws DataStoreException {
        if (this.dissociate) {
            return StreamSupport.stream(new FeatureIterator(this), parallel);
        }
        if (this.movingFeatures == null) {
            try {
                MovingFeatureIterator iter = new MovingFeatureIterator(this);
                iter.readMoving(null, true);
                this.movingFeatures = UnmodifiableArrayList.wrap(iter.createMovingFeatures());
            }
            catch (IOException | IllegalArgumentException | DateTimeException e) {
                throw new DataStoreException(this.canNotParseFile(), e);
            }
        }
        return this.movingFeatures.stream();
    }

    static void split(String line, List<? super String> elements) {
        int startAt = 0;
        boolean isQuoting = false;
        boolean hasQuotes = false;
        int length = line.length();
        block4: for (int i = 0; i < length; ++i) {
            switch (line.charAt(i)) {
                case '\"': {
                    hasQuotes = true;
                    if (isQuoting && i + 1 < length && line.charAt(i + 1) == '\"') {
                        ++i;
                        continue block4;
                    }
                    isQuoting = !isQuoting;
                    continue block4;
                }
                case ',': {
                    if (isQuoting) continue block4;
                    if (!elements.add(Store.decode(line, startAt, i, hasQuotes))) {
                        return;
                    }
                    startAt = i + 1;
                    hasQuotes = false;
                }
            }
        }
        elements.add(Store.decode(line, startAt, length, hasQuotes));
    }

    private static String decode(CharSequence text, int lower, int upper, boolean hasQuotes) {
        if (hasQuotes) {
            StringBuilder buffer = new StringBuilder(upper - lower).append(text, lower, upper);
            for (int i = 0; i < buffer.length(); ++i) {
                if (buffer.charAt(i) != '\"') continue;
                buffer.deleteCharAt(i);
            }
            text = CharSequences.trimWhitespaces(buffer);
        } else {
            text = CharSequences.trimWhitespaces(text, lower, upper);
        }
        return text.toString();
    }

    final boolean hasTrajectories() {
        return this.hasTrajectories;
    }

    final int spatialDimensionCount() {
        return this.spatialDimensionCount;
    }

    final TimeEncoding timeEncoding() {
        return this.timeEncoding;
    }

    final String readLine() throws IOException {
        return this.source.readLine();
    }

    private String duplicated(String name) {
        return this.errors().getString((short)24, name);
    }

    final String canNotParseFile() {
        return IOUtilities.canNotReadFile(this.getLocale(), "CSV", this.getDisplayName(), this.source);
    }

    private Errors errors() {
        return Errors.getResources(this.getLocale());
    }

    final void log(LogRecord warning) {
        warning.setSourceClassName(Store.class.getName());
        warning.setSourceMethodName("features");
        this.listeners.warning(warning);
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.listeners.close();
        BufferedReader s = this.source;
        this.source = null;
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException e) {
                throw new DataStoreException(e);
            }
        }
    }
}

