/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

class ConcatenatedTransformDirect
extends ConcatenatedTransform {
    private static final long serialVersionUID = -3568975979013908920L;

    ConcatenatedTransformDirect(MathTransform transform1, MathTransform transform2) {
        super(transform1, transform2);
    }

    @Override
    boolean isValid() {
        return super.isValid() && this.transform1.getSourceDimensions() == this.transform1.getTargetDimensions() && this.transform2.getSourceDimensions() == this.transform2.getTargetDimensions();
    }

    @Override
    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        assert (this.isValid());
        ptDst = this.transform1.transform(ptSrc, ptDst);
        return this.transform2.transform(ptDst, ptDst);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        assert (this.isValid());
        this.transform1.transform(srcPts, srcOff, dstPts, dstOff, numPts);
        this.transform2.transform(dstPts, dstOff, dstPts, dstOff, numPts);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        assert (this.isValid());
        this.transform1.transform(srcPts, srcOff, dstPts, dstOff, numPts);
        this.transform2.transform(dstPts, dstOff, dstPts, dstOff, numPts);
    }
}

