/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.func;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.func.ArrayFlow;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Interleaver;
import org.apache.tapestry5.func.LazyConcat;
import org.apache.tapestry5.func.LazyDrop;
import org.apache.tapestry5.func.LazyFilter;
import org.apache.tapestry5.func.LazyMapper;
import org.apache.tapestry5.func.LazyMapper2;
import org.apache.tapestry5.func.LazyTake;
import org.apache.tapestry5.func.LazyZip;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Mapper2;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.func.Reducer;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.func.ZippedFlow;
import org.apache.tapestry5.func.ZippedFlowImpl;

abstract class AbstractFlow<T>
implements Flow<T> {
    AbstractFlow() {
    }

    protected List<T> toMutableList() {
        return AbstractFlow.toMutableList(this);
    }

    protected static <T> List<T> toMutableList(Flow<T> flow) {
        ArrayList result = new ArrayList();
        for (Object value : flow) {
            result.add(value);
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Flow<T> current;
            {
                this.current = AbstractFlow.this;
            }

            @Override
            public boolean hasNext() {
                return !this.current.isEmpty();
            }

            @Override
            public T next() {
                Object next = this.current.first();
                this.current = (Flow)this.current.rest();
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Flows are immutable.");
            }
        };
    }

    @Override
    public Flow<T> concat(Collection<? extends T> collection) {
        return this.concat(F.flow(collection));
    }

    @Override
    public <V extends T> Flow<T> append(V ... values) {
        return this.concat(F.flow(values));
    }

    @Override
    public Flow<T> concat(Flow<? extends T> other) {
        return F.lazy(new LazyConcat<T>(this, other));
    }

    @Override
    public Flow<T> each(Worker<? super T> worker) {
        assert (worker != null);
        for (T value : this) {
            worker.work(value);
        }
        return this;
    }

    @Override
    public Flow<T> filter(Predicate<? super T> predicate) {
        assert (predicate != null);
        return F.lazy(new LazyFilter<T>(predicate, this));
    }

    @Override
    public <X> Flow<X> map(Mapper<T, X> mapper) {
        assert (mapper != null);
        return F.lazy(new LazyMapper<T, X>(mapper, this));
    }

    @Override
    public <X, Y> Flow<Y> map(Mapper2<T, X, Y> mapper, Flow<? extends X> flow) {
        assert (mapper != null);
        assert (flow != null);
        if (this.isEmpty() || flow.isEmpty()) {
            return F.emptyFlow();
        }
        return F.lazy(new LazyMapper2<T, X, Y>(mapper, this, flow));
    }

    @Override
    public <A> A reduce(Reducer<A, T> reducer, A initial) {
        assert (reducer != null);
        A accumulator = initial;
        Flow<T> cursor = this;
        while (!cursor.isEmpty()) {
            accumulator = reducer.reduce(accumulator, cursor.first());
            cursor = (Flow)cursor.rest();
        }
        return accumulator;
    }

    @Override
    public <X> Flow<X> mapcat(Mapper<T, Flow<X>> mapper) {
        Flow<Flow<X>> flows = this.map(mapper);
        if (flows.isEmpty()) {
            return F.emptyFlow();
        }
        return (Flow)((Flow)flows.rest()).reduce(new Reducer<Flow<X>, Flow<X>>(){

            @Override
            public Flow<X> reduce(Flow<X> accumulator, Flow<X> value) {
                return accumulator.concat(value);
            }
        }, flows.first());
    }

    @Override
    public Flow<T> remove(Predicate<? super T> predicate) {
        assert (predicate != null);
        return this.filter((Predicate)F.not(predicate));
    }

    @Override
    public Flow<T> reverse() {
        if (this.isEmpty()) {
            return F.emptyFlow();
        }
        return new ArrayFlow(this).reverse();
    }

    @Override
    public Flow<T> sort() {
        if (this.isEmpty()) {
            return F.emptyFlow();
        }
        return new ArrayFlow(this).sort();
    }

    @Override
    public Flow<T> sort(Comparator<T> comparator) {
        if (this.isEmpty()) {
            return F.emptyFlow();
        }
        return new ArrayFlow(this).sort((Comparator)comparator);
    }

    @Override
    public List<T> toList() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.toMutableList());
    }

    @Override
    public T[] toArray(Class<T> type) {
        assert (type != null);
        List<Object> list = this.toMutableList();
        Object array = Array.newInstance(type, list.size());
        return list.toArray((Object[])array);
    }

    @Override
    public int count() {
        if (this.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (Flow<T> flow = this; flow != null && !flow.isEmpty(); flow = (Flow)flow.rest()) {
            ++count;
        }
        return count;
    }

    @Override
    public Flow<T> take(int length) {
        return F.lazy(new LazyTake(length, this));
    }

    @Override
    public Flow<T> drop(int length) {
        assert (length >= 0);
        if (length == 0) {
            return this;
        }
        return F.lazy(new LazyDrop(length, this));
    }

    @Override
    public Set<T> toSet() {
        HashSet set = new HashSet();
        this.each(F.addToCollection(set));
        return Collections.unmodifiableSet(set);
    }

    @Override
    public <X> ZippedFlow<T, X> zipWith(Flow<X> otherFlow) {
        assert (otherFlow != null);
        Flow tupleFlow = F.lazy(new LazyZip(this, otherFlow));
        return ZippedFlowImpl.create(tupleFlow);
    }

    @Override
    public Flow<T> removeNulls() {
        return this.remove(F.isNull());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public T first() {
        return null;
    }

    @Override
    public Flow<T> rest() {
        return null;
    }

    @Override
    public Flow<T> interleave(Flow<T> ... otherFlows) {
        ArrayList allFlows = new ArrayList(otherFlows.length + 1);
        allFlows.add(this);
        for (Flow<T> otherFlow : otherFlows) {
            allFlows.add(otherFlow);
        }
        return F.lazy(new Interleaver(allFlows));
    }
}

