/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.validator;

import org.apache.tapestry5.Field;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ioc.MessageFormatter;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Html5Support;
import org.apache.tapestry5.services.javascript.DataConstants;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.validator.AbstractValidator;

public final class Required
extends AbstractValidator<Void, Object> {
    private final Html5Support html5Support;

    public Required(JavaScriptSupport javaScriptSupport, Html5Support html5Support) {
        super(null, Object.class, "required", javaScriptSupport);
        this.html5Support = html5Support;
    }

    @Override
    public void validate(Field field, Void constraintValue, MessageFormatter formatter, Object value) throws ValidationException {
        if (value == null || InternalUtils.isEmptyCollection((Object)value) || InternalUtils.isBlank((String)value.toString())) {
            throw new ValidationException(this.buildMessage(formatter, field));
        }
    }

    private String buildMessage(MessageFormatter formatter, Field field) {
        return formatter.format(new Object[]{field.getLabel()});
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public void render(Field field, Void constraintValue, MessageFormatter formatter, MarkupWriter writer, FormSupport formSupport) {
        writer.attributes("aria-required", "true");
        if (formSupport.isClientValidationEnabled()) {
            this.javaScriptSupport.require("t5/core/validation");
            writer.attributes(DataConstants.VALIDATION_ATTRIBUTE, true, "data-optionality", "required", "data-required-message", this.buildMessage(formatter, field), "aria-required", "true");
        }
        if (this.html5Support.isHtml5SupportEnabled()) {
            writer.attributes("required", "required");
        }
    }
}

