/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContextFactory;

public class ExecutionContextMap {
    private ExecutionContext _main = ExecutionContextMap.createExecutionContext();
    private final Map<Long, ExecutionContext> _parEc = new ConcurrentHashMap<Long, ExecutionContext>();

    public synchronized ExecutionContext get(long tid) {
        if (tid <= 0L) {
            return this._main;
        }
        return this._parEc.computeIfAbsent(tid, k -> ExecutionContextMap.deriveExecutionContext(this._main));
    }

    public synchronized void clear() {
        for (String varName : new ArrayList<String>(this._main.getVariables().keySet())) {
            this._main.cleanupDataObject(this._main.removeVariable(varName));
        }
        for (ExecutionContext ec : this._parEc.values()) {
            for (String varName : ec.getVariables().keySet()) {
                this._main.cleanupDataObject(ec.removeVariable(varName));
            }
        }
        this._parEc.clear();
    }

    public synchronized void convertToSparkCtx() {
        DMLScript.setGlobalExecMode(Types.ExecMode.HYBRID);
        this._main = ExecutionContextMap.deriveExecutionContext(this._main);
        this._parEc.replaceAll((k, v) -> ExecutionContextMap.deriveExecutionContext(v));
    }

    private static ExecutionContext createExecutionContext() {
        ExecutionContext ec = ExecutionContextFactory.createContext();
        ec.setAutoCreateVars(true);
        return ec;
    }

    private static ExecutionContext deriveExecutionContext(ExecutionContext ec) {
        ExecutionContext ec2 = ExecutionContextFactory.createContext(ec.getVariables(), ec.getProgram());
        ec2.setAutoCreateVars(true);
        return ec2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\nMain EC: ");
        sb.append(this._main.toString());
        sb.append("ParFor ECs: ");
        sb.append(this._parEc.toString());
        return sb.toString();
    }
}

