/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.datatransfer.TrustedChannelResolver;
import org.apache.hadoop.util.CombinedIPList;

public class BlackListBasedTrustedChannelResolver
extends TrustedChannelResolver {
    private CombinedIPList blackListForServer;
    private CombinedIPList blackListForClient;
    private static final String FIXED_BLACK_LIST_DEFAULT_LOCATION = "/etc/hadoop/fixedBlackList";
    private static final String VARIABLE_BLACK_LIST_DEFAULT_LOCATION = "/etc/hadoop/blackList";
    public static final String DFS_DATATRANSFER_SERVER_FIXED_BLACK_LIST_FILE = "dfs.datatransfer.server.fixedBlackList.file";
    public static final String DFS_DATATRANSFER_SERVER_VARIABLE_BLACK_LIST_ENABLE = "dfs.datatransfer.server.variableBlackList.enable";
    public static final String DFS_DATATRANSFER_SERVER_VARIABLE_BLACK_LIST_FILE = "dfs.datatransfer.server.variableBlackList.file";
    public static final String DFS_DATATRANSFER_SERVER_VARIABLE_BLACK_LIST_CACHE_SECS = "dfs.datatransfer.server.variableBlackList.cache.secs";
    public static final String DFS_DATATRANSFER_CLIENT_FIXED_BLACK_LIST_FILE = "dfs.datatransfer.client.fixedBlackList.file";
    public static final String DFS_DATATRANSFER_CLIENT_VARIABLE_BLACK_LIST_ENABLE = "dfs.datatransfer.client.variableBlackList.enable";
    public static final String DFS_DATATRANSFER_CLIENT_VARIABLE_BLACK_LIST_FILE = "dfs.datatransfer.client.variableBlackList.file";
    public static final String DFS_DATATRANSFER_CLIENT_VARIABLE_BLACK_LIST_CACHE_SECS = "dfs.datatransfer.client.variableBlackList.cache.secs";

    public void setConf(Configuration conf) {
        super.setConf(conf);
        String fixedFile = conf.get(DFS_DATATRANSFER_SERVER_FIXED_BLACK_LIST_FILE, FIXED_BLACK_LIST_DEFAULT_LOCATION);
        String variableFile = null;
        long expiryTime = 0L;
        if (conf.getBoolean(DFS_DATATRANSFER_SERVER_VARIABLE_BLACK_LIST_ENABLE, false)) {
            variableFile = conf.get(DFS_DATATRANSFER_SERVER_VARIABLE_BLACK_LIST_FILE, VARIABLE_BLACK_LIST_DEFAULT_LOCATION);
            expiryTime = conf.getLong(DFS_DATATRANSFER_SERVER_VARIABLE_BLACK_LIST_CACHE_SECS, 3600L) * 1000L;
        }
        this.blackListForServer = new CombinedIPList(fixedFile, variableFile, expiryTime);
        fixedFile = conf.get(DFS_DATATRANSFER_CLIENT_FIXED_BLACK_LIST_FILE, fixedFile);
        expiryTime = 0L;
        if (conf.getBoolean(DFS_DATATRANSFER_CLIENT_VARIABLE_BLACK_LIST_ENABLE, false)) {
            variableFile = conf.get(DFS_DATATRANSFER_CLIENT_VARIABLE_BLACK_LIST_FILE, variableFile);
            expiryTime = conf.getLong(DFS_DATATRANSFER_CLIENT_VARIABLE_BLACK_LIST_CACHE_SECS, 3600L) * 1000L;
        }
        this.blackListForClient = new CombinedIPList(fixedFile, variableFile, expiryTime);
    }

    public boolean isTrusted() {
        try {
            return !this.blackListForClient.isIn(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            return true;
        }
    }

    public boolean isTrusted(InetAddress clientAddress) {
        return !this.blackListForServer.isIn(clientAddress.getHostAddress());
    }
}

