/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.UtilFunctions;

public abstract class FrameReader {
    protected static final Log LOG = LogFactory.getLog((String)FrameReader.class.getName());

    public abstract FrameBlock readFrameFromHDFS(String var1, Types.ValueType[] var2, String[] var3, long var4, long var6) throws IOException, DMLRuntimeException;

    public FrameBlock readFrameFromHDFS(String fname, Types.ValueType[] schema, long rlen, long clen) throws IOException, DMLRuntimeException {
        LOG.debug((Object)"readFrameFromHDFS with schema");
        return this.readFrameFromHDFS(fname, schema, this.getDefColNames(schema.length), rlen, clen);
    }

    public FrameBlock readFrameFromHDFS(String fname, long rlen, long clen) throws IOException, DMLRuntimeException {
        LOG.debug((Object)"readFrameFromHDFS no schema");
        return this.readFrameFromHDFS(fname, this.getDefSchema(clen), this.getDefColNames(clen), rlen, clen);
    }

    public abstract FrameBlock readFrameFromInputStream(InputStream var1, Types.ValueType[] var2, String[] var3, long var4, long var6) throws IOException, DMLRuntimeException;

    public FrameBlock readFrameFromInputStream(InputStream is, Types.ValueType[] schema, long rlen, long clen) throws IOException, DMLRuntimeException {
        LOG.debug((Object)"readFrame from Input Stream with schema");
        return this.readFrameFromInputStream(is, schema, this.getDefColNames(schema.length), rlen, clen);
    }

    public FrameBlock readFrameFromInputStream(InputStream is, long rlen, long clen) throws IOException, DMLRuntimeException {
        LOG.debug((Object)"readFrame from Input Stream no schema");
        return this.readFrameFromInputStream(is, this.getDefSchema(clen), this.getDefColNames(clen), rlen, clen);
    }

    public Types.ValueType[] getDefSchema(long clen) throws DMLRuntimeException {
        int lclen = Math.max((int)clen, 1);
        return UtilFunctions.nCopies(lclen, Types.ValueType.STRING);
    }

    public String[] getDefColNames(long clen) throws DMLRuntimeException {
        return clen < 0L ? new String[]{} : FrameBlock.createColNames((int)clen);
    }

    protected static FrameBlock createOutputFrameBlock(Types.ValueType[] schema, String[] names, long nrow) throws IOException {
        if (!OptimizerUtils.isValidCPDimensions(schema, names)) {
            throw new DMLRuntimeException("Schema and names to be define with equal size.:" + schema.length + " vs " + names.length);
        }
        FrameBlock ret = new FrameBlock(schema, names);
        ret.ensureAllocatedColumns((int)nrow);
        return ret;
    }

    protected static Types.ValueType[] createOutputSchema(Types.ValueType[] schema, long ncol) {
        if (schema.length == 1 && ncol > 1L) {
            return UtilFunctions.nCopies((int)ncol, schema[0]);
        }
        return schema;
    }

    protected static String[] createOutputNames(String[] names, long ncol) {
        if ((long)names.length != ncol) {
            return FrameBlock.createColNames((int)ncol);
        }
        return names;
    }

    protected static void checkValidInputFile(FileSystem fs, Path path) throws IOException {
        if (!fs.exists(path)) {
            throw new IOException("File " + path.toString() + " does not exist on HDFS/LFS.");
        }
        if (HDFSTool.isFileEmpty(fs, path)) {
            throw new EOFException("Empty input file " + path.toString() + ".");
        }
    }
}

