/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.models;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.BaseModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.DataObjectModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.EventModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.HeavyHitterModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.RequestModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.TrafficModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.UtilizationModel;

public class StatisticsModel
extends BaseModel {
    private static final long serialVersionUID = -2492467768854934429L;
    public List<UtilizationModel> utilization;
    public List<TrafficModel> traffic;
    public List<EventModel> events;
    public List<DataObjectModel> dataObjects;
    public List<RequestModel> requests;
    public List<HeavyHitterModel> heavyHitters;
    private static final String JsonFormat = "{\"utilization\": [%s],\"traffic\": [%s],\"events\": [%s],\"dataObjects\": [%s],\"requests\": [%s],\"heavyHitters\": [%s]}";

    public StatisticsModel() {
    }

    public StatisticsModel(List<UtilizationModel> utilization, List<TrafficModel> traffic, List<EventModel> events, List<DataObjectModel> dataObjects, List<RequestModel> requests, List<HeavyHitterModel> heavyHitters) {
        this.utilization = utilization;
        this.traffic = traffic;
        this.events = events;
        this.dataObjects = dataObjects;
        this.requests = requests;
        this.heavyHitters = heavyHitters;
    }

    public String toString() {
        String utilizationStr = null;
        String trafficStr = null;
        String eventsStr = null;
        String dataObjectsStr = null;
        String requestsStr = null;
        String heavyHittersStr = null;
        if (this.utilization != null) {
            utilizationStr = this.utilization.stream().map(UtilizationModel::toString).collect(Collectors.joining(","));
        }
        if (this.traffic != null) {
            trafficStr = this.traffic.stream().map(TrafficModel::toString).collect(Collectors.joining(","));
        }
        if (this.events != null) {
            eventsStr = this.events.stream().map(EventModel::toString).collect(Collectors.joining(","));
        }
        if (this.dataObjects != null) {
            dataObjectsStr = this.dataObjects.stream().map(DataObjectModel::toString).collect(Collectors.joining(","));
        }
        if (this.requests != null) {
            requestsStr = this.requests.stream().map(RequestModel::toString).collect(Collectors.joining(","));
        }
        if (this.heavyHitters != null) {
            heavyHittersStr = this.heavyHitters.stream().map(HeavyHitterModel::toString).collect(Collectors.joining(","));
        }
        return String.format(JsonFormat, utilizationStr, trafficStr, eventsStr, dataObjectsStr, requestsStr, heavyHittersStr);
    }
}

