/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;

public class MapToZero
extends AMapToData {
    private static final long serialVersionUID = -8065234231282619923L;
    private final int _size;

    public MapToZero(int size) {
        super(1);
        this._size = size;
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.ZERO;
    }

    @Override
    public int getIndex(int n) {
        return 0;
    }

    @Override
    public void fill(int v) {
    }

    @Override
    public long getInMemorySize() {
        return MapToZero.getInMemorySize(0);
    }

    public static long getInMemorySize(int dataLength) {
        return 20L;
    }

    @Override
    public long getExactSizeOnDisk() {
        return 5L;
    }

    @Override
    public void set(int n, int v) {
    }

    @Override
    public int setAndGet(int n, int v) {
        return 0;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void replace(int v, int r) {
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.ZERO.ordinal());
        out.writeInt(this._size);
    }

    protected static MapToZero readFields(DataInput in) throws IOException {
        return new MapToZero(in.readInt());
    }

    @Override
    public int getUpperBoundValue() {
        return 0;
    }

    @Override
    public int[] getCounts(int[] ret) {
        int sz;
        ret[0] = sz = this.size();
        return ret;
    }

    @Override
    public void preAggregateDDC_DDCSingleCol(AMapToData tm, double[] td, double[] v) {
        int sz = this.size();
        for (int r = 0; r < sz; ++r) {
            v[0] = v[0] + td[tm.getIndex(r)];
        }
    }

    @Override
    public void preAggregateDDC_DDCMultiCol(AMapToData tm, ADictionary td, double[] v, int nCol) {
        int sz = this.size();
        for (int r = 0; r < sz; ++r) {
            td.addToEntry(v, tm.getIndex(r), 0, nCol);
        }
    }

    @Override
    public void copyInt(int[] d) {
    }

    @Override
    public void copyBit(BitSet d) {
    }

    @Override
    public AMapToData resize(int unique) {
        return this;
    }

    @Override
    public int countRuns() {
        return 1;
    }

    @Override
    public AMapToData slice(int l, int u) {
        return new MapToZero(u - l);
    }

    @Override
    public AMapToData append(AMapToData t) {
        if (t instanceof MapToZero) {
            return new MapToZero(this._size + t.size());
        }
        throw new NotImplementedException("Not implemented append on Bit map different type");
    }

    @Override
    public AMapToData appendN(AMapToDataGroup[] d) {
        int p = 0;
        for (AMapToDataGroup gd : d) {
            p += gd.getMapToData().size();
        }
        return new MapToZero(p);
    }
}

