/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.AppendCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.operators.Operator;

public final class ListAppendRemoveCPInstruction
extends AppendCPInstruction {
    private CPOperand output2 = null;

    protected ListAppendRemoveCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, AppendCPInstruction.AppendType type, String opcode, String istr) {
        super(op, in1, in2, out, type, opcode, istr);
        if (opcode.equals("remove")) {
            this.output2 = new CPOperand(InstructionUtils.getInstructionPartsWithValueType(istr)[4]);
        }
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        ListObject lo = ec.getListObject(this.input1);
        if (this.getOpcode().equals("append")) {
            Data dat2 = ec.getVariable(this.input2);
            LineageItem li = DMLScript.LINEAGE ? ec.getLineage().get(this.input2) : null;
            ListObject tmp = null;
            if (dat2 instanceof ListObject && ((ListObject)dat2).getLength() == 1) {
                ListObject lo2 = (ListObject)dat2;
                tmp = lo.copy().add(lo2.getName(0), lo2.getData(0), li);
            } else {
                tmp = lo.copy().add(dat2, li);
            }
            ec.setVariable(this.output.getName(), tmp);
        } else if (this.getOpcode().equals("remove")) {
            ScalarObject dat2 = ec.getScalarInput(this.input2);
            ListObject tmp1 = lo.copy();
            ListObject tmp2 = tmp1.remove((int)dat2.getLongValue() - 1);
            ec.setVariable(this.output.getName(), tmp1);
            ec.setVariable(this.output2.getName(), tmp2);
        } else {
            throw new DMLRuntimeException("Unsupported list operation: " + this.getOpcode());
        }
    }

    public CPOperand getOutput2() {
        return this.output2;
    }
}

