/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.parser.BooleanIdentifier;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.DoubleIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.parser.WhileStatementBlock;

public class IfStatementBlock
extends StatementBlock {
    private Hop _predicateHops;
    private Lop _predicateLops = null;
    private boolean _requiresPredicateRecompile = false;

    @Override
    public VariableSet validate(DMLProgram dmlProg, VariableSet ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) {
        DataIdentifier elseVersion;
        DataIdentifier ifVersion;
        if (this._statements.size() > 1) {
            this.raiseValidateError("IfStatementBlock should only have 1 statement (IfStatement)", conditional);
        }
        IfStatement ifstmt = (IfStatement)this._statements.get(0);
        Expression pred = ifstmt.getConditionalPredicate().getPredicate();
        pred.validateExpression(ids.getVariables(), constVars, conditional);
        if (pred instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)pred).getName()) && !conditional) {
            ifstmt.getConditionalPredicate().setPredicate(constVars.get(((DataIdentifier)pred).getName()));
        }
        HashMap<String, ConstIdentifier> constVarsIfCopy = new HashMap<String, ConstIdentifier>(constVars);
        HashMap<String, ConstIdentifier> constVarsElseCopy = new HashMap<String, ConstIdentifier>(constVars);
        VariableSet idsIfCopy = new VariableSet(ids);
        VariableSet idsElseCopy = new VariableSet(ids);
        VariableSet idsOrigCopy = new VariableSet(ids);
        this._dmlProg = dmlProg;
        ArrayList<StatementBlock> ifBody = ifstmt.getIfBody();
        for (StatementBlock statementBlock : ifBody) {
            idsIfCopy = statementBlock.validate(dmlProg, idsIfCopy, constVarsIfCopy, true);
            constVarsIfCopy = statementBlock.getConstOut();
        }
        ArrayList<StatementBlock> elseBody = ifstmt.getElseBody();
        for (StatementBlock statementBlock : elseBody) {
            idsElseCopy = statementBlock.validate(dmlProg, idsElseCopy, constVarsElseCopy, true);
            constVarsElseCopy = statementBlock.getConstOut();
        }
        for (String string : this._updated.getVariableNames()) {
            DataIdentifier dataIdentifier = idsOrigCopy.getVariable(string);
            ifVersion = idsIfCopy.getVariable(string);
            elseVersion = idsElseCopy.getVariable(string);
            if (ifVersion != null && elseVersion != null) {
                if (!ifVersion.getOutput().getDataType().equals((Object)elseVersion.getOutput().getDataType())) {
                    this.raiseValidateError("IfStatementBlock has unsupported conditional data type change of variable '" + string + "' in if/else branch.", conditional);
                }
            } else if (dataIdentifier != null && !ifVersion.getOutput().getDataType().equals((Object)dataIdentifier.getOutput().getDataType())) {
                this.raiseValidateError("IfStatementBlock has unsupported conditional data type change of variable '" + string + "' in if branch.", conditional);
            }
            if (ifVersion == null || elseVersion == null || ifVersion.getOutput().getValueType().equals((Object)elseVersion.getOutput().getValueType())) continue;
            LOG.warn((Object)(elseVersion.printWarningLocation() + "Variable " + elseVersion.getName() + " defined with different value type in if and else clause."));
        }
        HashMap<String, ConstIdentifier> hashMap = new HashMap<String, ConstIdentifier>();
        for (Map.Entry<String, ConstIdentifier> entry : constVarsIfCopy.entrySet()) {
            String varName2 = entry.getKey();
            if (this._updated.containsVariable(varName2)) continue;
            hashMap.put(varName2, entry.getValue());
        }
        for (Map.Entry<String, ConstIdentifier> entry : constVarsElseCopy.entrySet()) {
            String varName = entry.getKey();
            if (this._updated.containsVariable(varName)) continue;
            hashMap.put(varName, entry.getValue());
        }
        for (String string : this._updated.getVariableNames()) {
            ifVersion = idsIfCopy.getVariable(string);
            elseVersion = idsElseCopy.getVariable(string);
            if (ifVersion == null || elseVersion == null || !ifVersion.getOutput().getDataType().equals((Object)Expression.DataType.SCALAR) || !elseVersion.getOutput().getDataType().equals((Object)Expression.DataType.SCALAR) || !ifVersion.getOutput().getValueType().equals((Object)elseVersion.getOutput().getValueType())) continue;
            ConstIdentifier ifConstVersion = constVarsIfCopy.get(string);
            ConstIdentifier elseConstVersion = constVarsElseCopy.get(string);
            if (ifConstVersion != null && elseConstVersion != null && ifConstVersion instanceof IntIdentifier && elseConstVersion instanceof IntIdentifier) {
                if (((IntIdentifier)ifConstVersion).getValue() != ((IntIdentifier)elseConstVersion).getValue()) continue;
                hashMap.put(string, ifConstVersion);
                continue;
            }
            if (ifConstVersion != null && elseConstVersion != null && ifConstVersion instanceof DoubleIdentifier && elseConstVersion instanceof DoubleIdentifier) {
                if (((DoubleIdentifier)ifConstVersion).getValue() != ((DoubleIdentifier)elseConstVersion).getValue()) continue;
                hashMap.put(string, ifConstVersion);
                continue;
            }
            if (ifConstVersion != null && elseConstVersion != null && ifConstVersion instanceof BooleanIdentifier && elseConstVersion instanceof BooleanIdentifier) {
                if (((BooleanIdentifier)ifConstVersion).getValue() != ((BooleanIdentifier)elseConstVersion).getValue()) continue;
                hashMap.put(string, ifConstVersion);
                continue;
            }
            if (ifConstVersion == null || elseConstVersion == null || !(ifConstVersion instanceof StringIdentifier) || !(elseConstVersion instanceof StringIdentifier) || !((StringIdentifier)ifConstVersion).getValue().equals(((StringIdentifier)elseConstVersion).getValue())) continue;
            hashMap.put(string, ifConstVersion);
        }
        VariableSet variableSet = new VariableSet();
        for (String varName : idsIfCopy.getVariableNames()) {
            if (this._updated.containsVariable(varName)) continue;
            variableSet.addVariable(varName, idsIfCopy.getVariable(varName));
        }
        for (String varName : idsElseCopy.getVariableNames()) {
            if (this._updated.containsVariable(varName)) continue;
            variableSet.addVariable(varName, idsElseCopy.getVariable(varName));
        }
        for (String updatedVar : this._updated.getVariableNames()) {
            DataIdentifier ifVersion2 = idsIfCopy.getVariable(updatedVar);
            DataIdentifier elseVersion2 = idsElseCopy.getVariable(updatedVar);
            DataIdentifier origVersion = idsOrigCopy.getVariable(updatedVar);
            if (ifVersion2 != null && elseVersion2 != null) {
                long elseVersionDim2;
                long updatedDim1 = -1L;
                long updatedDim2 = -1L;
                long updatedNnz = -1L;
                long ifVersionDim1 = ifVersion2 instanceof IndexedIdentifier ? ((IndexedIdentifier)ifVersion2).getOrigDim1() : ifVersion2.getDim1();
                long elseVersionDim1 = elseVersion2 instanceof IndexedIdentifier ? ((IndexedIdentifier)elseVersion2).getOrigDim1() : elseVersion2.getDim1();
                long ifVersionDim2 = ifVersion2 instanceof IndexedIdentifier ? ((IndexedIdentifier)ifVersion2).getOrigDim2() : ifVersion2.getDim2();
                long l = elseVersionDim2 = elseVersion2 instanceof IndexedIdentifier ? ((IndexedIdentifier)elseVersion2).getOrigDim2() : elseVersion2.getDim2();
                if (ifVersionDim1 == elseVersionDim1) {
                    updatedDim1 = ifVersionDim1;
                }
                if (ifVersionDim2 == elseVersionDim2) {
                    updatedDim2 = ifVersionDim2;
                }
                DataIdentifier recVersion = new DataIdentifier(ifVersion2);
                recVersion.setDimensions(updatedDim1, updatedDim2);
                recVersion.setNnz(updatedNnz);
                variableSet.addVariable(updatedVar, recVersion);
                continue;
            }
            DataIdentifier recVersion = null;
            if (ifVersion2 != null) {
                recVersion = new DataIdentifier(ifVersion2);
                variableSet.addVariable(updatedVar, recVersion);
            } else if (elseVersion2 != null) {
                recVersion = new DataIdentifier(elseVersion2);
                variableSet.addVariable(updatedVar, recVersion);
            } else {
                recVersion = new DataIdentifier(this._updated.getVariable(updatedVar));
                variableSet.addVariable(updatedVar, recVersion);
            }
            long updatedDim1 = -1L;
            long updatedDim2 = -1L;
            long updatedNnz = -1L;
            if (origVersion != null) {
                long origVersionDim1 = origVersion instanceof IndexedIdentifier ? ((IndexedIdentifier)origVersion).getOrigDim1() : origVersion.getDim1();
                long recVersionDim1 = recVersion.getDim1();
                long origVersionDim2 = origVersion instanceof IndexedIdentifier ? ((IndexedIdentifier)origVersion).getOrigDim2() : origVersion.getDim2();
                long recVersionDim2 = recVersion.getDim2();
                if (origVersionDim1 == recVersionDim1) {
                    updatedDim1 = origVersionDim1;
                }
                if (origVersionDim2 == recVersionDim2) {
                    updatedDim2 = origVersionDim2;
                }
            }
            recVersion.setDimensions(updatedDim1, updatedDim2);
            recVersion.setNnz(updatedNnz);
        }
        VariableSet variableSet2 = new VariableSet(variableSet);
        this._constVarsIn.putAll(constVars);
        this._constVarsOut.putAll(hashMap);
        return variableSet2;
    }

    @Override
    public VariableSet initializeforwardLV(VariableSet activeInPassed) {
        IfStatement ifstmt = (IfStatement)this._statements.get(0);
        if (this._statements.size() > 1) {
            throw new LanguageException(ifstmt.printErrorLocation() + "IfStatementBlock should have only 1 statement (if statement)");
        }
        this._read = new VariableSet();
        this._gen = new VariableSet();
        this._kill = new VariableSet();
        this._warnSet = new VariableSet();
        this._read.addVariables(ifstmt.getConditionalPredicate().variablesRead());
        this._updated.addVariables(ifstmt.getConditionalPredicate().variablesUpdated());
        this._gen.addVariables(ifstmt.getConditionalPredicate().variablesRead());
        VariableSet ifCurrent = new VariableSet(activeInPassed);
        VariableSet genIfBody = new VariableSet();
        VariableSet killIfBody = new VariableSet();
        VariableSet updatedIfBody = new VariableSet();
        VariableSet readIfBody = new VariableSet();
        for (StatementBlock sb : ifstmt.getIfBody()) {
            ifCurrent = sb.initializeforwardLV(ifCurrent);
            for (String varName : sb._gen.getVariableNames()) {
                if (killIfBody.getVariableNames().contains(varName)) continue;
                genIfBody.addVariable(varName, sb._gen.getVariable(varName));
            }
            readIfBody.addVariables(sb._read);
            updatedIfBody.addVariables(sb._updated);
            if (sb instanceof WhileStatementBlock || sb instanceof ForStatementBlock) continue;
            killIfBody.addVariables(sb._kill);
        }
        VariableSet elseCurrent = new VariableSet(activeInPassed);
        VariableSet genElseBody = new VariableSet();
        VariableSet killElseBody = new VariableSet();
        VariableSet updatedElseBody = new VariableSet();
        VariableSet readElseBody = new VariableSet();
        for (StatementBlock sb : ifstmt.getElseBody()) {
            elseCurrent = sb.initializeforwardLV(elseCurrent);
            for (String varName : sb._gen.getVariableNames()) {
                if (killElseBody.getVariableNames().contains(varName)) continue;
                genElseBody.addVariable(varName, sb._gen.getVariable(varName));
            }
            readElseBody.addVariables(sb._read);
            updatedElseBody.addVariables(sb._updated);
            if (sb instanceof WhileStatementBlock || sb instanceof ForStatementBlock) continue;
            killElseBody.addVariables(sb._kill);
        }
        this._read.addVariables(readIfBody);
        this._read.addVariables(readElseBody);
        this._updated.addVariables(updatedIfBody);
        this._updated.addVariables(updatedElseBody);
        this._gen.addVariables(genIfBody);
        this._gen.addVariables(genElseBody);
        for (String varName : killIfBody.getVariableNames()) {
            if (!killElseBody.containsVariable(varName)) continue;
            this._kill.addVariable(varName, killIfBody.getVariable(varName));
        }
        for (String varName : this._updated.getVariableNames()) {
            if (updatedIfBody.containsVariable(varName) && updatedElseBody.containsVariable(varName) || activeInPassed.containsVariable(varName)) continue;
            this._warnSet.addVariable(varName, this._updated.getVariable(varName));
        }
        this._liveOut = new VariableSet();
        this._liveOut.addVariables(ifCurrent);
        this._liveOut.addVariables(elseCurrent);
        this._liveOut.addVariables(this._updated);
        return this._liveOut;
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet loPassed) {
        int i;
        IfStatement ifstmt = (IfStatement)this._statements.get(0);
        if (this._statements.size() > 1) {
            throw new LanguageException(ifstmt.printErrorLocation() + "IfStatementBlock should have only 1 statement (if statement)");
        }
        VariableSet currentLiveOutIf = new VariableSet(loPassed);
        VariableSet currentLiveOutElse = new VariableSet(loPassed);
        int numBlocks = ifstmt.getIfBody().size();
        for (i = numBlocks - 1; i >= 0; --i) {
            currentLiveOutIf = ifstmt.getIfBody().get(i).analyze(currentLiveOutIf);
        }
        numBlocks = ifstmt.getElseBody().size();
        for (i = numBlocks - 1; i >= 0; --i) {
            currentLiveOutElse = ifstmt.getElseBody().get(i).analyze(currentLiveOutElse);
        }
        VariableSet bothPathsLiveOut = new VariableSet();
        bothPathsLiveOut.addVariables(currentLiveOutIf);
        bothPathsLiveOut.addVariables(currentLiveOutElse);
        return bothPathsLiveOut;
    }

    public void setPredicateHops(Hop hops) {
        this._predicateHops = hops;
    }

    public Hop getPredicateHops() {
        return this._predicateHops;
    }

    public Lop getPredicateLops() {
        return this._predicateLops;
    }

    public void setPredicateLops(Lop predicateLops) {
        this._predicateLops = predicateLops;
    }

    @Override
    public VariableSet analyze(VariableSet loPassed) {
        VariableSet predVars = ((IfStatement)this._statements.get(0)).getConditionalPredicate().variablesRead();
        predVars.addVariables(((IfStatement)this._statements.get(0)).getConditionalPredicate().variablesUpdated());
        VariableSet candidateLO = new VariableSet(loPassed);
        VariableSet origLiveOut = new VariableSet(this._liveOut);
        this._liveOut = new VariableSet();
        for (String string : candidateLO.getVariableNames()) {
            if (!origLiveOut.containsVariable(string)) continue;
            this._liveOut.addVariable(string, candidateLO.getVariable(string));
        }
        this.initializebackwardLV(this._liveOut);
        VariableSet finalWarnSet = new VariableSet();
        for (String varName : this._warnSet.getVariableNames()) {
            if (!this._liveOut.containsVariable(varName)) continue;
            finalWarnSet.addVariable(varName, this._warnSet.getVariable(varName));
        }
        this._warnSet = finalWarnSet;
        for (String varName : this._warnSet.getVariableNames()) {
            LOG.warn((Object)(this._warnSet.getVariable(varName).printWarningLocation() + "Initialization of " + varName + " depends on if-else execution"));
        }
        this._liveIn = new VariableSet();
        this._liveIn.addVariables(this._liveOut);
        this._liveIn.removeVariables(this._kill);
        this._liveIn.addVariables(this._gen);
        VariableSet variableSet = new VariableSet();
        variableSet.addVariables(this._liveIn);
        return variableSet;
    }

    public boolean updatePredicateRecompilationFlag() {
        this._requiresPredicateRecompile = ConfigurationManager.isDynamicRecompilation() && Recompiler.requiresRecompilation(this.getPredicateHops());
        return this._requiresPredicateRecompile;
    }

    public boolean requiresPredicateRecompilation() {
        return this._requiresPredicateRecompile;
    }
}

