/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;

@JsonPropertyOrder(value={"type", "relation"})
public class UserTypeFilter {
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private String type;
    public static final String JSON_PROPERTY_RELATION = "relation";
    @Nullable
    private String relation;

    public UserTypeFilter type(@Nonnull String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull String type) {
        this.type = type;
    }

    public UserTypeFilter relation(@Nullable String relation) {
        this.relation = relation;
        return this;
    }

    @Nullable
    @JsonProperty(value="relation", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRelation() {
        return this.relation;
    }

    @JsonProperty(value="relation", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelation(@Nullable String relation) {
        this.relation = relation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTypeFilter userTypeFilter = (UserTypeFilter)o;
        return Objects.equals(this.type, userTypeFilter.type) && Objects.equals(this.relation, userTypeFilter.relation);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.relation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserTypeFilter {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    relation: ").append(this.toIndentedString(this.relation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            joiner.add(String.format(Locale.ROOT, "%stype%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getType()))));
        }
        if (this.getRelation() != null) {
            joiner.add(String.format(Locale.ROOT, "%srelation%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getRelation()))));
        }
        return joiner.toString();
    }
}

