/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.integration.config.ConverterRegistrar;
import org.springframework.integration.config.CustomConversionServiceFactoryBean;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.integration.config.IntegrationConverter;

public class IntegrationConverterInitializer
implements IntegrationConfigurationInitializer {
    @Override
    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        for (String beanName : registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (!IntegrationConverterInitializer.isIntegrationConverter(beanDefinition)) continue;
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ConverterRegistrar.IntegrationConverterRegistration.class).addConstructorArgReference(beanName);
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)registry);
        }
        if (!registry.containsBeanDefinition("converterRegistrar")) {
            registry.registerBeanDefinition("converterRegistrar", (BeanDefinition)new RootBeanDefinition(ConverterRegistrar.class));
        }
        if (!registry.containsBeanDefinition("integrationConversionService")) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(CustomConversionServiceFactoryBean.class);
            beanDefinition.setAutowireCandidate(false);
            registry.registerBeanDefinition("integrationConversionService", (BeanDefinition)beanDefinition);
        }
    }

    private static boolean isIntegrationConverter(BeanDefinition beanDefinition) {
        Object object;
        AnnotatedBeanDefinition annotatedBeanDefinition;
        AnnotationMetadata metadata;
        boolean hasIntegrationConverter = false;
        if (beanDefinition instanceof AnnotatedBeanDefinition && !(hasIntegrationConverter = (metadata = (annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition).getMetadata()).hasAnnotation(IntegrationConverter.class.getName())) && (object = beanDefinition.getSource()) instanceof MethodMetadata) {
            MethodMetadata beanMethodMetadata = (MethodMetadata)object;
            hasIntegrationConverter = beanMethodMetadata.isAnnotated(IntegrationConverter.class.getName());
        }
        return hasIntegrationConverter;
    }
}

