/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Optional;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaMetadataLog$FullTruncation$;
import kafka.raft.KafkaMetadataLog$UnknownReason$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.SegmentPosition;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.NotifyingRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.MapOps;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011=f\u0001\u0002<x\u0005qD!\"a\u000b\u0001\u0005\u000b\u0007I\u0011AA\u0017\u0011)\tI\u0004\u0001B\u0001B\u0003%\u0011q\u0006\u0005\u000b\u0003w\u0001!\u0011!Q\u0001\n\u0005u\u0002BCA&\u0001\t\u0005\t\u0015!\u0003\u0002N!Q\u0011Q\f\u0001\u0003\u0002\u0003\u0006I!a\u0018\t\u0015\u00055\u0005A!A!\u0002\u0013\ty\t\u0003\u0006\u0002\u0018\u0002\u0011\t\u0011)A\u0005\u00033Cq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u00024\u0002!\t%!.\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\"9\u0011Q\u001f\u0001\u0005B\u0005]\bbBA~\u0001\u0011%\u0011Q \u0005\b\u0005'\u0001A\u0011\tB\u000b\u0011\u001d\u00119\u0002\u0001C!\u00053AqA!\b\u0001\t\u0003\u0012y\u0002C\u0004\u0002@\u0002!\tEa\n\t\u000f\t%\u0002\u0001\"\u0011\u0003,!9!q\u0007\u0001\u0005B\te\u0002b\u0002B!\u0001\u0011\u0005#1\t\u0005\b\u0005\u000f\u0002A\u0011\tB%\u0011\u001d\u0011y\u0005\u0001C!\u0005?AqA!\u0015\u0001\t\u0003\u0012\u0019\u0006C\u0004\u0002\u000e\u0002!\tE!\u0017\t\u000f\tm\u0003\u0001\"\u0011\u0003^!9!Q\r\u0001\u0005B\t\u001d\u0004b\u0002B?\u0001\u0011\u0005#q\u0010\u0005\b\u0005\u0007\u0003A\u0011\tBC\u0011\u001d\u0011\t\n\u0001C!\u0005'CqA!&\u0001\t\u0003\u00129\nC\u0004\u0003\u001c\u0002!\tEa&\t\u000f\tu\u0005\u0001\"\u0011\u0003 \"9!1\u0015\u0001\u0005B\t\u0015\u0006b\u0002BR\u0001\u0011%!\u0011\u0016\u0005\b\tW\u0002A\u0011\u0002C7\u0011\u001d!Y\b\u0001C\u0005\t{Bq\u0001b!\u0001\t\u0003\u0012I\u0004C\u0004\u0005\u0006\u0002!I\u0001b\"\t\u000f\u0011U\u0005\u0001\"\u0003\u0003:!9Aq\u0013\u0001\u0005\n\te\u0002b\u0002CM\u0001\u0011%A1\u0014\u0005\b\tC\u0003A\u0011\u0002CR\u0011\u001d!I\u000b\u0001C!\tWC\u0001\u0002\",\u0001\t\u00039(QC\u0004\b\u0005\u0007<\b\u0012\u0001Bc\r\u00191x\u000f#\u0001\u0003H\"9\u0011\u0011U\u0017\u0005\u0002\t=\u0007b\u0002Bi[\u0011\u0005!1\u001b\u0005\b\u0005_lC\u0011\u0002By\u0011\u001d\u0011)0\fC\u0005\u0005o4\u0011b!\u0006.!\u0003\rJca\u0006\t\u000f\t=&G\"\u0001\u0004\u001a\u001911qH\u0017G\u0007\u0003B!ba\u00175\u0005+\u0007I\u0011AB/\u0011)\u0019y\u0006\u000eB\tB\u0003%\u0011\u0011\u0019\u0005\u000b\u0007C\"$Q3A\u0005\u0002\ru\u0003BCB2i\tE\t\u0015!\u0003\u0002B\"Q1Q\r\u001b\u0003\u0016\u0004%\ta!\u0018\t\u0015\r\u001dDG!E!\u0002\u0013\t\t\rC\u0004\u0002\"R\"\ta!\u001b\t\u000f\t=F\u0007\"\u0011\u0004t!I1q\u000f\u001b\u0002\u0002\u0013\u00051\u0011\u0010\u0005\n\u0007\u0003#\u0014\u0013!C\u0001\u0007\u0007C\u0011b!'5#\u0003%\taa!\t\u0013\rmE'%A\u0005\u0002\r\r\u0005\"CBOi\u0005\u0005I\u0011IBP\u0011%\u0019)\u000bNA\u0001\n\u0003\u00199\u000bC\u0005\u0004*R\n\t\u0011\"\u0001\u0004,\"I1q\u0017\u001b\u0002\u0002\u0013\u00053\u0011\u0018\u0005\n\u0007\u0007$\u0014\u0011!C\u0001\u0007\u000bD\u0011b!35\u0003\u0003%\tea3\t\u0013\r=G'!A\u0005B\tU\u0001\"CBii\u0005\u0005I\u0011IBj\u0011%\u0019)\u000eNA\u0001\n\u0003\u001a9nB\u0005\u0005\u001e5\n\t\u0011#\u0003\u0005 \u0019I1qH\u0017\u0002\u0002#%A\u0011\u0005\u0005\b\u0003C[E\u0011\u0001C\u001a\u0011%\u0019\tnSA\u0001\n\u000b\u001a\u0019\u000eC\u0005\u0003R.\u000b\t\u0011\"!\u00056!IAQH&\u0002\u0002\u0013\u0005Eq\b\u0005\n\t\u001bZ\u0015\u0011!C\u0005\t\u001f2aaa7.\r\u000eu\u0007BCBp#\nU\r\u0011\"\u0001\u0004^!Q1\u0011])\u0003\u0012\u0003\u0006I!!1\t\u0015\r\r\u0018K!f\u0001\n\u0003\u0019i\u0006\u0003\u0006\u0004fF\u0013\t\u0012)A\u0005\u0003\u0003D!ba:R\u0005+\u0007I\u0011AB/\u0011)\u0019I/\u0015B\tB\u0003%\u0011\u0011\u0019\u0005\b\u0003C\u000bF\u0011ABv\u0011\u001d\u0011y+\u0015C!\u0007kD\u0011ba\u001eR\u0003\u0003%\ta!?\t\u0013\r\u0005\u0015+%A\u0005\u0002\r\r\u0005\"CBM#F\u0005I\u0011ABB\u0011%\u0019Y*UI\u0001\n\u0003\u0019\u0019\tC\u0005\u0004\u001eF\u000b\t\u0011\"\u0011\u0004 \"I1QU)\u0002\u0002\u0013\u00051q\u0015\u0005\n\u0007S\u000b\u0016\u0011!C\u0001\t\u0003A\u0011ba.R\u0003\u0003%\te!/\t\u0013\r\r\u0017+!A\u0005\u0002\u0011\u0015\u0001\"CBe#\u0006\u0005I\u0011\tC\u0005\u0011%\u0019y-UA\u0001\n\u0003\u0012)\u0002C\u0005\u0004RF\u000b\t\u0011\"\u0011\u0004T\"I1Q[)\u0002\u0002\u0013\u0005CQB\u0004\n\t#j\u0013\u0011!E\u0005\t'2\u0011ba7.\u0003\u0003EI\u0001\"\u0016\t\u000f\u0005\u0005\u0006\u000e\"\u0001\u0005Z!I1\u0011\u001b5\u0002\u0002\u0013\u001531\u001b\u0005\n\u0005#D\u0017\u0011!CA\t7B\u0011\u0002\"\u0010i\u0003\u0003%\t\tb\u0019\t\u0013\u00115\u0003.!A\u0005\n\u0011=sa\u0002C4[!51\u0011\b\u0004\b\u0007_i\u0003RBB\u0019\u0011\u001d\t\tk\u001cC\u0001\u0007oAqAa,p\t\u0003\u001aYdB\u0004\u0005j5Bi\u0001b\u0006\u0007\u000f\u0011EQ\u0006#\u0004\u0005\u0014!9\u0011\u0011U:\u0005\u0002\u0011U\u0001b\u0002BXg\u0012\u0005C\u0011\u0004\u0002\u0011\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001eT!\u0001_=\u0002\tI\fg\r\u001e\u0006\u0002u\u0006)1.\u00194lC\u000e\u00011C\u0002\u0001~\u0003\u0017\ty\u0002E\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0003mC:<'BAA\u0003\u0003\u0011Q\u0017M^1\n\u0007\u0005%qP\u0001\u0004PE*,7\r\u001e\t\u0005\u0003\u001b\tY\"\u0004\u0002\u0002\u0010)\u0019\u00010!\u0005\u000b\u0007i\f\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u001a\u0005\u0019qN]4\n\t\u0005u\u0011q\u0002\u0002\u000e%\u0016\u0004H.[2bi\u0016$Gj\\4\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\nz\u0003\u0015)H/\u001b7t\u0013\u0011\tI#a\t\u0003\u000f1{wmZ5oO\u0006\u0019An\\4\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003ki!!a\r\u000b\u0007\u0005-\u00120\u0003\u0003\u00028\u0005M\"AC+oS\u001aLW\r\u001a'pO\u0006!An\\4!\u0003\u0011!\u0018.\\3\u0011\t\u0005}\u0012qI\u0007\u0003\u0003\u0003RA!!\n\u0002D)!\u0011QIA\t\u0003\u0019\u0019w.\\7p]&!\u0011\u0011JA!\u0005\u0011!\u0016.\\3\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003BA(\u00033j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u0005kRLGN\u0003\u0003\u0002X\u0005E\u0011AB:feZ,'/\u0003\u0003\u0002\\\u0005E#!C*dQ\u0016$W\u000f\\3s\u0003%\u0019h.\u00199tQ>$8\u000f\u0005\u0005\u0002b\u0005=\u00141OA=\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0005\u0003S\nY'\u0001\u0006d_2dWm\u0019;j_:T!!!\u001c\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005E\u00141\r\u0002\b)J,W-T1q!\u0011\ti!!\u001e\n\t\u0005]\u0014q\u0002\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i!\u0019\tY(! \u0002\u00026\u0011\u00111N\u0005\u0005\u0003\u007f\nYG\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*!\u0011qQA\t\u0003!\u0019h.\u00199tQ>$\u0018\u0002BAF\u0003\u000b\u0013QCR5mKJ\u000bwo\u00158baNDw\u000e\u001e*fC\u0012,'/\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005E\u00151S\u0007\u0003\u0003\u0007JA!!&\u0002D\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017AB2p]\u001aLw\r\u0005\u0003\u0002\u001c\u0006uU\"A<\n\u0007\u0005}uOA\tNKR\fG-\u0019;b\u0019><7i\u001c8gS\u001e\fa\u0001P5oSRtDCDAS\u0003O\u000bI+a+\u0002.\u0006=\u0016\u0011\u0017\t\u0004\u00037\u0003\u0001bBA\u0016\u0011\u0001\u0007\u0011q\u0006\u0005\b\u0003wA\u0001\u0019AA\u001f\u0011\u001d\tY\u0005\u0003a\u0001\u0003\u001bBq!!\u0018\t\u0001\u0004\ty\u0006C\u0004\u0002\u000e\"\u0001\r!a$\t\u000f\u0005]\u0005\u00021\u0001\u0002\u001a\u0006!!/Z1e)\u0019\t9,!0\u0002HB!\u0011QBA]\u0013\u0011\tY,a\u0004\u0003\u00191{wMR3uG\"LeNZ8\t\u000f\u0005}\u0016\u00021\u0001\u0002B\u0006Y1\u000f^1si>3gm]3u!\u0011\tY(a1\n\t\u0005\u0015\u00171\u000e\u0002\u0005\u0019>tw\rC\u0004\u0002J&\u0001\r!a3\u0002\u001bI,\u0017\rZ%t_2\fG/[8o!\u0011\ti!!4\n\t\u0005=\u0017q\u0002\u0002\n\u0013N|G.\u0019;j_:\fa\"\u00199qK:$\u0017i\u001d'fC\u0012,'\u000f\u0006\u0004\u0002V\u0006m\u00171\u001e\t\u0005\u0003\u001b\t9.\u0003\u0003\u0002Z\u0006=!!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000eC\u0004\u0002^*\u0001\r!a8\u0002\u000fI,7m\u001c:egB!\u0011\u0011]At\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\r\u0013A\u0002:fG>\u0014H-\u0003\u0003\u0002j\u0006\r(a\u0002*fG>\u0014Hm\u001d\u0005\b\u0003[T\u0001\u0019AAx\u0003\u0015)\u0007o\\2i!\u0011\tY(!=\n\t\u0005M\u00181\u000e\u0002\u0004\u0013:$\u0018\u0001E1qa\u0016tG-Q:G_2dwn^3s)\u0011\t).!?\t\u000f\u0005u7\u00021\u0001\u0002`\u0006i\u0002.\u00198eY\u0016\fe\u000eZ\"p]Z,'\u000f\u001e'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000e\u0006\u0003\u0002V\u0006}\bb\u0002B\u0001\u0019\u0001\u0007!1A\u0001\u000bCB\u0004XM\u001c3J]\u001a|\u0007\u0003\u0002B\u0003\u0005#i!Aa\u0002\u000b\t\u0005-\"\u0011\u0002\u0006\u0005\u0005\u0017\u0011i!A\u0005j]R,'O\\1mg*!!qBA\t\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!7\u0003\b\u0005\u0001B.Y:u\r\u0016$8\r[3e\u000bB|7\r\u001b\u000b\u0003\u0003_\f\u0011#\u001a8e\u001f\u001a47/\u001a;G_J,\u0005o\\2i)\u0011\t\u0019Ha\u0007\t\u000f\u00055h\u00021\u0001\u0002p\u0006IQM\u001c3PM\u001a\u001cX\r\u001e\u000b\u0003\u0005C\u0001B!!\u0004\u0003$%!!QEA\b\u0005EaunZ(gMN,G/T3uC\u0012\fG/\u0019\u000b\u0003\u0003\u0003\f!\u0002\u001e:v]\u000e\fG/\u001a+p)\u0011\u0011iCa\r\u0011\t\u0005m$qF\u0005\u0005\u0005c\tYG\u0001\u0003V]&$\bb\u0002B\u001b#\u0001\u0007\u0011\u0011Y\u0001\u0007_\u001a47/\u001a;\u00021Q\u0014XO\\2bi\u0016$v\u000eT1uKN$8K\\1qg\"|G\u000f\u0006\u0002\u0003<A!\u00111\u0010B\u001f\u0013\u0011\u0011y$a\u001b\u0003\u000f\t{w\u000e\\3b]\u0006)\u0012N\\5uS\u0006d\u0017N_3MK\u0006$WM]#q_\u000eDG\u0003\u0002B\u0017\u0005\u000bBq!!<\u0014\u0001\u0004\ty/A\nva\u0012\fG/\u001a%jO\"<\u0016\r^3s[\u0006\u00148\u000e\u0006\u0003\u0003.\t-\u0003b\u0002B')\u0001\u0007!\u0011E\u0001\u000f_\u001a47/\u001a;NKR\fG-\u0019;b\u00035A\u0017n\u001a5XCR,'/\\1sW\u0006)a\r\\;tQR!!Q\u0006B+\u0011\u001d\u00119F\u0006a\u0001\u0005w\tqCZ8sG\u00164E.^:i\u0003\u000e$\u0018N^3TK\u001elWM\u001c;\u0015\u0005\u0005=\u0015a\u0002;pa&\u001c\u0017\n\u001a\u000b\u0003\u0005?\u0002B!!%\u0003b%!!1MA\"\u0005\u0011)V/\u001b3\u0002#\r\u0014X-\u0019;f\u001d\u0016<8K\\1qg\"|G\u000f\u0006\u0003\u0003j\te\u0004C\u0002B6\u0005_\u0012\u0019(\u0004\u0002\u0003n)!\u00111KA\u0002\u0013\u0011\u0011\tH!\u001c\u0003\u0011=\u0003H/[8oC2\u0004B!a!\u0003v%!!qOAC\u0005E\u0011\u0016m^*oCB\u001c\bn\u001c;Xe&$XM\u001d\u0005\b\u0005wJ\u0002\u0019AA:\u0003)\u0019h.\u00199tQ>$\u0018\nZ\u0001\u001bGJ,\u0017\r^3OK^\u001cf.\u00199tQ>$XK\\2iK\u000e\\W\r\u001a\u000b\u0005\u0005S\u0012\t\tC\u0004\u0003|i\u0001\r!a\u001d\u0002\u0019I,\u0017\rZ*oCB\u001c\bn\u001c;\u0015\t\t\u001d%q\u0012\t\u0007\u0005W\u0012yG!#\u0011\t\u0005\r%1R\u0005\u0005\u0005\u001b\u000b)IA\tSC^\u001cf.\u00199tQ>$(+Z1eKJDqAa\u001f\u001c\u0001\u0004\t\u0019(\u0001\bmCR,7\u000f^*oCB\u001c\bn\u001c;\u0015\u0005\t\u001d\u0015\u0001\u00057bi\u0016\u001cHo\u00158baNDw\u000e^%e)\t\u0011I\n\u0005\u0004\u0003l\t=\u00141O\u0001\u0013K\u0006\u0014H.[3tiNs\u0017\r]:i_RLE-\u0001\tp]Ns\u0017\r]:i_R4%o\u001c>f]R!!Q\u0006BQ\u0011\u001d\u0011Yh\ba\u0001\u0003g\nA\u0003Z3mKR,')\u001a4pe\u0016\u001cf.\u00199tQ>$H\u0003\u0002B\u001e\u0005OCqAa\u001f!\u0001\u0004\t\u0019\b\u0006\u0004\u0003<\t-&Q\u0016\u0005\b\u0005w\n\u0003\u0019AA:\u0011\u001d\u0011y+\ta\u0001\u0005c\u000baA]3bg>t\u0007c\u0001BZe9\u0019!Q\u0017\u0017\u000f\t\t]&\u0011\u0019\b\u0005\u0005s\u0013y,\u0004\u0002\u0003<*\u0019!QX>\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0018B\u0001=z\u0003AY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w\rE\u0002\u0002\u001c6\u001aR!\fBe\u0003?\u0001B!a\u001f\u0003L&!!QZA6\u0005\u0019\te.\u001f*fMR\u0011!QY\u0001\u0006CB\u0004H.\u001f\u000b\u000f\u0003K\u0013)Na6\u0003Z\n%(1\u001eBw\u0011\u001d\tii\fa\u0001\u0003\u001fCqAa\u00170\u0001\u0004\u0011y\u0006C\u0004\u0003\\>\u0002\rA!8\u0002\u000f\u0011\fG/\u0019#jeB!!q\u001cBs\u001b\t\u0011\tO\u0003\u0003\u0003d\u0006\r\u0011AA5p\u0013\u0011\u00119O!9\u0003\t\u0019KG.\u001a\u0005\b\u0003wy\u0003\u0019AA\u001f\u0011\u001d\tYe\fa\u0001\u0003\u001bBq!a&0\u0001\u0004\tI*\u0001\tsK\u000e|g/\u001a:T]\u0006\u00048\u000f[8ugR!\u0011q\fBz\u0011\u001d\tY\u0003\ra\u0001\u0003_\t1\u0003Z3mKR,7K\\1qg\"|GOR5mKN$\u0002B!\f\u0003z\u000e51\u0011\u0003\u0005\b\u0005w\f\u0004\u0019\u0001B\u007f\u0003\u0019awn\u001a#jeB!!q`B\u0005\u001b\t\u0019\tA\u0003\u0003\u0004\u0004\r\u0015\u0011\u0001\u00024jY\u0016TAaa\u0002\u0002\u0004\u0005\u0019a.[8\n\t\r-1\u0011\u0001\u0002\u0005!\u0006$\b\u000eC\u0004\u0004\u0010E\u0002\r!a\u0018\u0002!\u0015D\b/\u001b:fINs\u0017\r]:i_R\u001c\bbBB\nc\u0001\u0007\u0011qD\u0001\bY><w-\u001b8h\u0005Y\u0019f.\u00199tQ>$H)\u001a7fi&|gNU3bg>t7c\u0001\u001a\u0003JR!11DB\u0016!\u0011\u0019ib!\n\u000f\t\r}1\u0011\u0005\t\u0005\u0005s\u000bY'\u0003\u0003\u0004$\u0005-\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0004(\r%\"AB*ue&twM\u0003\u0003\u0004$\u0005-\u0004b\u0002B>g\u0001\u0007\u00111O\u0015\u0006e=$\u0014k\u001d\u0002\u000f\rVdG\u000e\u0016:v]\u000e\fG/[8o'\u0015y'\u0011ZB\u001a!\r\u0019)DM\u0007\u0002[Q\u00111\u0011\b\t\u0004\u0007kyG\u0003BB\u000e\u0007{AqAa\u001fr\u0001\u0004\t\u0019HA\tSKR,g\u000e^5p]6\u001b(I]3bG\"\u001c\u0012\u0002\u000eBe\u0007g\u0019\u0019e!\u0013\u0011\t\u0005m4QI\u0005\u0005\u0007\u000f\nYGA\u0004Qe>$Wo\u0019;\u0011\t\r-3Q\u000b\b\u0005\u0007\u001b\u001a\tF\u0004\u0003\u0003:\u000e=\u0013BAA7\u0013\u0011\u0019\u0019&a\u001b\u0002\u000fA\f7m[1hK&!1qKB-\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\u0011\u0019\u0019&a\u001b\u0002\u00079|w/\u0006\u0002\u0002B\u0006!an\\<!\u0003%!\u0018.\\3ti\u0006l\u0007/\u0001\u0006uS6,7\u000f^1na\u0002\nqB]3uK:$\u0018n\u001c8NS2d\u0017n]\u0001\u0011e\u0016$XM\u001c;j_:l\u0015\u000e\u001c7jg\u0002\"\u0002ba\u001b\u0004n\r=4\u0011\u000f\t\u0004\u0007k!\u0004bBB.w\u0001\u0007\u0011\u0011\u0019\u0005\b\u0007CZ\u0004\u0019AAa\u0011\u001d\u0019)g\u000fa\u0001\u0003\u0003$Baa\u0007\u0004v!9!1\u0010\u001fA\u0002\u0005M\u0014\u0001B2paf$\u0002ba\u001b\u0004|\ru4q\u0010\u0005\n\u00077j\u0004\u0013!a\u0001\u0003\u0003D\u0011b!\u0019>!\u0003\u0005\r!!1\t\u0013\r\u0015T\b%AA\u0002\u0005\u0005\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0007\u000bSC!!1\u0004\b.\u00121\u0011\u0012\t\u0005\u0007\u0017\u001b)*\u0004\u0002\u0004\u000e*!1qRBI\u0003%)hn\u00195fG.,GM\u0003\u0003\u0004\u0014\u0006-\u0014AC1o]>$\u0018\r^5p]&!1qSBG\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCABQ!\rq81U\u0005\u0004\u0007Oy\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAAx\u00039\u0001(o\u001c3vGR,E.Z7f]R$Ba!,\u00044B!\u00111PBX\u0013\u0011\u0019\t,a\u001b\u0003\u0007\u0005s\u0017\u0010C\u0005\u00046\u000e\u000b\t\u00111\u0001\u0002p\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"aa/\u0011\r\ru6qXBW\u001b\t\t9'\u0003\u0003\u0004B\u0006\u001d$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u000f\u0004H\"I1QW#\u0002\u0002\u0003\u00071QV\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0004\"\u000e5\u0007\"CB[\r\u0006\u0005\t\u0019AAx\u0003!A\u0017m\u001d5D_\u0012,\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\r\u0005\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0003<\re\u0007\"CB[\u0013\u0006\u0005\t\u0019ABW\u0005M\u0011V\r^3oi&|gnU5{K\n\u0013X-Y2i'%\t&\u0011ZB\u001a\u0007\u0007\u001aI%A\u0004m_\u001e\u001c\u0016N_3\u0002\u00111|wmU5{K\u0002\nQb\u001d8baNDw\u000e^:TSj,\u0017AD:oCB\u001c\bn\u001c;t'&TX\rI\u0001\u0012e\u0016$XM\u001c;j_:l\u0015\r\u001f\"zi\u0016\u001c\u0018A\u0005:fi\u0016tG/[8o\u001b\u0006D()\u001f;fg\u0002\"\u0002b!<\u0004p\u000eE81\u001f\t\u0004\u0007k\t\u0006bBBp1\u0002\u0007\u0011\u0011\u0019\u0005\b\u0007GD\u0006\u0019AAa\u0011\u001d\u00199\u000f\u0017a\u0001\u0003\u0003$Baa\u0007\u0004x\"9!1P-A\u0002\u0005MD\u0003CBw\u0007w\u001cipa@\t\u0013\r}'\f%AA\u0002\u0005\u0005\u0007\"CBr5B\u0005\t\u0019AAa\u0011%\u00199O\u0017I\u0001\u0002\u0004\t\t\r\u0006\u0003\u0004.\u0012\r\u0001\"CB[A\u0006\u0005\t\u0019AAx)\u0011\u0011Y\u0004b\u0002\t\u0013\rU&-!AA\u0002\r5F\u0003BBQ\t\u0017A\u0011b!.d\u0003\u0003\u0005\r!a<\u0015\t\tmBq\u0002\u0005\n\u0007k3\u0017\u0011!a\u0001\u0007[\u0013Q\"\u00168l]><hNU3bg>t7#B:\u0003J\u000eMBC\u0001C\f!\r\u0019)d\u001d\u000b\u0005\u00077!Y\u0002C\u0004\u0003|U\u0004\r!a\u001d\u0002#I+G/\u001a8uS>tWj\u001d\"sK\u0006\u001c\u0007\u000eE\u0002\u00046-\u001bRa\u0013C\u0012\t_\u0001B\u0002\"\n\u0005,\u0005\u0005\u0017\u0011YAa\u0007Wj!\u0001b\n\u000b\t\u0011%\u00121N\u0001\beVtG/[7f\u0013\u0011!i\u0003b\n\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0003`\u0012E\u0012\u0002BB,\u0005C$\"\u0001b\b\u0015\u0011\r-Dq\u0007C\u001d\twAqaa\u0017O\u0001\u0004\t\t\rC\u0004\u0004b9\u0003\r!!1\t\u000f\r\u0015d\n1\u0001\u0002B\u00069QO\\1qa2LH\u0003\u0002C!\t\u0013\u0002b!a\u001f\u0002~\u0011\r\u0003CCA>\t\u000b\n\t-!1\u0002B&!AqIA6\u0005\u0019!V\u000f\u001d7fg!IA1J(\u0002\u0002\u0003\u000711N\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,G#A?\u0002'I+G/\u001a8uS>t7+\u001b>f\u0005J,\u0017m\u00195\u0011\u0007\rU\u0002nE\u0003i\t/\"y\u0003\u0005\u0007\u0005&\u0011-\u0012\u0011YAa\u0003\u0003\u001ci\u000f\u0006\u0002\u0005TQA1Q\u001eC/\t?\"\t\u0007C\u0004\u0004`.\u0004\r!!1\t\u000f\r\r8\u000e1\u0001\u0002B\"91q]6A\u0002\u0005\u0005G\u0003\u0002C!\tKB\u0011\u0002b\u0013m\u0003\u0003\u0005\ra!<\u0002\u001d\u0019+H\u000e\u001c+sk:\u001c\u0017\r^5p]\u0006iQK\\6o_^t'+Z1t_:\f\u0011\u0003\\8bINs\u0017\r]:i_R\u001c\u0016N_3t)\t!y\u0007\u0005\u0004\u0004L\u0011EDQO\u0005\u0005\tg\u001aIFA\u0002TKF\u0004\u0002\"a\u001f\u0005x\u0005M\u0014\u0011Y\u0005\u0005\ts\nYG\u0001\u0004UkBdWMM\u0001\u0016e\u0016\fGm\u00158baNDw\u000e\u001e+j[\u0016\u001cH/Y7q)\u0011!y\b\"!\u0011\r\u0005m\u0014QPAa\u0011\u001d\u0011Yh\ta\u0001\u0003g\n!\"\\1zE\u0016\u001cE.Z1o\u00039\u0019G.Z1o':\f\u0007o\u001d5piN$BAa\u000f\u0005\n\"9A1R\u0013A\u0002\u00115\u0015!\u00039sK\u0012L7-\u0019;f!!\tY\bb$\u0002t\u0011M\u0015\u0002\u0002CI\u0003W\u0012\u0011BR;oGRLwN\\\u0019\u0011\r\u0005m\u0014Q\u0010BY\u0003e\u0019G.Z1o':\f\u0007o\u001d5piN\u0014V\r^3oi&|g.T:\u00027\rdW-\u00198T]\u0006\u00048\u000f[8ugJ+G/\u001a8uS>t7+\u001b>f\u0003U1wN]4fiNs\u0017\r]:i_R\u001c()\u001a4pe\u0016$B!a\u0018\u0005\u001e\"9Aq\u0014\u0015A\u0002\u0005M\u0014A\u00057pON#\u0018M\u001d;T]\u0006\u00048\u000f[8u\u0013\u0012\fqB]3n_Z,7K\\1qg\"|Go\u001d\u000b\u0007\u0005[!)\u000bb*\t\u000f\r=\u0011\u00061\u0001\u0002`!9!qV\u0015A\u0002\tE\u0016!B2m_N,GC\u0001B\u0017\u00035\u0019h.\u00199tQ>$8i\\;oi\u0002")
public final class KafkaMetadataLog
implements ReplicatedLog,
Logging {
    private final UnifiedLog log;
    private final Time time;
    private final Scheduler scheduler;
    private final TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots;
    private final TopicPartition topicPartition;
    private final MetadataLogConfig config;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Scheduler scheduler, MetadataLogConfig config) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, topicId, dataDir, time, scheduler, config);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return super.validateOffsetAndEpoch(x$1, x$2);
    }

    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return super.truncateToEndOffset(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        FetchIsolation fetchIsolation;
        if (Isolation.COMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.HIGH_WATERMARK;
        } else if (Isolation.UNCOMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.LOG_END;
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unhandled read isolation ").append(readIsolation).toString());
        }
        FetchIsolation isolation = fetchIsolation;
        FetchDataInfo fetchInfo = this.log().read(startOffset, this.config.maxFetchSizeInBytes(), isolation, true);
        return new LogFetchInfo(fetchInfo.records, new LogOffsetMetadata(fetchInfo.fetchOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(fetchInfo.fetchOffsetMetadata.segmentBaseOffset, fetchInfo.fetchOffsetMetadata.relativePositionInSegment))));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        MemoryRecords x$1 = (MemoryRecords)records;
        RequestLocal x$4 = RequestLocal$.MODULE$.NoCaching();
        MetadataVersion x$5 = this.log().appendAsLeader$default$4();
        VerificationGuard x$6 = this.log().appendAsLeader$default$6();
        return this.handleAndConvertLogAppendInfo(this.log().appendAsLeader(x$1, epoch, AppendOrigin.RAFT_LEADER, x$5, x$4, x$6));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsFollower(Records records) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsFollower((MemoryRecords)records));
    }

    private org.apache.kafka.raft.LogAppendInfo handleAndConvertLogAppendInfo(LogAppendInfo appendInfo) {
        if (appendInfo.firstOffset() != UnifiedLog$.MODULE$.UnknownOffset()) {
            return new org.apache.kafka.raft.LogAppendInfo(appendInfo.firstOffset(), appendInfo.lastOffset());
        }
        throw new KafkaException("Append failed unexpectedly");
    }

    public int lastFetchedEpoch() {
        return BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger((int)KafkaMetadataLog.$anonfun$lastFetchedEpoch$2(this, snapshotId))).orElse(BoxesRunTime.boxToInteger((int)0)))));
    }

    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.earliestSnapshotId()));
        Option<org.apache.kafka.server.common.OffsetAndEpoch> option2 = this.log().endOffsetForEpoch(epoch);
        Tuple2 tuple2 = new Tuple2(option2, (Object)option);
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            if (option instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
                if (offsetAndEpoch.offset() == snapshotId.offset() && offsetAndEpoch.leaderEpoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
                }
            }
        }
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.leaderEpoch());
        }
        if (None$.MODULE$.equals(option2)) {
            return new OffsetAndEpoch(this.endOffset().offset, this.lastFetchedEpoch());
        }
        throw new MatchError((Object)tuple2);
    }

    public LogOffsetMetadata endOffset() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata endOffsetMetadata = this.log().logEndOffsetMetadata();
        return new LogOffsetMetadata(endOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset, endOffsetMetadata.relativePositionInSegment)));
    }

    public long startOffset() {
        return this.log().logStartOffset();
    }

    public void truncateTo(long offset) {
        if (offset < this.highWatermark().offset) {
            throw new IllegalArgumentException(new StringBuilder(74).append("Attempt to truncate to offset ").append(offset).append(", which is below ").append("the current high watermark ").append(this.highWatermark().offset).toString());
        }
        this.log().truncateTo(offset);
    }

    /*
     * WARNING - void declaration
     */
    public boolean truncateToLatestSnapshot() {
        void var5_8;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap;
        boolean bl;
        OffsetAndEpoch snapshotId;
        int latestEpoch = BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (option instanceof Some && ((snapshotId = (OffsetAndEpoch)((Some)option).value()).epoch() > latestEpoch || snapshotId.epoch() == latestEpoch && snapshotId.offset() > this.endOffset().offset)) {
            this.log().truncateFullyAndStartAt(snapshotId.offset(), this.log().truncateFullyAndStartAt$default$2());
            TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap2 = this.snapshots;
            synchronized (treeMap2) {
                TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap3 = this.forgetSnapshotsBefore(snapshotId);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl2;
                treeMap = treeMap3;
            }
        } else {
            bl = false;
            treeMap = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        }
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap4 = treeMap;
        boolean truncated = bl;
        this.removeSnapshots(treeMap4, KafkaMetadataLog$FullTruncation$.MODULE$);
        return (boolean)var5_8;
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log().maybeAssignEpochStartOffset(epoch, this.log().logEndOffset());
    }

    public void updateHighWatermark(LogOffsetMetadata offsetMetadata) {
        long logHighWatermark;
        long l;
        OffsetMetadata segmentPosition;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(offsetMetadata.metadata));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            l = this.log().updateHighWatermark(new org.apache.kafka.storage.internals.log.LogOffsetMetadata(offsetMetadata.offset, segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
        } else {
            l = logHighWatermark = this.log().updateHighWatermark(offsetMetadata.offset);
        }
        if (logHighWatermark != offsetMetadata.offset) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$updateHighWatermark$1(logHighWatermark, offsetMetadata);
                Object var7_6 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                return;
            }
            return;
        }
    }

    public LogOffsetMetadata highWatermark() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata hwm = this.log().fetchOffsetSnapshot().highWatermark;
        Optional segmentPosition = !hwm.messageOffsetOnly() ? Optional.of(new SegmentPosition(hwm.segmentBaseOffset, hwm.relativePositionInSegment)) : Optional.empty();
        return new LogOffsetMetadata(hwm.messageOffset, segmentPosition);
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.log().flush(forceFlushActiveSegment);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Uuid topicId() {
        return (Uuid)this.log().topicId().get();
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        if (snapshotId.offset() < this.startOffset()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$createNewSnapshot$1(this, snapshotId);
                Object var6_2 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Optional.empty();
        }
        long highWatermarkOffset = this.highWatermark().offset;
        if (snapshotId.offset() > highWatermarkOffset) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot create a snapshot with an id (").append(snapshotId).append(") greater than the high-watermark (").append(highWatermarkOffset).append(")").toString());
        }
        ValidOffsetAndEpoch validOffsetAndEpoch = this.validateOffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
        ValidOffsetAndEpoch.Kind kind = validOffsetAndEpoch.kind();
        ValidOffsetAndEpoch.Kind kind2 = ValidOffsetAndEpoch.Kind.VALID;
        if (kind == null ? kind2 != null : !kind.equals(kind2)) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Snapshot id (").append(snapshotId).append(") is not valid according to the log: ").append(validOffsetAndEpoch).toString());
        }
        return this.createNewSnapshotUnchecked(snapshotId);
    }

    public Optional<RawSnapshotWriter> createNewSnapshotUnchecked(OffsetAndEpoch snapshotId2) {
        boolean bl;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            bl = this.snapshots.contains((Object)snapshotId2);
        }
        if (bl) {
            return Optional.empty();
        }
        return Optional.of(new NotifyingRawSnapshotWriter((RawSnapshotWriter)FileRawSnapshotWriter.create((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId2), snapshotId -> this.onSnapshotFrozen((OffsetAndEpoch)snapshotId)));
    }

    /*
     * Unable to fully structure code
     */
    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            block8: {
                block7: {
                    var5_3 = false;
                    var6_4 = null;
                    var7_5 = this.snapshots.get((Object)snapshotId);
                    if (!None$.MODULE$.equals(var7_5)) break block7;
                    v0 = None$.MODULE$;
                    break block8;
                }
                if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
                var5_3 = true;
                var6_4 = (Some)var7_5;
                var8_6 = (Option)var6_4.value();
                if (None$.MODULE$.equals(var8_6)) {
                    v0 = this.liftedTree1$1(snapshotId);
                } else if (var5_3) {
                    v0 = (Option)var6_4.value();
                } else {
                    throw new MatchError((Object)var7_5);
                }
            }
            reader = v0;
            var3_8 = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)reader));
            return var3_8;
        }
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional<RawSnapshotReader> optional = this.latestSnapshotId().flatMap(snapshotId -> this.readSnapshot((OffsetAndEpoch)snapshotId));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.lastOption().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.headOption().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            this.snapshots.put((Object)snapshotId, (Object)None$.MODULE$);
            return;
        }
    }

    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        return this.deleteBeforeSnapshot(snapshotId, KafkaMetadataLog$UnknownReason$.MODULE$);
    }

    /*
     * Unable to fully structure code
     */
    private boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId, SnapshotDeletionReason reason) {
        var3_3 = this.snapshots;
        synchronized (var3_3) {
            var4_4 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            latestSnapshotId = (OffsetAndEpoch)((Some)var4_4).value();
            if (this.snapshots.contains((Object)snapshotId) && this.startOffset() < snapshotId.offset() && snapshotId.offset() <= latestSnapshotId.offset() && this.log().maybeIncrementLogStartOffset(snapshotId.offset(), LogStartOffsetIncrementReason.SnapshotGenerated)) {
                deletedSegments = this.log().deleteOldSegments();
                forgottenSnapshots = this.forgetSnapshotsBefore(snapshotId);
                v0 = deletedSegments != 0 || forgottenSnapshots.nonEmpty() != false;
                v1 = forgottenSnapshots;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
                v1 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            }
            var9_8 = v1;
            var8_9 = v0;
        }
        this.removeSnapshots(var9_8, reason);
        return var8_9;
    }

    private Seq<Tuple2<OffsetAndEpoch, Object>> loadSnapshotSizes() {
        return (Seq)this.snapshots.keys().toSeq().flatMap((Function1 & Serializable)snapshotId -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot((OffsetAndEpoch)snapshotId))).map((Function1 & Serializable)reader -> new Tuple2(snapshotId, (Object)BoxesRunTime.boxToLong((long)reader.sizeInBytes()))));
    }

    private Option<Object> readSnapshotTimestamp(OffsetAndEpoch snapshotId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot(snapshotId))).map((Function1 & Serializable)reader -> BoxesRunTime.boxToLong((long)KafkaMetadataLog.$anonfun$readSnapshotTimestamp$1(reader)));
    }

    public boolean maybeClean() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            boolean didClean = false;
            boolean bl = (didClean |= this.cleanSnapshotsRetentionSize()) | this.cleanSnapshotsRetentionMs();
            return bl;
        }
    }

    private boolean cleanSnapshots(Function1<OffsetAndEpoch, Option<SnapshotDeletionReason>> predicate) {
        Object object = new Object();
        try {
            if (this.snapshots.size() < 2) {
                return false;
            }
            BooleanRef didClean = BooleanRef.create((boolean)false);
            this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                SeqOps seqOps;
                if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
                    new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                        OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                        OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                        if (snapshot != null && nextSnapshot != null) {
                            Option option = (Option)predicate.apply((Object)snapshot);
                            if (option instanceof Some) {
                                SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                            } else {
                                if (None$.MODULE$.equals(option)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                                throw new MatchError((Object)option);
                            }
                            didClean$1.elem = true;
                            return BoxedUnit.UNIT;
                        }
                    }
                }
                return BoxesRunTime.boxToBoolean((boolean)false);
            });
            return didClean.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean cleanSnapshotsRetentionMs() {
        boolean bl;
        if (this.config.retentionMillis() < 0L) {
            return false;
        }
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> this.shouldClean$1((OffsetAndEpoch)snapshotId);
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                    SeqOps seqOps;
                    if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                            OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                            OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                            if (snapshot != null && nextSnapshot != null) {
                                Option option = (Option)predicate.apply((Object)snapshot);
                                if (option instanceof Some) {
                                    SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                    if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                    }
                                } else {
                                    if (None$.MODULE$.equals(option)) {
                                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                    }
                                    throw new MatchError((Object)option);
                                }
                                didClean$1.elem = true;
                                return BoxedUnit.UNIT;
                            }
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private boolean cleanSnapshotsRetentionSize() {
        boolean bl;
        if (this.config.retentionMaxBytes() < 0L) {
            return false;
        }
        Map snapshotSizes = this.loadSnapshotSizes().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        LongRef snapshotTotalSize = LongRef.create((long)BoxesRunTime.unboxToLong((Object)snapshotSizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> this.shouldClean$2((OffsetAndEpoch)snapshotId, snapshotSizes, snapshotTotalSize);
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                    SeqOps seqOps;
                    if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                            OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                            OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                            if (snapshot != null && nextSnapshot != null) {
                                Option option = (Option)predicate.apply((Object)snapshot);
                                if (option instanceof Some) {
                                    SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                    if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                    }
                                } else {
                                    if (None$.MODULE$.equals(option)) {
                                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                    }
                                    throw new MatchError((Object)option);
                                }
                                didClean$1.elem = true;
                                return BoxedUnit.UNIT;
                            }
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> forgetSnapshotsBefore(OffsetAndEpoch logStartSnapshotId) {
        TreeMap expiredSnapshots = (TreeMap)((MapOps)this.snapshots.until((Object)logStartSnapshotId)).clone();
        this.snapshots.$minus$minus$eq((IterableOnce)expiredSnapshots.keys());
        return expiredSnapshots;
    }

    private void removeSnapshots(TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots, SnapshotDeletionReason reason) {
        expiredSnapshots.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = reason.reason(snapshotId);
                    Object var4_4 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                return Snapshots.markForDelete((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId);
            }
            throw new MatchError(null);
        });
        if (expiredSnapshots.nonEmpty()) {
            this.scheduler.scheduleOnce("delete-snapshot-files", () -> KafkaMetadataLog$.MODULE$.kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(this.log().dir().toPath(), expiredSnapshots, this), this.config.fileDeleteDelayMs());
            return;
        }
    }

    public void close() {
        this.log().close();
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            ((IterableOnceOps)this.snapshots.values().flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
            this.snapshots.clear();
            return;
        }
    }

    public int snapshotCount() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            int n = this.snapshots.size();
            return n;
        }
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$2(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset;
        if (snapshotId.offset() == $this.startOffset() && snapshotId.offset() == logEndOffset) {
            return snapshotId.epoch();
        }
        throw new KafkaException(new StringBuilder(159).append("Log doesn't have a last fetch epoch and there is a snapshot (").append(snapshotId).append("). ").append("Expected the snapshot's end offset to match the log's end offset (").append(logEndOffset).append(") ").append("and the log start offset (").append($this.startOffset()).append(")").toString());
    }

    public static final /* synthetic */ String $anonfun$updateHighWatermark$1(long logHighWatermark$1, LogOffsetMetadata offsetMetadata$1) {
        return new StringBuilder(79).append("Log's high watermark (").append(logHighWatermark$1).append(") is different from the local replica's high watermark (").append(offsetMetadata$1).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$createNewSnapshot$1(KafkaMetadataLog $this, OffsetAndEpoch snapshotId$1) {
        return new StringBuilder(72).append("Cannot create a snapshot with an id (").append(snapshotId$1).append(") less than the log start offset (").append($this.startOffset()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$readSnapshot$1(OffsetAndEpoch snapshotId$2, Path path$1) {
        return new StringBuilder(47).append("Couldn't read ").append(snapshotId$2).append("; expected to find snapshot file ").append(path$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Option liftedTree1$1(OffsetAndEpoch snapshotId$2) {
        try {
            void var2_2;
            Some snapshotReader = new Some((Object)FileRawSnapshotReader.open((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2));
            this.snapshots.put((Object)snapshotId$2, (Object)snapshotReader);
            return var2_2;
        }
        catch (NoSuchFileException noSuchFileException) {
            Path path = Snapshots.snapshotPath((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2);
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$readSnapshot$1(snapshotId$2, path);
                Object var4_4 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.snapshots.remove((Object)snapshotId$2);
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ long $anonfun$readSnapshotTimestamp$1(RawSnapshotReader reader) {
        return Snapshots.lastContainedLogTimestamp((RawSnapshotReader)reader);
    }

    public static final /* synthetic */ Option $anonfun$cleanSnapshotsRetentionMs$1(KafkaMetadataLog $this, long timestamp) {
        long now = $this.time.milliseconds();
        if (now - timestamp > $this.config.retentionMillis()) {
            return new Some((Object)new RetentionMsBreach(now, timestamp, $this.config.retentionMillis()));
        }
        return None$.MODULE$;
    }

    private final Option shouldClean$1(OffsetAndEpoch snapshotId) {
        return this.readSnapshotTimestamp(snapshotId).flatMap((Function1 & Serializable)timestamp -> KafkaMetadataLog.$anonfun$cleanSnapshotsRetentionMs$1(this, BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    public static final /* synthetic */ Option $anonfun$cleanSnapshotsRetentionSize$1(KafkaMetadataLog $this, LongRef snapshotTotalSize$1, long snapshotSize) {
        if ($this.log().size() + snapshotTotalSize$1.elem > $this.config.retentionMaxBytes()) {
            long oldSnapshotTotalSize = snapshotTotalSize$1.elem;
            snapshotTotalSize$1.elem -= snapshotSize;
            return new Some((Object)new RetentionSizeBreach($this.log().size(), oldSnapshotTotalSize, $this.config.retentionMaxBytes()));
        }
        return None$.MODULE$;
    }

    private final Option shouldClean$2(OffsetAndEpoch snapshotId, Map snapshotSizes$1, LongRef snapshotTotalSize$1) {
        return snapshotSizes$1.get((Object)snapshotId).flatMap((Function1 & Serializable)snapshotSize -> KafkaMetadataLog.$anonfun$cleanSnapshotsRetentionSize$1(this, snapshotTotalSize$1, BoxesRunTime.unboxToLong((Object)snapshotSize)));
    }

    public static final /* synthetic */ String $anonfun$removeSnapshots$2(SnapshotDeletionReason reason$1, OffsetAndEpoch snapshotId$4) {
        return reason$1.reason(snapshotId$4);
    }

    public KafkaMetadataLog(UnifiedLog log, Time time, Scheduler scheduler, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots, TopicPartition topicPartition, MetadataLogConfig config) {
        this.log = log;
        this.time = time;
        this.scheduler = scheduler;
        this.snapshots = snapshots;
        this.topicPartition = topicPartition;
        this.config = config;
        this.logIdent_$eq(new StringBuilder(34).append("[MetadataLog partition=").append(topicPartition).append(", nodeId=").append(config.nodeId()).append("] ").toString());
    }

    private static final class RetentionMsBreach
    implements SnapshotDeletionReason,
    Product,
    Serializable {
        private final long now;
        private final long timestamp;
        private final long retentionMillis;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long now() {
            return this.now;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long retentionMillis() {
            return this.retentionMillis;
        }

        @Override
        public String reason(OffsetAndEpoch snapshotId) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(104).append("Marking snapshot ").append(snapshotId).append(" for deletion because its timestamp (").append(this.timestamp()).append(") is now (").append(this.now()).append(") older than the\n          |retention (").append(this.retentionMillis()).append(")").toString()));
        }

        public RetentionMsBreach copy(long now, long timestamp, long retentionMillis) {
            return new RetentionMsBreach(now, timestamp, retentionMillis);
        }

        public long copy$default$1() {
            return this.now();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.retentionMillis();
        }

        public String productPrefix() {
            return "RetentionMsBreach";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.now());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.timestamp());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.retentionMillis());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RetentionMsBreach;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "now";
                }
                case 1: {
                    return "timestamp";
                }
                case 2: {
                    return "retentionMillis";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"RetentionMsBreach".hashCode()), (int)Statics.longHash((long)this.now())), (int)Statics.longHash((long)this.timestamp())), (int)Statics.longHash((long)this.retentionMillis())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof RetentionMsBreach)) break block3;
                    RetentionMsBreach retentionMsBreach = (RetentionMsBreach)x$1;
                    if (this.now() != retentionMsBreach.now() || this.timestamp() != retentionMsBreach.timestamp() || this.retentionMillis() != retentionMsBreach.retentionMillis()) break block3;
                }
                return true;
            }
            return false;
        }

        public RetentionMsBreach(long now, long timestamp, long retentionMillis) {
            this.now = now;
            this.timestamp = timestamp;
            this.retentionMillis = retentionMillis;
            Product.$init$((Product)this);
        }
    }

    private static final class RetentionSizeBreach
    implements SnapshotDeletionReason,
    Product,
    Serializable {
        private final long logSize;
        private final long snapshotsSize;
        private final long retentionMaxBytes;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long logSize() {
            return this.logSize;
        }

        public long snapshotsSize() {
            return this.snapshotsSize;
        }

        public long retentionMaxBytes() {
            return this.retentionMaxBytes;
        }

        @Override
        public String reason(OffsetAndEpoch snapshotId) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(104).append("Marking snapshot ").append(snapshotId).append(" for deletion because the log size (").append(this.logSize()).append(") and snapshots size (").append(this.snapshotsSize()).append(")\n          |is greater than ").append(this.retentionMaxBytes()).toString()));
        }

        public RetentionSizeBreach copy(long logSize, long snapshotsSize, long retentionMaxBytes) {
            return new RetentionSizeBreach(logSize, snapshotsSize, retentionMaxBytes);
        }

        public long copy$default$1() {
            return this.logSize();
        }

        public long copy$default$2() {
            return this.snapshotsSize();
        }

        public long copy$default$3() {
            return this.retentionMaxBytes();
        }

        public String productPrefix() {
            return "RetentionSizeBreach";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.logSize());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.snapshotsSize());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.retentionMaxBytes());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RetentionSizeBreach;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "logSize";
                }
                case 1: {
                    return "snapshotsSize";
                }
                case 2: {
                    return "retentionMaxBytes";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"RetentionSizeBreach".hashCode()), (int)Statics.longHash((long)this.logSize())), (int)Statics.longHash((long)this.snapshotsSize())), (int)Statics.longHash((long)this.retentionMaxBytes())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof RetentionSizeBreach)) break block3;
                    RetentionSizeBreach retentionSizeBreach = (RetentionSizeBreach)x$1;
                    if (this.logSize() != retentionSizeBreach.logSize() || this.snapshotsSize() != retentionSizeBreach.snapshotsSize() || this.retentionMaxBytes() != retentionSizeBreach.retentionMaxBytes()) break block3;
                }
                return true;
            }
            return false;
        }

        public RetentionSizeBreach(long logSize, long snapshotsSize, long retentionMaxBytes) {
            this.logSize = logSize;
            this.snapshotsSize = snapshotsSize;
            this.retentionMaxBytes = retentionMaxBytes;
            Product.$init$((Product)this);
        }
    }

    private static interface SnapshotDeletionReason {
        public String reason(OffsetAndEpoch var1);
    }
}

