/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.cert.X509CRL;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.CRLFetcher;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class ResourceCRLFetcher
implements CRLFetcher {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceCRLFetcher.class);

    @Override
    public Collection<X509CRL> fetch(Collection<Resource> crls) {
        return crls.stream().map(crl -> {
            X509CRL x509CRL;
            block8: {
                LOGGER.debug("Fetching CRL data from [{}]", crl);
                InputStream ins = crl.getInputStream();
                try {
                    x509CRL = (X509CRL)CertUtils.getCertificateFactory().generateCRL(ins);
                    if (ins == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (ins != null) {
                            try {
                                ins.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
                        return null;
                    }
                }
                ins.close();
            }
            return x509CRL;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public X509CRL fetch(String crl) throws Exception {
        return this.fetch(new URI(crl).toURL());
    }

    @Override
    public X509CRL fetch(URI crl) throws Exception {
        return this.fetch(crl.toURL());
    }

    @Override
    public X509CRL fetch(URL crl) throws Exception {
        return this.fetch((Resource)new UrlResource(crl));
    }

    @Override
    public X509CRL fetch(Resource crl) throws Exception {
        Collection<X509CRL> results = this.fetch(CollectionUtils.wrap((Object)crl));
        if (!results.isEmpty()) {
            return results.iterator().next();
        }
        LOGGER.warn("Unable to fetch [{}]", (Object)crl);
        return null;
    }
}

