/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.ticket;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.oidc.ticket.OidcCibaRequest;
import org.apereo.cas.oidc.ticket.OidcCibaRequestFactory;
import org.apereo.cas.oidc.ticket.OidcDefaultCibaRequest;
import org.apereo.cas.oidc.web.controllers.ciba.CibaRequestContext;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;

public class OidcDefaultCibaRequestFactory
implements OidcCibaRequestFactory {
    protected final UniqueTicketIdGenerator idGenerator;
    protected final ExpirationPolicyBuilder<OidcCibaRequest> expirationPolicyBuilder;
    private final CipherExecutor<byte[], byte[]> cipherExecutor;

    public Class<? extends Ticket> getTicketType() {
        return OidcCibaRequest.class;
    }

    @Override
    public OidcCibaRequest create(CibaRequestContext holder) throws Throwable {
        String id = this.idGenerator.getNewTicketId("CIBA");
        HardTimeoutExpirationPolicy expirationPolicy = holder.getRequestedExpiry() > 0L ? new HardTimeoutExpirationPolicy(holder.getRequestedExpiry()) : this.expirationPolicyBuilder.buildTicketExpirationPolicy();
        AuthenticationBuilder authenticationBuilder = new DefaultAuthenticationBuilder(holder.getPrincipal()).addAttribute("scope", holder.getScope()).addAttribute("client_id", (Object)holder.getClientId());
        FunctionUtils.doIfNotBlank((CharSequence)holder.getUserCode(), userCode -> authenticationBuilder.addAttribute("user_code", userCode));
        FunctionUtils.doIfNotBlank((CharSequence)holder.getClientNotificationToken(), token -> authenticationBuilder.addAttribute("client_notification_token", token));
        FunctionUtils.doIfNotBlank((CharSequence)holder.getBindingMessage(), bindingMessage -> authenticationBuilder.addAttribute("binding_message", bindingMessage));
        Authentication authentication = authenticationBuilder.build();
        return new OidcDefaultCibaRequest(id, authentication, (ExpirationPolicy)expirationPolicy, holder.getScope(), holder.getClientId(), this.encodeCibaRequestId(id));
    }

    @Override
    public String decodeId(String requestId) {
        byte[] decoded = EncodingUtils.decodeUrlSafeBase64((String)requestId);
        return new String((byte[])this.cipherExecutor.withSigningDisabled().decode((Object)decoded), StandardCharsets.UTF_8);
    }

    private String encodeCibaRequestId(String id) {
        byte[] encodedId = (byte[])this.cipherExecutor.withSigningDisabled().encode((Object)id.getBytes(StandardCharsets.UTF_8));
        return Objects.requireNonNull(EncodingUtils.encodeUrlSafeBase64((byte[])encodedId));
    }

    @Generated
    public OidcDefaultCibaRequestFactory(UniqueTicketIdGenerator idGenerator, ExpirationPolicyBuilder<OidcCibaRequest> expirationPolicyBuilder, CipherExecutor<byte[], byte[]> cipherExecutor) {
        this.idGenerator = idGenerator;
        this.expirationPolicyBuilder = expirationPolicyBuilder;
        this.cipherExecutor = cipherExecutor;
    }

    @Generated
    public ExpirationPolicyBuilder<OidcCibaRequest> getExpirationPolicyBuilder() {
        return this.expirationPolicyBuilder;
    }
}

