/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    private static final DateTimeFormatter defaultDateFormatter = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).optionalStart().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalEnd().optionalStart().appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).optionalEnd().optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY).optionalEnd().optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR).optionalEnd().optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().parseLenient().optionalStart().appendOffsetId().optionalEnd().parseStrict().parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).toFormatter().withZone(ZoneId.systemDefault());

    public static Date parseDate(String dateString) {
        return Date.from(defaultDateFormatter.parse((CharSequence)dateString, Instant::from));
    }

    public static Calendar parseCalendar(String dateString, ZoneId zoneId) {
        return GregorianCalendar.from(defaultDateFormatter.withZone(zoneId).parse((CharSequence)dateString, ZonedDateTime::from));
    }
}

