/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.scripting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.lang3.tuple.Pair;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.scripting.Resolver;
import org.flowable.variable.api.delegate.VariableScope;

public class ScriptBindings
implements Bindings {
    protected static final Set<String> UNSTORED_KEYS = new HashSet<String>(Arrays.asList("out", "out:print", "lang:import", "context", "elcontext", "print", "println", "nashorn.global"));
    protected List<Resolver> scriptResolvers;
    protected VariableContainer scopeContainer;
    protected VariableContainer inputVariableContainer;
    protected Bindings defaultBindings;
    protected boolean storeScriptVariables = true;

    public ScriptBindings(List<Resolver> scriptResolvers, VariableContainer scopeContainer, VariableContainer inputVariableContainer) {
        this.scriptResolvers = scriptResolvers;
        this.scopeContainer = scopeContainer;
        this.inputVariableContainer = inputVariableContainer;
        this.defaultBindings = new SimpleScriptContext().getBindings(100);
    }

    public ScriptBindings(List<Resolver> scriptResolvers, VariableContainer scopeContainer, VariableContainer inputVariableContainer, boolean storeScriptVariables) {
        this(scriptResolvers, scopeContainer, inputVariableContainer);
        this.storeScriptVariables = storeScriptVariables;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Resolver scriptResolver : this.scriptResolvers) {
            if (!scriptResolver.containsKey(key)) continue;
            return true;
        }
        return this.defaultBindings.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        for (Resolver scriptResolver : this.scriptResolvers) {
            if (!scriptResolver.containsKey(key)) continue;
            return scriptResolver.get(key);
        }
        return this.defaultBindings.get(key);
    }

    @Override
    public Object put(String name, Object value) {
        if (this.storeScriptVariables) {
            Object oldValue = null;
            if (!UNSTORED_KEYS.contains(name)) {
                oldValue = this.scopeContainer.getVariable(name);
                this.scopeContainer.setVariable(name, value);
                return oldValue;
            }
        }
        return this.defaultBindings.put(name, value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
        for (String key : this.inputVariableContainer.getVariableNames()) {
            entries.add((Map.Entry<String, Object>)Pair.of((Object)key, (Object)this.inputVariableContainer.getVariable(key)));
        }
        return entries;
    }

    @Override
    public Set<String> keySet() {
        return this.inputVariableContainer.getVariableNames();
    }

    @Override
    public int size() {
        return this.inputVariableContainer.getVariableNames().size();
    }

    @Override
    public Collection<Object> values() {
        Set variableNames = this.inputVariableContainer.getVariableNames();
        ArrayList<Object> values = new ArrayList<Object>(variableNames.size());
        for (String key : variableNames) {
            values.add(this.inputVariableContainer.getVariable(key));
        }
        return values;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        if (UNSTORED_KEYS.contains(key)) {
            return null;
        }
        return this.defaultBindings.remove(key);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public void addUnstoredKey(String unstoredKey) {
        UNSTORED_KEYS.add(unstoredKey);
    }

    protected Map<String, Object> getVariables() {
        if (this.scopeContainer instanceof VariableScope) {
            return ((VariableScope)this.scopeContainer).getVariables();
        }
        return Collections.emptyMap();
    }
}

