/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.gauth;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthAccount;
import org.apache.syncope.common.rest.api.service.wa.GoogleMfaAuthAccountService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.starter.gauth.WAGoogleMfaAuthTokenRepository;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.credential.BaseGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAGoogleMfaAuthCredentialRepository
extends BaseGoogleAuthenticatorTokenCredentialRepository {
    protected static final Logger LOG = LoggerFactory.getLogger(WAGoogleMfaAuthTokenRepository.class);
    protected final WARestClient waRestClient;

    public WAGoogleMfaAuthCredentialRepository(WARestClient waRestClient, IGoogleAuthenticator googleAuthenticator) {
        super(CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber(), googleAuthenticator);
        this.waRestClient = waRestClient;
    }

    protected GoogleAuthenticatorAccount mapGoogleMfaAuthAccount(GoogleMfaAuthAccount gmfaa) {
        return ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().id(gmfaa.getId())).name(gmfaa.getName())).username(gmfaa.getUsername())).secretKey(gmfaa.getSecretKey())).validationCode(gmfaa.getValidationCode())).scratchCodes(gmfaa.getScratchCodes().stream().map(Number::intValue).collect(Collectors.toList()))).registrationDate(gmfaa.getRegistrationDate())).source(gmfaa.getSource())).build();
    }

    public OneTimeTokenAccount get(long id) {
        try {
            return this.mapGoogleMfaAuthAccount(((GoogleMfaAuthAccountService)this.waRestClient.getService(GoogleMfaAuthAccountService.class)).read(id));
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                LOG.info("Could not locate account for id {}", (Object)id);
            } else {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public OneTimeTokenAccount get(String username, long id) {
        try {
            return ((GoogleMfaAuthAccountService)this.waRestClient.getService(GoogleMfaAuthAccountService.class)).read(username).getResult().stream().filter(account -> account.getId() == id).map(this::mapGoogleMfaAuthAccount).findFirst().orElse(null);
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                LOG.info("Could not locate account for owner {} and id {}", (Object)username, (Object)id);
            } else {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public Collection<? extends OneTimeTokenAccount> get(String username) {
        try {
            return ((GoogleMfaAuthAccountService)this.waRestClient.getService(GoogleMfaAuthAccountService.class)).read(username).getResult().stream().map(this::mapGoogleMfaAuthAccount).toList();
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                LOG.info("Could not locate account for owner {}", (Object)username);
            } else {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return List.of();
        }
    }

    public Collection<? extends OneTimeTokenAccount> load() {
        return ((GoogleMfaAuthAccountService)this.waRestClient.getService(GoogleMfaAuthAccountService.class)).list().getResult().stream().map(this::mapGoogleMfaAuthAccount).toList();
    }

    protected GoogleMfaAuthAccount mapOneTimeTokenAccount(OneTimeTokenAccount otta) {
        return new GoogleMfaAuthAccount.Builder().id(Long.valueOf(otta.getId())).name(otta.getName()).username(otta.getUsername()).secretKey(otta.getSecretKey()).validationCode(Integer.valueOf(otta.getValidationCode())).scratchCodes(otta.getScratchCodes().stream().map(Number::intValue).toList()).registrationDate(ZonedDateTime.now()).source(otta.getSource()).build();
    }

    public OneTimeTokenAccount save(OneTimeTokenAccount otta) {
        GoogleMfaAuthAccount account = this.mapOneTimeTokenAccount(otta);
        ((GoogleMfaAuthAccountService)this.waRestClient.getService(GoogleMfaAuthAccountService.class)).create(account);
        return otta;
    }

    public OneTimeTokenAccount update(OneTimeTokenAccount tokenAccount) {
        GoogleMfaAuthAccount acct = this.mapOneTimeTokenAccount(tokenAccount);
        ((GoogleMfaAuthAccountService)this.waRestClient.getService(GoogleMfaAuthAccountService.class)).update(acct);
        return tokenAccount;
    }

    public void deleteAll() {
        ((GoogleMfaAuthAccountService)this.waRestClient.getService(GoogleMfaAuthAccountService.class)).deleteAll();
    }

    public void delete(String username) {
        try {
            ((GoogleMfaAuthAccountService)this.waRestClient.getService(GoogleMfaAuthAccountService.class)).delete(username);
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                LOG.info("Could not locate account for owner {}", (Object)username);
            }
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void delete(long id) {
        ((GoogleMfaAuthAccountService)this.waRestClient.getService(GoogleMfaAuthAccountService.class)).delete(id);
    }

    public long count() {
        return ((GoogleMfaAuthAccountService)this.waRestClient.getService(GoogleMfaAuthAccountService.class)).list().getTotalCount();
    }

    public long count(String username) {
        try {
            return ((GoogleMfaAuthAccountService)this.waRestClient.getService(GoogleMfaAuthAccountService.class)).read(username).getTotalCount();
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                LOG.info("Could not locate account for owner {}", (Object)username);
            } else {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return 0L;
        }
    }
}

