/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.jexl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.jexl.JexlContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexlTools {
    protected static final Logger LOG = LoggerFactory.getLogger(JexlTools.class);
    protected final JexlEngine jexlEngine;
    protected final JxltEngine jxltEngine;

    public JexlTools(JexlEngine jexlEngine) {
        this.jexlEngine = jexlEngine;
        this.jxltEngine = jexlEngine.createJxltEngine(false);
    }

    public JexlTools(JexlEngine jexlEngine, JxltEngine jxltEngine) {
        this.jexlEngine = jexlEngine;
        this.jxltEngine = jxltEngine;
    }

    public boolean isExpressionValid(String expression) {
        boolean result;
        try {
            this.jexlEngine.createExpression(expression);
            result = true;
        }
        catch (JexlException e) {
            LOG.error("Invalid JEXL expression: {}", (Object)expression, (Object)e);
            result = false;
        }
        return result;
    }

    public Object evaluateExpression(String expression, JexlContext jexlContext) {
        Object result = null;
        if (StringUtils.isNotBlank((CharSequence)expression) && jexlContext != null) {
            try {
                JexlExpression jexlExpression = this.jexlEngine.createExpression(expression);
                result = jexlExpression.evaluate(jexlContext);
            }
            catch (Exception e) {
                LOG.error("Error while evaluating JEXL expression: {}", (Object)expression, (Object)e);
            }
        } else {
            LOG.debug("Expression not provided or invalid context");
        }
        return Optional.ofNullable(result).orElse("");
    }

    public String evaluateTemplate(String template, JexlContext jexlContext) {
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)template) && jexlContext != null) {
            try {
                StringWriter writer = new StringWriter();
                this.jxltEngine.createTemplate(template).evaluate(jexlContext, (Writer)writer);
                result = writer.toString();
            }
            catch (Exception e) {
                LOG.error("Error while evaluating JEXL template: {}", (Object)template, (Object)e);
            }
        } else {
            LOG.debug("Template not provided or invalid context");
        }
        return Optional.ofNullable(result).orElse(template);
    }

    public boolean evaluateMandatoryCondition(String mandatoryCondition, Attributable attributable, DerAttrHandler derAttrHandler) {
        JexlContext jexlContext = new JexlContextBuilder().plainAttrs(attributable.getPlainAttrs()).derAttrs(attributable, derAttrHandler).build();
        return Boolean.parseBoolean(this.evaluateExpression(mandatoryCondition, jexlContext).toString());
    }
}

