/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.entity.am;

import org.apache.syncope.common.lib.to.CASSPClientAppTO;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.to.OIDCRPClientAppTO;
import org.apache.syncope.common.lib.to.SAML2SPClientAppTO;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.syncope.core.persistence.api.entity.am.CASSPClientApp;
import org.apache.syncope.core.persistence.api.entity.am.ClientApp;
import org.apache.syncope.core.persistence.api.entity.am.ClientAppUtils;
import org.apache.syncope.core.persistence.api.entity.am.OIDCRPClientApp;
import org.apache.syncope.core.persistence.api.entity.am.SAML2SPClientApp;

public class ClientAppUtilsFactory {
    public ClientAppUtils getInstance(ClientAppType type) {
        return new ClientAppUtils(type);
    }

    public ClientAppUtils getInstance(ClientApp clientApp) {
        ClientAppType type;
        if (clientApp instanceof SAML2SPClientApp) {
            type = ClientAppType.SAML2SP;
        } else if (clientApp instanceof CASSPClientApp) {
            type = ClientAppType.CASSP;
        } else if (clientApp instanceof OIDCRPClientApp) {
            type = ClientAppType.OIDCRP;
        } else {
            throw new IllegalArgumentException("Invalid client app: " + String.valueOf(clientApp));
        }
        return this.getInstance(type);
    }

    public ClientAppUtils getInstance(Class<? extends ClientAppTO> clientAppClass) {
        ClientAppType type;
        if (clientAppClass == SAML2SPClientAppTO.class) {
            type = ClientAppType.SAML2SP;
        } else if (clientAppClass == CASSPClientAppTO.class) {
            type = ClientAppType.CASSP;
        } else if (clientAppClass == OIDCRPClientAppTO.class) {
            type = ClientAppType.OIDCRP;
        } else {
            throw new IllegalArgumentException("Invalid ClientAppTO app: " + clientAppClass.getName());
        }
        return this.getInstance(type);
    }

    public ClientAppUtils getInstance(ClientAppTO clientAppTO) {
        return this.getInstance(clientAppTO.getClass());
    }
}

