/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.SpringProperties;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.DefaultQueryEnhancer;
import org.springframework.data.jpa.repository.query.JSqlParserQueryEnhancer;
import org.springframework.data.jpa.repository.query.JpaQueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class QueryEnhancerFactory {
    private static final Log LOG = LogFactory.getLog(QueryEnhancerFactory.class);
    private static final NativeQueryEnhancer NATIVE_QUERY_ENHANCER = NativeQueryEnhancer.select();

    static {
        if (PersistenceProvider.ECLIPSELINK.isPresent()) {
            LOG.info((Object)"EclipseLink is in classpath; If applicable, EQL parser will be used.");
        }
        if (PersistenceProvider.HIBERNATE.isPresent()) {
            LOG.info((Object)"Hibernate is in classpath; If applicable, HQL parser will be used.");
        }
    }

    private QueryEnhancerFactory() {
    }

    public static QueryEnhancer forQuery(DeclaredQuery query) {
        if (query.isNativeQuery()) {
            return QueryEnhancerFactory.getNativeQueryEnhancer(query);
        }
        if (PersistenceProvider.HIBERNATE.isPresent()) {
            return JpaQueryEnhancer.forHql(query);
        }
        if (PersistenceProvider.ECLIPSELINK.isPresent()) {
            return JpaQueryEnhancer.forEql(query);
        }
        return JpaQueryEnhancer.forJpql(query);
    }

    private static QueryEnhancer getNativeQueryEnhancer(DeclaredQuery query) {
        if (NATIVE_QUERY_ENHANCER.equals((Object)NativeQueryEnhancer.JSQLPARSER)) {
            return new JSqlParserQueryEnhancer(query);
        }
        return new DefaultQueryEnhancer(query);
    }

    static enum NativeQueryEnhancer {
        AUTO,
        REGEX,
        JSQLPARSER;

        static final String NATIVE_PARSER_PROPERTY = "spring.data.jpa.query.native.parser";
        static final boolean JSQLPARSER_PRESENT;

        static {
            JSQLPARSER_PRESENT = ClassUtils.isPresent((String)"net.sf.jsqlparser.parser.JSqlParser", null);
        }

        static NativeQueryEnhancer select() {
            NativeQueryEnhancer selected = NativeQueryEnhancer.resolve();
            if (selected.equals((Object)JSQLPARSER)) {
                LOG.info((Object)"User choice: Using JSqlParser");
                return JSQLPARSER;
            }
            if (selected.equals((Object)REGEX)) {
                LOG.info((Object)"Using Regex QueryEnhancer");
                return REGEX;
            }
            if (!JSQLPARSER_PRESENT) {
                return REGEX;
            }
            LOG.info((Object)"JSqlParser is in classpath; If applicable, JSqlParser will be used.");
            return JSQLPARSER;
        }

        private static NativeQueryEnhancer resolve() {
            String name = SpringProperties.getProperty((String)NATIVE_PARSER_PROPERTY);
            if (StringUtils.hasText((String)name)) {
                return (NativeQueryEnhancer)ObjectUtils.caseInsensitiveValueOf((Enum[])NativeQueryEnhancer.values(), (String)name);
            }
            return AUTO;
        }
    }
}

