/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.serialization;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public interface Mapper<T> {
    public static final Mapper<Long> LONG = new Mapper<Long>(){

        @Override
        public byte[] toBytes(Long value) {
            byte[] result = new byte[8];
            for (int i = 7; i >= 0; --i) {
                result[i] = (byte)(value & 0xFFL);
                value = value >> 8;
            }
            return result;
        }

        @Override
        public String toString(Long value) {
            return value.toString();
        }
    };
    public static final Mapper<Integer> INT = new Mapper<Integer>(){

        @Override
        public byte[] toBytes(Integer value) {
            byte[] result = new byte[4];
            for (int i = 3; i >= 0; --i) {
                result[i] = (byte)(value & 0xFF);
                value = value >> 8;
            }
            return result;
        }

        @Override
        public String toString(Integer value) {
            return value.toString();
        }
    };
    public static final Mapper<String> STRING = new Mapper<String>(){

        @Override
        public byte[] toBytes(String value) {
            return value.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public String toString(String value) {
            return value;
        }
    };
    public static final Mapper<byte[]> BYTES = new Mapper<byte[]>(){

        @Override
        public byte[] toBytes(byte[] value) {
            return value;
        }

        @Override
        public String toString(byte[] value) {
            return Base64.getEncoder().encodeToString(value);
        }
    };

    public byte[] toBytes(T var1);

    public String toString(T var1);
}

