/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.command.CommandTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.persistence.api.attrvalue.InvalidEntityException;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.provisioning.api.macro.Command;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class CommandLogic
extends AbstractLogic<EntityTO> {
    protected final ImplementationDAO implementationDAO;
    protected final Validator validator;
    protected final Map<String, Command<?>> perContextCommands = new ConcurrentHashMap();

    public CommandLogic(ImplementationDAO implementationDAO, Validator validator) {
        this.implementationDAO = implementationDAO;
        this.validator = validator;
    }

    @PreAuthorize(value="hasRole('IMPLEMENTATION_LIST')")
    @Transactional(readOnly=true)
    public Page<CommandTO> search(String keyword, Pageable pageable) {
        List result = this.implementationDAO.findByTypeAndKeyword("COMMAND", keyword);
        long count = result.size();
        List<CommandTO> commands = result.stream().skip(pageable.getPageSize() * pageable.getPageNumber()).limit(pageable.getPageSize()).map(command -> {
            try {
                return new CommandTO.Builder(command.getKey()).args(ImplementationManager.emptyArgs((Implementation)command)).build();
            }
            catch (Exception e) {
                LOG.error("Could not get arg class for {}", command, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
        return new SyncopePage(commands, pageable, count);
    }

    @PreAuthorize(value="hasRole('IMPLEMENTATION_READ')")
    @Transactional(readOnly=true)
    public CommandTO read(String key) {
        Implementation impl = (Implementation)this.implementationDAO.findById(key).orElseThrow(() -> new NotFoundException("Implementation " + key));
        try {
            return new CommandTO.Builder(impl.getKey()).args(ImplementationManager.emptyArgs((Implementation)impl)).build();
        }
        catch (Exception e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidImplementation);
            sce.getElements().add("Could not build " + impl.getKey());
            throw sce;
        }
    }

    @PreAuthorize(value="hasRole('COMMAND_RUN')")
    public String run(CommandTO command) {
        Command runnable;
        Implementation impl = (Implementation)this.implementationDAO.findById(command.getKey()).orElseThrow(() -> new NotFoundException("Implementation " + command.getKey()));
        try {
            runnable = (Command)ImplementationManager.build((Implementation)impl, () -> this.perContextCommands.get(impl.getKey()), instance -> this.perContextCommands.put(impl.getKey(), (Command<?>)instance));
        }
        catch (Exception e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidImplementation);
            sce.getElements().add("Could not build " + impl.getKey());
            throw sce;
        }
        if (command.getArgs() != null) {
            try {
                Set violations = this.validator.validate((Object)command.getArgs(), new Class[0]);
                if (!violations.isEmpty()) {
                    throw new InvalidEntityException(command.getArgs().getClass().getName(), violations);
                }
            }
            catch (ValidationException e) {
                LOG.error("While validating {}", (Object)command.getArgs(), (Object)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
                sce.getElements().add(e.getMessage());
                throw sce;
            }
        }
        try {
            return runnable.run(command.getArgs() == null ? ImplementationManager.emptyArgs((Implementation)impl) : command.getArgs()).message();
        }
        catch (Exception e) {
            LOG.error("While running {} on {}", new Object[]{command.getKey(), command.getArgs(), e});
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RunError);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    @Override
    protected EntityTO resolveReference(Method method, Object ... args) {
        throw new UnsupportedOperationException();
    }
}

