/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support.mgmr;

import com.google.common.base.Splitter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationResponse;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.configuration.model.support.cookie.PinnableCookieProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.apereo.cas.web.cookie.CookieSameSitePolicy;
import org.apereo.cas.web.support.InvalidCookieException;
import org.apereo.cas.web.support.mgmr.EncryptedCookieValueManager;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.util.StringUtils;

public class DefaultCasCookieValueManager
extends EncryptedCookieValueManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasCookieValueManager.class);
    private static final char COOKIE_FIELD_SEPARATOR = '@';
    private static final int COOKIE_FIELDS_LENGTH = 3;
    private static final long serialVersionUID = -2696352696382374584L;
    private final PinnableCookieProperties cookieProperties;
    private final ObjectProvider<GeoLocationService> geoLocationService;

    public DefaultCasCookieValueManager(CipherExecutor<Serializable, Serializable> cipherExecutor, TenantExtractor tenantExtractor, ObjectProvider<GeoLocationService> geoLocationService, CookieSameSitePolicy cookieSameSitePolicy, PinnableCookieProperties cookieProperties) {
        super(cipherExecutor, tenantExtractor, cookieSameSitePolicy);
        this.geoLocationService = geoLocationService;
        this.cookieProperties = cookieProperties;
    }

    @Override
    protected String buildCompoundCookieValue(String givenCookieValue, HttpServletRequest request) {
        StringBuilder builder = new StringBuilder(givenCookieValue);
        if (this.cookieProperties.isPinToSession()) {
            String userAgent;
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            if (clientInfo != null) {
                String clientLocation = this.cookieProperties.isGeoLocateClientSession() ? this.getClientGeoLocation(clientInfo) : clientInfo.getClientIpAddress();
                builder.append('@').append(clientLocation);
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(userAgent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request)))) {
                throw new IllegalStateException("Request does not specify a user-agent");
            }
            builder.append('@').append(userAgent);
        } else {
            LOGGER.trace("Cookie session-pinning is disabled");
        }
        return builder.toString();
    }

    private String getClientGeoLocation(ClientInfo clientInfo) {
        return this.geoLocationService.stream().map(service -> {
            GeoLocationResponse geoLocation = service.locate(clientInfo.getClientIpAddress());
            if (geoLocation != null && geoLocation.getAddresses() != null && !geoLocation.getAddresses().isEmpty()) {
                return StringUtils.collectionToCommaDelimitedString((Collection)geoLocation.getAddresses());
            }
            return clientInfo.getClientIpAddress();
        }).filter(Objects::nonNull).findFirst().orElseGet(() -> ((ClientInfo)clientInfo).getClientIpAddress());
    }

    @Override
    protected String obtainValueFromCompoundCookie(String value, HttpServletRequest request) {
        String agent;
        String cookieUserAgent;
        List cookieParts = Splitter.on((String)String.valueOf('@')).splitToList((CharSequence)value);
        String cookieValue = (String)cookieParts.getFirst();
        if (!this.cookieProperties.isPinToSession()) {
            LOGGER.trace("Cookie session-pinning is disabled. Returning cookie value as it was provided");
            return cookieValue;
        }
        if (cookieParts.size() != 3) {
            throw new InvalidCookieException("Invalid cookie. Required fields are missing");
        }
        String cookieClientLocationOrIp = (String)cookieParts.get(1);
        if (Stream.of(cookieValue, cookieClientLocationOrIp, cookieUserAgent = (String)cookieParts.get(2)).anyMatch(org.apache.commons.lang3.StringUtils::isBlank)) {
            throw new InvalidCookieException("Invalid cookie. Required fields are empty");
        }
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        if (clientInfo == null) {
            String message = "Unable to match required remote address %s because client ip at time of cookie creation is unknown".formatted(cookieClientLocationOrIp);
            LOGGER.warn(message);
            throw new InvalidCookieException(message);
        }
        if (this.cookieProperties.isGeoLocateClientSession()) {
            String clientLocationOrIp = this.getClientGeoLocation(clientInfo);
            if (!cookieClientLocationOrIp.equals(clientLocationOrIp)) {
                String message = "Invalid cookie. Required remote address %s does not match %s".formatted(cookieClientLocationOrIp, clientLocationOrIp);
                LOGGER.warn(message);
                throw new InvalidCookieException(message);
            }
        } else {
            String clientIpAddress = clientInfo.getClientIpAddress();
            if (!cookieClientLocationOrIp.equals(clientIpAddress)) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.cookieProperties.getAllowedIpAddressesPattern()) || !RegexUtils.find((String)this.cookieProperties.getAllowedIpAddressesPattern(), (String)clientIpAddress)) {
                    String message = "Invalid cookie. Required remote address %s does not match %s".formatted(cookieClientLocationOrIp, clientIpAddress);
                    LOGGER.warn(message);
                    throw new InvalidCookieException(message);
                }
                LOGGER.debug("Required remote address [{}] does not match [{}], but it's authorized to proceed", (Object)cookieClientLocationOrIp, (Object)clientIpAddress);
            }
        }
        if (!cookieUserAgent.equals(agent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request))) {
            String message = "Invalid cookie. Required user-agent %s does not match %s".formatted(cookieUserAgent, agent);
            LOGGER.warn(message);
            throw new InvalidCookieException(message);
        }
        return cookieValue;
    }
}

